/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.models.internal.Task;
import com.urbancode.release.rest.models.internal.TaskExecutionUpdate;

public class TaskExecution
extends Task<TaskExecution> {
    public String status;
    public String result;
    public String externalResult;
    public String externalStatus;
    public TaskExecutionUpdate[] taskUpdates;

    public TaskExecution() {
        this.path = "/taskExecutions/";
        this.oldPath = "/taskExecution/";
        this.writeToOldPath = true;
    }

    public TaskExecution setStatus(Status status) {
        return this.status(status);
    }

    public TaskExecution status(Status status) {
        this.status = status.toString();
        return this;
    }

    public TaskExecution taskUpdates(TaskExecutionUpdate[] updates) {
        this.taskUpdates = updates;
        return this;
    }

    public TaskExecution setTaskUpdate(TaskExecutionUpdate[] updates) {
        this.taskUpdates(updates);
        return this;
    }

    public TaskExecutionUpdate[] getTaskUpdates() {
        return this.taskUpdates;
    }

    public TaskExecution setResult(Result result) {
        return this.result(result);
    }

    public TaskExecution result(Result result) {
        this.result = result.toString();
        return this;
    }

    public TaskExecution externalResult(ExternalResult result) {
        this.externalResult = result.toString();
        return this;
    }

    public TaskExecution setExternalResult(ExternalResult result) {
        return this.externalResult(result);
    }

    public TaskExecution externalStatus(ExternalStatus externalStatus) {
        this.externalStatus = externalStatus.toString();
        return this;
    }

    public TaskExecution setExternalStatus(ExternalStatus status) {
        return this.externalStatus(status);
    }

    public String getExternalResult() {
        return this.externalResult;
    }

    public String getExternalStatus() {
        return this.externalStatus;
    }

    public TaskExecution start() {
        RestAssured.given().put(this.oldPath(this.id) + "/start", new Object[0]);
        return this;
    }

    public TaskExecution startExpectForbidden() {
        RestAssured.given().expect().statusCode(403).when().put(this.oldPath(this.id) + "/start", new Object[0]);
        return this;
    }

    public TaskExecution finish() {
        RestAssured.given().put(this.oldPath(this.id) + "/complete", new Object[0]);
        return this;
    }

    public TaskExecution reopen() {
        RestAssured.given().put(this.oldPath(this.id) + "/reopen", new Object[0]);
        return this;
    }

    public TaskExecution fail() {
        RestAssured.given().put(this.oldPath(this.id) + "/fail", new Object[0]);
        return this;
    }

    public TaskExecution[] getAllExecutingForProvider(String integrationProviderId) {
        return ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path() + integrationProviderId + "/allExecutingTasks", new Object[0])).as(TaskExecution[].class, ObjectMapperType.GSON);
    }

    public TaskExecution[] saveExecutingTasks(TaskExecution[] executingTasks) {
        TaskExecution[] response = (TaskExecution[])((Response)this.query.apply(RestAssured.given()).body((Object)executingTasks, ObjectMapperType.GSON).expect().statusCode(200).when().put(this.path() + "updateExecutingTasks", new Object[0])).as(this.arrayClass(), ObjectMapperType.GSON);
        return response;
    }

    @Override
    public TaskExecution save() {
        log.debug("save()");
        if (this.id == null) {
            this.post();
            return this;
        }
        this.put();
        return (TaskExecution)this.get();
    }

    public static enum ExternalResult {
        NONE,
        SUCCEEDED,
        CANCELED,
        FAULTED;

    }

    public static enum Result {
        SUCCESS,
        FAILURE,
        SKIPPED,
        NOT_APPLICABLE;

    }

    public static enum ExternalStatus {
        PLANNED,
        OPEN,
        EXECUTING,
        CLOSED;

    }

    public static enum Status {
        PLANNED,
        OPEN,
        EXECUTING,
        CLOSED;

    }
}

