/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.ant;

import com.urbancode.air.plugin.ant.com.urbancode.commons.util.IO;
import com.urbancode.air.plugin.ant.com.urbancode.commons.util.StringUtil;
import com.urbancode.air.plugin.ant.com.urbancode.commons.xml.DOMUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ReleaseTask
extends Task {
    private File infoXmlFile;
    private String version;

    public void setInfoXml(File infoXmlFile) {
        this.infoXmlFile = infoXmlFile;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void execute() throws BuildException {
        if (StringUtil.isEmpty(this.version)) {
            throw new BuildException("version is required");
        }
        if (this.version.toLowerCase().contains("dev")) {
            this.log("Skipping plugin release because of dev version");
        } else {
            if (this.infoXmlFile == null) {
                throw new BuildException("infoXml is required");
            }
            if (!this.infoXmlFile.exists()) {
                throw new BuildException("infoXml must be file: " + this.infoXmlFile.getAbsolutePath());
            }
            Document doc = this.loadInfoXmlDocument(this.infoXmlFile);
            this.updateDocumentWithReleaseVersion(doc, this.version);
            this.writeInfoXmlDocument(doc, this.infoXmlFile);
        }
    }

    protected Document loadInfoXmlDocument(File file) throws BuildException {
        Document doc;
        try {
            doc = DOMUtils.loadDocument(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new BuildException(file.getAbsolutePath() + " file not found");
        }
        catch (ParserConfigurationException e) {
            throw new BuildException(file.getAbsolutePath() + " file could not be loaded");
        }
        catch (SAXException e) {
            throw new BuildException(file.getAbsolutePath() + " file is invalid", (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException(file.getAbsolutePath() + " file could not be read");
        }
        return doc;
    }

    protected void updateDocumentWithReleaseVersion(Document doc, String version) {
        Element pluginElement = doc.getDocumentElement();
        Element releaseVersionElement = DOMUtils.getFirstChild(pluginElement, "release-version");
        if (releaseVersionElement == null) {
            throw new BuildException("release-version tag required in info.xml");
        }
        releaseVersionElement.setTextContent(version);
    }

    protected void writeInfoXmlDocument(Document doc, File file) throws BuildException {
        try {
            IO.copy(DOMUtils.documentToStream(doc), file);
        }
        catch (IOException e) {
            throw new BuildException(file.getAbsolutePath() + " file could not be updated", (Throwable)e);
        }
    }
}

