/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.ant.com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.air.plugin.ant.com.urbancode.commons.util.Check;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

@BridgeMethodsAdded
class TranscodeOutputStream
extends OutputStream {
    static final int BB_SIZE = 4096;
    static final int CB_SIZE = 2048;
    private final Writer out;
    private final CharsetDecoder dec;
    private byte[] one;
    private ByteBuffer bb;
    private CharBuffer cb;

    TranscodeOutputStream(CharsetDecoder dec, CharsetEncoder enc, OutputStream out) {
        Check.nonNull(dec);
        Check.nonNull(enc);
        Check.nonNull(out);
        this.out = new OutputStreamWriter(out, enc);
        this.dec = dec;
        this.bb = ByteBuffer.allocate(4096);
        this.cb = CharBuffer.allocate(2048);
    }

    public synchronized void write(int b) throws IOException {
        if (this.one == null) {
            this.one = new byte[1];
        }
        this.one[0] = (byte)b;
        this.write(this.one, 0, 1);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || b.length - off < len) {
            throw new IndexOutOfBoundsException();
        }
        if (this.bb == null) {
            throw new IOException("Stream closed");
        }
        while (len > 0) {
            int n = Math.min(this.bb.remaining(), len);
            this.bb.put(b, off, n);
            len -= n;
            off += n;
            this.bb.flip();
            CoderResult cr = CoderResult.OVERFLOW;
            while (cr == CoderResult.OVERFLOW) {
                cr = this.dec.decode(this.bb, this.cb, false);
                if (cr.isError()) {
                    cr.throwException();
                }
                if (this.cb.position() <= 0) continue;
                this.out.write(this.cb.array(), 0, this.cb.position());
                this.cb.position(0);
            }
            this.bb.compact();
        }
    }

    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.bb == null) {
            return;
        }
        try {
            this.bb.flip();
            CoderResult cr = this.dec.decode(this.bb, this.cb, true);
            if (cr.isError()) {
                cr.throwException();
            }
            if ((cr = this.dec.flush(this.cb)).isError()) {
                cr.throwException();
            }
            if (this.cb.position() > 0) {
                this.out.write(this.cb.array(), 0, this.cb.position());
            }
        }
        finally {
            this.one = null;
            this.bb = null;
            this.cb = null;
            this.out.close();
        }
    }
}

