/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command;

import com.urbancode.air.plugin.ant.org.apache.commons.lang.builder.EqualsBuilder;
import com.urbancode.air.plugin_command.CommandLine;
import com.urbancode.air.plugin_command.Extensible;
import com.urbancode.air.plugin_command.Extension;
import com.urbancode.air.plugin_command.Utils;
import com.urbancode.air.plugin_command.properties.PluginCommandProperty;
import com.urbancode.air.plugin_command.xml.PropertyHolder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command
implements Extensible,
PropertyHolder {
    private String name;
    private String description;
    private List<PluginCommandProperty> propertyList = new ArrayList<PluginCommandProperty>();
    private CommandLine commandLine;
    private String postProcessingScript;
    private List<String> propertyToEnvironmentList = new ArrayList<String>();
    private Extension extension;

    public Command(String name, String description) {
        this.name = name;
        this.description = Utils.removeDuplicateWhitespace(description).trim();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public CommandLine getCommand() {
        return this.commandLine;
    }

    public void setCommand(CommandLine commandLine) {
        this.commandLine = commandLine;
    }

    public String[] getExecuteCommand() {
        return this.commandLine.getExecuteCommand();
    }

    public String getPostProcessingScript() {
        return this.postProcessingScript;
    }

    public void setPostProcessingScript(String postProcessingScript) {
        this.postProcessingScript = postProcessingScript;
    }

    public List<String> getPropertyToEnvironmentList() {
        return this.propertyToEnvironmentList;
    }

    public void setPropertyToEnvironmentList(List<String> propertyToEnvironmentList) {
        this.propertyToEnvironmentList.clear();
        this.propertyToEnvironmentList.addAll(propertyToEnvironmentList);
    }

    @Override
    public Extension getExtension() {
        return this.extension;
    }

    @Override
    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    @Override
    public PluginCommandProperty getPluginProp(String name) {
        PluginCommandProperty matchingProperty = null;
        for (PluginCommandProperty property : this.propertyList) {
            if (!name.equals(property.getName())) continue;
            matchingProperty = property;
            break;
        }
        return matchingProperty;
    }

    @Override
    public List<PluginCommandProperty> getPluginProps() {
        return new ArrayList<PluginCommandProperty>(this.propertyList);
    }

    @Override
    public void addPluginProp(PluginCommandProperty property) {
        this.propertyList.add(property);
    }

    public boolean apiEquals(Command that) {
        boolean result;
        block4: {
            PluginCommandProperty thisProp;
            PluginCommandProperty thatProp;
            result = true;
            HashSet<String> thisPropNames = new HashSet<String>();
            for (PluginCommandProperty thisProp2 : this.propertyList) {
                thisPropNames.add(thisProp2.getName());
            }
            HashSet<String> thatPropNames = new HashSet<String>();
            for (PluginCommandProperty thatProp2 : that.getPluginProps()) {
                thatPropNames.add(thatProp2.getName());
            }
            result = ((Object)thisPropNames).equals(thatPropNames);
            if (result && this.extension != null) {
                result = this.extension.apiEquals(that.extension);
            }
            if (!result) break block4;
            Iterator<PluginCommandProperty> i$ = this.propertyList.iterator();
            while (i$.hasNext() && (result = (thatProp = this.getPluginProp((thisProp = i$.next()).getName())) != null && thisProp.apiEquals(thatProp))) {
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals(this, o);
    }
}

