/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence.hibernate;

import com.urbancode.persistence.PersistenceException;
import com.urbancode.persistence.PersistenceLifecycleHooks;
import com.urbancode.persistence.PersistenceService;
import com.urbancode.persistence.hibernate.AbstractEntity;
import com.urbancode.persistence.hibernate.HibernateUtil;
import java.io.Serializable;
import org.hibernate.LockMode;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatePersistenceService
implements PersistenceService {
    private static final long serialVersionUID = -2224692028138909067L;

    @Override
    public Serializable save(AbstractEntity<? extends Serializable> entity) {
        try {
            Session session = HibernateUtil.getCurrentSession();
            return session.save(entity);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void saveOrUpdate(AbstractEntity<? extends Serializable> entity) {
        try {
            Session session = HibernateUtil.getCurrentSession();
            session.saveOrUpdate(entity);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void update(AbstractEntity<? extends Serializable> entity) {
        try {
            Session session = HibernateUtil.getCurrentSession();
            session.update(entity);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void delete(AbstractEntity<? extends Serializable> entity) {
        try {
            if (entity != null && entity instanceof PersistenceLifecycleHooks) {
                ((PersistenceLifecycleHooks)((Object)entity)).onDelete();
            }
            Session session = HibernateUtil.getCurrentSession();
            session.delete(entity);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void evict(AbstractEntity<? extends Serializable> entity) {
        try {
            Session session = HibernateUtil.getCurrentSession();
            session.evict(entity);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public AbstractEntity<Serializable> merge(AbstractEntity<? extends Serializable> entity) {
        try {
            Session session = HibernateUtil.getCurrentSession();
            return (AbstractEntity)session.merge(entity);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public void lock(AbstractEntity<? extends Serializable> entity, LockMode lockMode) {
        try {
            Session session = HibernateUtil.getCurrentSession();
            session.lock(entity, lockMode);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void refresh(AbstractEntity<? extends Serializable> entity) {
        try {
            Session session = HibernateUtil.getCurrentSession();
            session.refresh(entity);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public void refresh(AbstractEntity<? extends Serializable> entity, LockMode lockMode) {
        try {
            Session session = HibernateUtil.getCurrentSession();
            session.refresh(entity, lockMode);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public AbstractEntity<? extends Serializable> reload(AbstractEntity<? extends Serializable> entity) {
        try {
            return AbstractEntity.getById(entity.getClass(), entity.getId());
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }
}

