/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence.hibernate.audit;

import com.urbancode.persistence.hibernate.AbstractEntity;
import com.urbancode.persistence.hibernate.HibernateUtil;
import com.urbancode.persistence.hibernate.audit.AuditException;
import com.urbancode.persistence.hibernate.audit.Auditable;
import com.urbancode.persistence.hibernate.audit.CrudUtil;
import com.urbancode.persistence.hibernate.audit.IAgentHelper;
import com.urbancode.persistence.hibernate.audit.event.Change;
import com.urbancode.persistence.hibernate.audit.event.CreateAuditEvent;
import com.urbancode.persistence.hibernate.audit.event.DeleteAuditEvent;
import com.urbancode.persistence.hibernate.audit.event.UpdateAuditEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.type.Type;

public class AuditLogInterceptorAndListener
extends EmptyInterceptor
implements PreUpdateEventListener {
    private static final long serialVersionUID = 582549003254963262L;
    private static Logger logger = Logger.getLogger(AuditLogInterceptorAndListener.class);
    private Set<CreateAuditEvent> creates = Collections.synchronizedSet(new HashSet());
    private List<UpdateAuditEvent> updates = new ArrayList<UpdateAuditEvent>();
    private final IAgentHelper agentHelper;

    public AuditLogInterceptorAndListener(IAgentHelper agentHelper) {
        this.agentHelper = agentHelper;
    }

    public void beforeTransactionCompletion(Transaction tx) {
        if (HibernateUtil.getCurrentSession().isDirty()) {
            HibernateUtil.getCurrentSession().flush();
        }
        this.updates.clear();
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (entity.getClass().isAnnotationPresent(Auditable.class)) {
            AbstractEntity auditableEntity = (AbstractEntity)entity;
            DeleteAuditEvent auditEvent = new DeleteAuditEvent(this.agentHelper.getAgent(), auditableEntity);
            try {
                HibernateUtil.getAuditEventProcessor().processAuditEvent(auditEvent);
            }
            catch (AuditException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (entity.getClass().isAnnotationPresent(Auditable.class)) {
            AbstractEntity auditableEntity = (AbstractEntity)entity;
            CreateAuditEvent auditEvent = new CreateAuditEvent(this.agentHelper.getAgent(), auditableEntity);
            this.creates.add(auditEvent);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFlush(Iterator entities) {
        Set<CreateAuditEvent> set = this.creates;
        synchronized (set) {
            HashSet<CreateAuditEvent> currentCreates = new HashSet<CreateAuditEvent>();
            currentCreates.addAll(this.creates);
            this.creates.removeAll(currentCreates);
            for (CreateAuditEvent auditEvent : currentCreates) {
                try {
                    HibernateUtil.getAuditEventProcessor().processAuditEvent(auditEvent);
                }
                catch (AuditException e) {
                    logger.error((Object)"Processing audit event", (Throwable)e);
                }
            }
            try {
                HibernateUtil.getAuditEventProcessor().flush();
            }
            catch (AuditException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        if (event.getEntity().getClass().isAnnotationPresent(Auditable.class)) {
            AbstractEntity entity = (AbstractEntity)event.getEntity();
            Session tempSession = HibernateUtil.getSessionFactory().openSession();
            AbstractEntity oldEntity = (AbstractEntity)tempSession.get(event.getEntity().getClass(), entity.getId());
            if (oldEntity == null) {
                oldEntity = (AbstractEntity)HibernateUtil.getCurrentSession().get(event.getEntity().getClass(), entity.getId());
            }
            try {
                List<Change> changes = CrudUtil.calculateChanges(oldEntity, entity);
                if (!changes.isEmpty()) {
                    UpdateAuditEvent updateEvent = new UpdateAuditEvent(this.agentHelper.getAgent(), entity, changes);
                    boolean alreadyCaptured = false;
                    for (UpdateAuditEvent update : this.updates) {
                        if (!update.equals(updateEvent)) continue;
                        alreadyCaptured = true;
                        break;
                    }
                    if (!alreadyCaptured) {
                        HibernateUtil.getAuditEventProcessor().processAuditEvent(updateEvent);
                        this.updates.add(updateEvent);
                    }
                }
            }
            catch (AuditException e) {
                throw new RuntimeException(e);
            }
            tempSession.close();
        }
        return false;
    }
}

