/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence.hibernate.audit;

import com.urbancode.persistence.hibernate.AbstractEntity;
import com.urbancode.persistence.hibernate.audit.AuditException;
import com.urbancode.persistence.hibernate.audit.Auditable;
import com.urbancode.persistence.hibernate.audit.StringUtil;
import com.urbancode.persistence.hibernate.audit.event.Change;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrudUtil {
    public static List<Change> calculateChanges(AbstractEntity<Serializable> oldEntity, AbstractEntity<Serializable> newEntity) throws AuditException {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Field field : oldEntity.getClass().getDeclaredFields()) {
            Object newValue;
            String property;
            Object oldValue;
            if (!field.isAnnotationPresent(Auditable.class) || (oldValue = CrudUtil.retrieveObjectValue(oldEntity, property = field.getName())) == (newValue = CrudUtil.retrieveObjectValue(newEntity, property))) continue;
            if (oldValue != null) {
                if (oldValue.equals(newValue)) continue;
                if (oldValue instanceof Collection) {
                    if (((Collection)oldValue).isEmpty() && ((Collection)newValue).isEmpty()) continue;
                    Collection oldCollection = (Collection)oldValue;
                    Collection newCollection = (Collection)newValue;
                    Collection newFromOld = CollectionUtils.subtract((Collection)oldCollection, (Collection)newCollection);
                    Collection oldFromNew = CollectionUtils.subtract((Collection)newCollection, (Collection)oldCollection);
                    if (newFromOld.isEmpty() && oldFromNew.isEmpty()) continue;
                }
            }
            Change change = new Change(property, oldValue, newValue);
            changes.add(change);
        }
        return changes;
    }

    public static String getPropertyName(String methodName) {
        if (StringUtil.isEmpty(methodName) || methodName.length() <= 3) {
            return null;
        }
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            String prop = methodName.substring(4);
            char c = Character.toLowerCase(methodName.charAt(3));
            return c + prop;
        }
        return null;
    }

    public static String getGetterMethodName(Class<?> classs, String propertyName) throws NoSuchMethodException {
        if (StringUtil.isEmpty(propertyName) || propertyName.length() <= 0) {
            return null;
        }
        char c = Character.toUpperCase(propertyName.charAt(0));
        String getter = "get" + c + propertyName.substring(1);
        try {
            classs.getDeclaredMethod(getter, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            getter = "is" + c + propertyName.substring(1);
            try {
                classs.getDeclaredMethod(getter, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                throw new NoSuchMethodException("No getter method with 'get' or 'is' for property " + propertyName + " " + "in class " + classs.getCanonicalName());
            }
        }
        return getter;
    }

    public static Object retrieveObjectValue(AbstractEntity<Serializable> entity, String property) throws AuditException {
        if (property.contains(".")) {
            String[] props = property.split("\\.");
            try {
                Method method = entity.getClass().getDeclaredMethod(CrudUtil.getGetterMethodName(entity.getClass(), props[0]), new Class[0]);
                method.setAccessible(true);
                AbstractEntity ivalue = (AbstractEntity)method.invoke(entity, new Object[0]);
                if (ivalue == null) {
                    return null;
                }
                return CrudUtil.retrieveObjectValue(ivalue, property.substring(props[0].length() + 1));
            }
            catch (Exception e) {
                throw new AuditException("Failed to retrieve value for " + property, e);
            }
        }
        try {
            Method method = entity.getClass().getDeclaredMethod(CrudUtil.getGetterMethodName(entity.getClass(), property), new Class[0]);
            method.setAccessible(true);
            return method.invoke(entity, new Object[0]);
        }
        catch (Exception e) {
            throw new AuditException("Failed to retrieve value for " + property, e);
        }
    }

    public static Class<?> retrieveObjectType(AbstractEntity<Serializable> entity, String property) throws AuditException {
        if (property.contains(".")) {
            String[] props = property.split("\\.");
            try {
                Method method = entity.getClass().getMethod(CrudUtil.getGetterMethodName(entity.getClass(), props[0]), new Class[0]);
                AbstractEntity ivalue = (AbstractEntity)method.invoke(entity, new Object[0]);
                return CrudUtil.retrieveObjectType(ivalue, property.substring(props[0].length() + 1));
            }
            catch (Exception e) {
                throw new AuditException("Failed to retrieve value for " + property, e);
            }
        }
        try {
            Method method = entity.getClass().getMethod(CrudUtil.getGetterMethodName(entity.getClass(), property), new Class[0]);
            return method.getReturnType();
        }
        catch (Exception e) {
            throw new AuditException("Failed to retrieve value for " + property, e);
        }
    }

    public static Serializable createEntityUniqueKey(AbstractEntity<Serializable> entity) {
        return entity.getClass().getCanonicalName() + "#" + entity.getId();
    }
}

