/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence.hibernate.audit.event;

import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;

public class Change {
    private final String fieldName;
    private final Object oldValue;
    private final Object newValue;

    public Change(String fieldName, Object oldValue, Object newValue) {
        this.fieldName = fieldName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public String toString() {
        return "Change of '" + this.getFieldName() + "' from '" + this.getOldValue() + "' to '" + this.getNewValue() + "'";
    }

    public boolean equals(Object obj) {
        Change change;
        boolean result = false;
        if (obj instanceof Change && (change = (Change)obj).getFieldName().equals(this.getFieldName())) {
            if (change.getOldValue() == null && this.getOldValue() == null && change.getNewValue() == null && this.getNewValue() == null) {
                result = true;
            } else if (change.getOldValue() != null && this.getOldValue() != null && change.getNewValue() == null && this.getNewValue() == null) {
                result = change.getOldValue() instanceof Collection ? CollectionUtils.isEqualCollection((Collection)((Collection)change.getOldValue()), (Collection)((Collection)this.getOldValue())) : change.getOldValue().equals(this.getOldValue());
            } else if (change.getOldValue() == null && this.getOldValue() == null && change.getNewValue() != null && this.getNewValue() != null) {
                result = change.getNewValue() instanceof Collection ? CollectionUtils.isEqualCollection((Collection)((Collection)change.getNewValue()), (Collection)((Collection)this.getNewValue())) : change.getNewValue().equals(this.getNewValue());
            } else if (change.getOldValue() != null && this.getOldValue() != null && change.getNewValue() != null && this.getNewValue() != null) {
                result = change.getOldValue() instanceof Collection ? CollectionUtils.isEqualCollection((Collection)((Collection)change.getOldValue()), (Collection)((Collection)this.getOldValue())) && CollectionUtils.isEqualCollection((Collection)((Collection)change.getNewValue()), (Collection)((Collection)this.getNewValue())) : change.getOldValue().equals(this.getOldValue()) && change.getNewValue().equals(this.getNewValue());
            }
        }
        return result;
    }

    public int hashCode() {
        int hash = this.fieldName.hashCode();
        if (this.oldValue != null) {
            hash = hash * 31 + this.oldValue.hashCode();
        }
        if (this.newValue != null) {
            hash = hash * 31 + this.newValue.hashCode();
        }
        return hash;
    }
}

