/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineConfiguration;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationConfiguration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.internal.common.IIterationStructureAccess;
import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.AbstractElementBuilder;
import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.process.internal.common.model.ModelGenerator;
import com.ibm.team.process.internal.common.model.customization.TeamCustomizationModel;
import com.ibm.team.process.internal.common.model.settings.ElementBuilder;
import com.ibm.team.process.internal.common.model.specification.DevelopmentLineConfiguration;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationModel;
import com.ibm.team.process.internal.common.model.specification.TeamConfigurationElement;
import com.ibm.team.repository.common.IItemHandle;
import java.util.ArrayList;
import java.util.List;

public class ProcessModelUtilities {
    public static boolean isCurrentIteration(IIterationHandle iteration, IIterationStructureAccess structureAccess) {
        if (iteration == null || structureAccess == null) {
            throw new NullPointerException();
        }
        if (!structureAccess.containsIteration(iteration)) {
            throw new IllegalArgumentException();
        }
        IDevelopmentLine developmentLine = structureAccess.getDevelopmentLine(iteration);
        IIteration currentIteration = structureAccess.getCurrentIteration(developmentLine);
        if (currentIteration != null) {
            List iterationPath = ProcessModelUtilities.computeIterationPath(currentIteration, structureAccess);
            return ProcessModelUtilities.contains(iterationPath, iteration);
        }
        return false;
    }

    private static boolean contains(List iterationPath, IIterationHandle iteration) {
        for (IIteration pathIteration : iterationPath) {
            if (!pathIteration.sameItemId((IItemHandle)iteration)) continue;
            return true;
        }
        return false;
    }

    public static List computeIterationPath(IIteration iteration, IIterationStructureAccess structureAccess) {
        if (iteration == null || structureAccess == null) {
            throw new NullPointerException();
        }
        if (!structureAccess.containsIteration(iteration)) {
            throw new IllegalArgumentException();
        }
        ArrayList<IIteration> path = new ArrayList<IIteration>();
        while (iteration != null) {
            path.add(0, iteration);
            iteration = structureAccess.getParentIteration(iteration);
        }
        return path;
    }

    public static AbstractElement findConfiguration(ProcessSpecificationModel model, IProcessItem item, IIterationStructureAccess structureAccess) {
        if (model == null || item == null || structureAccess == null) {
            throw new NullPointerException();
        }
        if (item instanceof IDevelopmentLine) {
            IDevelopmentLine developmentLine = (IDevelopmentLine)item;
            if (!structureAccess.containsDevelopmentLine(developmentLine)) {
                throw new IllegalArgumentException();
            }
            return (AbstractElement)((Object)ProcessModelUtilities.findDevelopmentLineConfiguration(model, developmentLine.getId()));
        }
        if (item instanceof IIteration) {
            IIteration iteration = (IIteration)item;
            if (!structureAccess.containsIteration(iteration)) {
                throw new IllegalArgumentException();
            }
            IDevelopmentLine developmentLine = structureAccess.getDevelopmentLine(iteration);
            IDevelopmentLineConfiguration devLineConfiguration = ProcessModelUtilities.findDevelopmentLineConfiguration(model, developmentLine.getId());
            if (devLineConfiguration != null) {
                List iterationPath = ProcessModelUtilities.computeIterationPath(iteration, structureAccess);
                return (AbstractElement)((Object)ProcessModelUtilities.findIterationConfiguration(iterationPath, devLineConfiguration.getIterations()));
            }
        }
        return null;
    }

    public static AbstractElement findConfiguration(TeamCustomizationModel model, IProcessItem item, IIterationStructureAccess structureAccess) {
        if (model == null || item == null || structureAccess == null) {
            throw new NullPointerException();
        }
        if (item instanceof IIteration) {
            IIteration iteration = (IIteration)item;
            if (!structureAccess.containsIteration(iteration)) {
                throw new IllegalArgumentException();
            }
            List iterationPath = ProcessModelUtilities.computeIterationPath(iteration, structureAccess);
            return (AbstractElement)((Object)ProcessModelUtilities.findIterationConfiguration(iterationPath, model.getIterationConfigurations()));
        }
        return null;
    }

    public static IDevelopmentLineConfiguration findDevelopmentLineConfiguration(ProcessSpecificationModel model, String id) {
        DevelopmentLineConfiguration[] configurations;
        if (model == null || id == null) {
            throw new NullPointerException();
        }
        TeamConfigurationElement teamConfiguration = model.getTeamConfiguration();
        if (teamConfiguration != null && (configurations = teamConfiguration.getDevelopmentLineConfigurations()) != null) {
            int i = 0;
            while (i < configurations.length) {
                DevelopmentLineConfiguration configuration = configurations[i];
                if (id.equals(configuration.getId())) {
                    return configuration;
                }
                ++i;
            }
        }
        return null;
    }

    private static IIterationConfiguration findIterationConfiguration(List iterationPath, IIterationConfiguration[] configurations) {
        if (configurations != null && configurations.length > 0) {
            IIteration iteration = (IIteration)iterationPath.remove(0);
            int i = 0;
            while (i < configurations.length) {
                IIterationConfiguration configuration = configurations[i];
                if (iteration.getId().equals(configuration.getId())) {
                    if (iterationPath.isEmpty()) {
                        return configuration;
                    }
                    return ProcessModelUtilities.findIterationConfiguration(iterationPath, configuration.getChildIterations());
                }
                ++i;
            }
        }
        return null;
    }

    public static IIteration findCorrespondingIteration(IDevelopmentLine developmentLine, IIterationConfiguration configuration, IIterationStructureAccess structureAccess) {
        if (developmentLine == null || configuration == null || structureAccess == null) {
            throw new NullPointerException();
        }
        List configurationPath = ProcessModelUtilities.computeConfigurationPath(configuration);
        return ProcessModelUtilities.findIteration(configurationPath, structureAccess.getIterations(developmentLine), structureAccess);
    }

    public static IIteration findCorrespondingIteration(IIterationConfiguration configuration, IIterationStructureAccess structureAccess) {
        if (configuration == null || structureAccess == null) {
            throw new NullPointerException();
        }
        List configurationPath = ProcessModelUtilities.computeConfigurationPath(configuration);
        IDevelopmentLineConfiguration devLineConfiguration = (IDevelopmentLineConfiguration)configurationPath.remove(0);
        IDevelopmentLine developmentLine = ProcessModelUtilities.findDevelopmentLine(structureAccess, devLineConfiguration.getId());
        if (developmentLine != null) {
            return ProcessModelUtilities.findIteration(configurationPath, structureAccess.getIterations(developmentLine), structureAccess);
        }
        return null;
    }

    public static IDevelopmentLine findCorrespondingDevelopmentLine(IDevelopmentLineConfiguration configuration, IIterationStructureAccess structureAccess) {
        if (configuration == null || structureAccess == null) {
            throw new NullPointerException();
        }
        return ProcessModelUtilities.findDevelopmentLine(structureAccess, configuration.getId());
    }

    private static List computeConfigurationPath(IIterationConfiguration iterationConfiguration) {
        ArrayList<Object> path = new ArrayList<Object>();
        IIterationConfiguration configuration = iterationConfiguration;
        while (configuration != null) {
            path.add(0, configuration);
            configuration = configuration.getParentIteration();
        }
        IDevelopmentLineConfiguration developmentLine = iterationConfiguration.getDevelopmentLine();
        if (developmentLine != null) {
            path.add(0, developmentLine);
        }
        return path;
    }

    private static IDevelopmentLine findDevelopmentLine(IIterationStructureAccess structureAccess, String id) {
        IDevelopmentLine[] developmentLines = structureAccess.getDevelopmentLines();
        if (developmentLines != null) {
            int i = 0;
            while (i < developmentLines.length) {
                IDevelopmentLine developmentLine = developmentLines[i];
                if (developmentLine.getId().equals(id)) {
                    return developmentLine;
                }
                ++i;
            }
        }
        return null;
    }

    private static IIteration findIteration(List configurationPath, IIteration[] iterations, IIterationStructureAccess structureAccess) {
        if (iterations != null && iterations.length > 0) {
            IIterationConfiguration configuration = (IIterationConfiguration)configurationPath.remove(0);
            int i = 0;
            while (i < iterations.length) {
                IIteration iteration = iterations[i];
                if (iteration.getId().equals(configuration.getId())) {
                    if (configurationPath.isEmpty()) {
                        return iteration;
                    }
                    return ProcessModelUtilities.findIteration(configurationPath, structureAccess.getChildIterations(iteration), structureAccess);
                }
                ++i;
            }
        }
        return null;
    }

    public static IProcessConfigurationElement createConfigurationElement(String configurationXML, AbstractElement parentElement) {
        AbstractModel dummyModel = new AbstractModel(){

            @Override
            public AbstractElementBuilder getRootBuilder() {
                return new ElementBuilder();
            }

            @Override
            public AbstractElement getRoot() {
                List childElements = this.getChildElements();
                if (childElements.size() > 0) {
                    return (AbstractElement)childElements.get(0);
                }
                return null;
            }
        };
        ModelGenerator generator = new ModelGenerator(dummyModel);
        generator.generate(configurationXML);
        AbstractElement element = dummyModel.getRoot();
        element.setParent(parentElement);
        if (parentElement != null) {
            parentElement.addChildElement(element);
        }
        return (IProcessConfigurationElement)((Object)element);
    }
}

