/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model;

import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.BuildContext;
import com.ibm.team.process.internal.common.model.ElementBuilderDirectives;
import com.ibm.team.process.internal.common.model.Messages;
import com.ibm.team.process.internal.common.model.ModelParsingException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public abstract class AbstractElementBuilder {
    public abstract boolean handlesElement(String var1, String var2, String var3);

    public void start(String uri, String localName, String qName, Attributes attributes, BuildContext context) {
        AbstractElement current = context.getCurrentModelElement();
        AbstractElement newElement = this.createElement(current, uri, localName, attributes);
        if (context.getDirective(ElementBuilderDirectives.COMPUTE_ELEMENT_OFFSETS) != null) {
            newElement.setOffsetsForStart(context);
        }
        context.pushCurrentModelElement(current.addChildElement(newElement));
    }

    protected AbstractElement createElement(AbstractElement current, String uri, String localName, Attributes attributes) {
        throw new UnsupportedOperationException(Messages.getCommonString("AbstractElementBuilder.0"));
    }

    public void end(String uri, String localName, BuildContext context) {
        if (context.getDirective(ElementBuilderDirectives.COMPUTE_ELEMENT_OFFSETS) != null) {
            AbstractElement current = context.getCurrentModelElement();
            current.setOffsetsForEnd(context);
        }
        context.popCurrentModelElement();
    }

    public void characters(char[] buf, int start, int count, BuildContext context) throws SAXParseException {
        String string = new String(buf, start, count).trim();
        if (string.length() > 0) {
            throw new ModelParsingException(NLS.bind(Messages.getCommonString("AbstractElementBuilder.1"), string), context);
        }
    }

    public AbstractElementBuilder childStart(String uri, String localName, String qName, Attributes attributes, BuildContext context) throws SAXParseException {
        throw new ModelParsingException(NLS.bind(Messages.getCommonString("AbstractElementBuilder.2"), qName), context);
    }

    public void childEnd(String uri, String localNameName, String qName, BuildContext parsingContext) {
    }
}

