/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.BaseCcComponentInfo;
import com.ibm.rational.wvcm.ct.BaseCcSubVobCompRootInfo;
import com.ibm.rational.wvcm.ct.BaseCcSubVobCompRootInfoMap;
import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTBranch;
import com.ibm.rational.wvcm.ct.CTBranchBaseline;
import com.ibm.rational.wvcm.ct.CTControllableFolder;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public class CTBaseCCView
extends CTView {
    private final CCaseLib cc;

    CTBaseCCView(Location location, CTProvider provider) throws WvcmException {
        super(location, provider);
        this.cc = provider.getCCaseLib();
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Workspace.CONFIGURATION_ROOT_FOLDER_HOME)) {
            return this.computeCRFH(feedback);
        }
        if (propertyName.equals((Object)Workspace.CURRENT_ACTIVITY_LIST)) {
            return new ArrayList();
        }
        if (propertyName.equals((Object)Workspace.ACTIVITY_FOLDER_LIST)) {
            return null;
        }
        if (propertyName.equals((Object)Workspace.BASELINE_CONTROLLED_FOLDER_LIST)) {
            return this.getBaselineControlledFolderList(feedback);
        }
        if (propertyName.equals((Object)Workspace.CONTROLLABLE_RESOURCE_HOME)) {
            return this.getControllableResourceHome(feedback);
        }
        if (propertyName.equals((Object)Workspace.STREAM)) {
            return this.getBranch();
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public Object computeCRFH(SrvcFeedback feedback) throws WvcmException {
        String defaultCompVobTagPrefix;
        String defaultCompVobTag;
        CTProvider p = this.provider();
        String compVobTagValue = p.lookupCompVobTagValue();
        String compVobTagPrefixValue = p.lookupCompVobTagPrefixValue();
        if (compVobTagValue != null && compVobTagValue.length() > 0 && (defaultCompVobTag = p.getDefaultCompVobTag(feedback)) != null) {
            CTControllableFolder value = this.computeConfigRootFolderHome(defaultCompVobTag, feedback);
            return value;
        }
        if (compVobTagPrefixValue != null && compVobTagPrefixValue.length() > 0 && (defaultCompVobTagPrefix = p.getDefaultCompVobTagPrefix(feedback)) != null) {
            CTControllableFolder linuxValue = this.computeConfigRootFolderHome(defaultCompVobTagPrefix, feedback);
            return linuxValue;
        }
        return this;
    }

    public void doCheckinAll(String comment, ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        String brtypeName = this.location().getContextLocation(CTLocation.Kind.BRTYPE).getDisplayName();
        List<String> vobPaths = this.cc.getCheckoutVobPathList(brtypeName, feedback);
        if (!vobPaths.isEmpty()) {
            this.checkinAllHelper(comment, flags, vobPaths, this.getViewTag(), feedback);
            this.cc.clearCheckoutVOBPathList(brtypeName, feedback);
        }
    }

    @Override
    public synchronized String getStreamSelector(SrvcFeedback feedback) throws WvcmException {
        CTLocation location = this.location();
        CTLocation brtypeLoc = location.getContextLocation(CTLocation.Kind.BRTYPE);
        CTLocation lbtypeLoc = location.lookupContextLocation(CTLocation.Kind.LBTYPE);
        String brtype = brtypeLoc.getDisplayName();
        String lbtype = null;
        if (lbtypeLoc != null) {
            lbtype = lbtypeLoc.getDisplayName();
        }
        if (brtype == null) {
            throw new IllegalStateException("Context location for base CC view is missing branch type");
        }
        String selector = brtype;
        if (lbtype != null) {
            selector = String.valueOf(selector) + "_" + lbtype;
        }
        return selector;
    }

    public static CTBaseCCView doCreateGeneratedResource(CTProvider provider, Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTLocation loc = (CTLocation)location;
        String cleanName = CCaseLib.cleanName(loc.getDisplayName());
        if (updates == null) {
            throw new IllegalArgumentException("A workspace must have either a target or isolated-target property");
        }
        boolean isolatedTarget = false;
        PropValue streamValue = updates.get(Workspace.TARGET);
        if (streamValue != null) {
            updated.add(Workspace.TARGET);
        } else {
            isolatedTarget = true;
            streamValue = updates.get(Workspace.ISOLATED_TARGET);
            if (streamValue == null) {
                throw new IllegalArgumentException("A workspace must have either a target or isolated-target property");
            }
            updated.add(Workspace.ISOLATED_TARGET);
        }
        CTLocation streamLoc = (CTLocation)((Object)streamValue.get_value());
        CTLocation brtypeLoc = streamLoc.lookupContextLocation(CTLocation.Kind.BRTYPE);
        CTLocation lbtypeLoc = streamLoc.lookupContextLocation(CTLocation.Kind.LBTYPE);
        if (isolatedTarget) {
            if (brtypeLoc != null) {
                throw new IllegalArgumentException("Isolated workspaces must not have a branch type");
            }
            if (lbtypeLoc == null) {
                throw new IllegalArgumentException("Isolated workspaces must have a backstop label type");
            }
        } else if (brtypeLoc == null) {
            throw new IllegalArgumentException("Non-isolated workspaces must have a branch type");
        }
        CTBranch branch = new CTBranch((Location)streamLoc, provider);
        CCaseLib cc = provider.getCCaseLib();
        String viewTag = cc.makeView(cleanName, null, feedback);
        CTLocation resultLoc = CTLocation.createBaseViewLocation(viewTag, brtypeLoc, lbtypeLoc);
        CTBaseCCView result = new CTBaseCCView((Location)resultLoc, provider);
        result.setConfigSpec(branch.getConfigSpec(feedback), feedback);
        return result;
    }

    public <T extends SrvcResource> void doMerge(List<T> sourceLocations, Workspace.MergeFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        for (SrvcResource o : sourceLocations) {
            if (o instanceof CTBranch) {
                String wsStreamSel;
                CTBranch source = (CTBranch)o;
                String streamSel = source.getDisplayName(true, feedback);
                if (!streamSel.equals(wsStreamSel = this.getStreamSelector(feedback))) {
                    throw new IllegalArgumentException("Branch/view mismatch");
                }
                this.cc.setcsCurrent(this.getViewTag(), feedback);
                this.flush(feedback);
                continue;
            }
            throw new IllegalArgumentException("Can't merge non-branch into base ClearCase view");
        }
    }

    private CTBranch getBranch() throws WvcmException {
        CTLocation brtypeLoc = this.location().lookupContextLocation(CTLocation.Kind.BRTYPE);
        CTLocation lbtypeLoc = this.location().lookupContextLocation(CTLocation.Kind.LBTYPE);
        CTLocation branchLoc = CTLocation.createBranchLocation(brtypeLoc, lbtypeLoc);
        CTBranch branch = new CTBranch((Location)branchLoc, this.provider());
        return branch;
    }

    private List<CTControllableFolder> getBaselineControlledFolderList(SrvcFeedback feedback) throws WvcmException {
        List<String> tokens = this.getVobComponentList(feedback);
        ArrayList<CTControllableFolder> result = new ArrayList<CTControllableFolder>();
        for (String comp : tokens) {
            List<CTControllableFolder> bcfs = this.createBcfsFromVobComponent(comp, feedback);
            result.addAll(bcfs);
        }
        return result;
    }

    private List<CTControllableFolder> createBcfsFromVobComponent(String compUsel, SrvcFeedback feedback) throws WvcmException {
        ArrayList<CTControllableFolder> results = new ArrayList<CTControllableFolder>();
        CTProvider p = this.provider();
        CCaseObjInfo compInfo = CCaseObjInfo.getObjInfo(this.cc, compUsel, feedback);
        BaseCcComponentInfo info = BaseCcComponentInfo.valueOf(compInfo, feedback);
        if (!info.isUcmComponent()) {
            String path = info.vobTag;
            BaseCcSubVobCompRootInfoMap subVOBCompMap = CTBaseCCView.getSubVobPathMap(p, this.getViewTag(), path, feedback);
            if (subVOBCompMap.size() > 0) {
                for (String elemGPaths : subVOBCompMap.keySet()) {
                    BaseCcSubVobCompRootInfo rootInfo = (BaseCcSubVobCompRootInfo)subVOBCompMap.get(elemGPaths);
                    IPath iPathWithoutVerExt = rootInfo.iPathWithoutVerExt;
                    if (iPathWithoutVerExt == null) continue;
                    CTLocation loc = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, iPathWithoutVerExt.toString());
                    results.add(new CTControllableFolder((Location)loc, p));
                }
            } else {
                path = CommonUtils.canonicalizePathname(String.valueOf(CCaseLib.getPathIntoView(this.getViewTag())) + path);
                CTLocation bcfLoc = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, path);
                results.add(new CTControllableFolder((Location)bcfLoc, p));
            }
        } else {
            String path = this.cc.getComponentRootDirPathname(compUsel, this.getViewTag(), feedback);
            CTLocation bcfLoc = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, path);
            results.add(new CTControllableFolder((Location)bcfLoc, p));
        }
        return results;
    }

    private CTControllableFolder getControllableResourceHome(SrvcFeedback feedback) throws WvcmException {
        CTControllableFolder bcf = null;
        List<CTControllableFolder> bcfs = this.getBaselineControlledFolderList(feedback);
        if (bcfs.size() >= 1) {
            bcf = bcfs.get(0);
        }
        return bcf;
    }

    private List<String> getVobComponentList(SrvcFeedback feedback) throws WvcmException {
        CTLocation brtypeLoc = this.location().getContextLocation(CTLocation.Kind.BRTYPE);
        String vobComps = this.cc.getAttr("com.ibm.team.interop_VobComponent", brtypeLoc.getDisplayName(), feedback);
        if (vobComps == null) {
            return Collections.emptyList();
        }
        return this.parseVobCompsAttrValue(vobComps);
    }

    protected List<String> parseVobCompsAttrValue(String vobComps) {
        return Arrays.asList(vobComps.split(CTLocation.INFO_SEPARATOR_REGEX));
    }

    public void addVobComponentToList(String vobSelector, SrvcFeedback feedback) throws WvcmException {
        CTLocation brtypeLoc = this.location().getContextLocation(CTLocation.Kind.BRTYPE);
        String vobComps = this.cc.getAttr("com.ibm.team.interop_VobComponent", brtypeLoc.getDisplayName(), feedback);
        if (vobComps == null) {
            vobComps = vobSelector;
        } else {
            List<String> currentList = this.parseVobCompsAttrValue(vobComps);
            String string = vobComps = currentList.contains(vobSelector) ? null : String.valueOf(vobComps) + CTLocation.INFO_SEPARATOR_STRING + vobSelector;
        }
        if (vobComps != null) {
            this.cc.setAttr("com.ibm.team.interop_VobComponent", brtypeLoc.getDisplayName(), vobComps, true, feedback);
        }
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Workspace.CURRENT_ACTIVITY_LIST)) {
            return;
        }
        super.setPropertyFromClient(propertyName, value, initialize, feedback);
    }

    @Override
    public void prepareToWrite(String pathname, SrvcFeedback feedback) throws WvcmException {
        String viewTag = this.getViewTag();
        this.cc.checkoutIgnoreExpectedFailures(viewTag, pathname, null, feedback);
        CTLocation brtypeLoc = this.location().getContextLocation(CTLocation.Kind.BRTYPE);
        this.cc.setCheckoutVOBList(brtypeLoc.getDisplayName(), pathname, feedback);
    }

    @Override
    public <T extends SrvcResource> void doUpdate(List<T> sourceList, SrvcFeedback feedback) throws WvcmException {
        if (sourceList != null && !sourceList.isEmpty()) {
            Map<String, CTBranchBaseline.BaselineInfo> componentRules;
            int initialCapacity = sourceList.size();
            String configSpec = this.getConfigSpec(feedback);
            List<String> configSpecLines = Arrays.asList(configSpec.split("\n"));
            Map<String, CTBranchBaseline.BaselineInfo> updateBaselines = componentRules = ConfigSpec.parse(this.cc, configSpecLines, feedback);
            ArrayList<String> lbtypeSelectors = new ArrayList<String>(initialCapacity);
            for (T source : sourceList) {
                if (!(source instanceof CTBranchBaseline)) continue;
                CTBranchBaseline baseline = (CTBranchBaseline)((Object)source);
                CTBranchBaseline.BaselineInfo info = baseline.getInfo(this, feedback);
                updateBaselines.put(info.compInfo.crdvmsUsel, info);
                lbtypeSelectors.add(info.lbtypeSelector);
            }
            if (!updateBaselines.isEmpty()) {
                Map<String, Boolean> lockStatuses = this.cc.getLockStatus(lbtypeSelectors, feedback);
                ArrayList<String> unlockedLabels = new ArrayList<String>();
                for (String labelSel : lockStatuses.keySet()) {
                    boolean status = lockStatuses.get(labelSel);
                    if (status) continue;
                    unlockedLabels.add(labelSel);
                }
                if (unlockedLabels.isEmpty()) {
                    CTBranch branch = this.getBranch();
                    configSpecLines = branch.setBaselines(this, updateBaselines, feedback);
                    this.setConfigSpec(configSpecLines.toArray(new String[configSpecLines.size()]), feedback);
                } else {
                    StringBuffer labels = new StringBuffer();
                    for (String labelType : unlockedLabels) {
                        labels.append(String.valueOf(labelType) + "\n");
                    }
                    String exceptionMessage = NLS.bind((String)Messages.CCaseLib_ERROR_UNLOCKED_LABELS, (Object)labels.toString());
                    throw new WvcmException(exceptionMessage, WvcmException.ReasonCode.FORBIDDEN);
                }
            }
        }
    }

    private CTBranchBaseline.BaselineInfo lookupBaselineInfo(BaseCcComponentInfo compInfo, SrvcFeedback feedback) throws WvcmException {
        String configSpec = this.getConfigSpec(feedback);
        List<String> configSpecLines = Arrays.asList(configSpec.split("\n"));
        Map<String, CTBranchBaseline.BaselineInfo> componentRules = ConfigSpec.parse(this.cc, configSpecLines, feedback);
        String crdvmsUsel = compInfo.crdvmsUsel;
        return componentRules.get(crdvmsUsel);
    }

    public String getLabelTypeSelectorForComponent(BaseCcComponentInfo compInfo, SrvcFeedback feedback) throws WvcmException {
        CTBranchBaseline.BaselineInfo info = this.lookupBaselineInfo(compInfo, feedback);
        String backstopLbtypeSelector = this.location().getContextLocation(CTLocation.Kind.LBTYPE).getDisplayName();
        String result = info != null ? info.lbtypeSelector : backstopLbtypeSelector;
        return result;
    }

    public static class ConfigSpec {
        private static final String COMMENT_CHAR = String.valueOf('#');
        public static final String BRANCH_INFO = String.valueOf(COMMENT_CHAR) + "BRANCH=";
        public static final String LABEL_INFO = String.valueOf(COMMENT_CHAR) + "LABEL=";
        private static final String BASECC_CS = String.valueOf(COMMENT_CHAR) + "BaseCCIntegration";
        private static final String ELEMENT_STAR_SPACE = "element * ";
        private static final String ELEMENT_STAR_SPACE_3DOT = "element * ...";
        private static final String MKBRANCH = " -mkbranch ";
        private static final String ZERO_MKBRANCH = "0 -mkbranch ";
        private static final String NOCHECKOUT = " -nocheckout";
        List<String> preamble = new ArrayList<String>(3);
        Map<String, CTBranchBaseline.BaselineInfo> componentRules;
        List<String> generalRules;
        private static String COMPONENT_RULE_IN_CONFIG_SPEC_FMT = "element \"[%s=%s]%s/...\" %s %s # %s";
        private static Pattern COMPONENT_RULE_IN_CONFIG_SPEC_PATTERN = Pattern.compile("element \\\"\\[([0-9a-f]+)=(\\S+)\\](\\S*)/...\\\" (\\S+)  -nocheckout( " + COMMENT_CHAR + " " + "(\\S+))?");

        public ConfigSpec(CCaseLib cc, String brtype, String lbtype, String brtypeSelector, String lbtypeSelector, SrvcFeedback feedback) throws WvcmException {
            this.preamble.add(BASECC_CS);
            if (brtypeSelector != null) {
                this.preamble.add(String.valueOf(BRANCH_INFO) + brtypeSelector + BRANCH_INFO);
            }
            if (lbtypeSelector != null) {
                this.preamble.add(String.valueOf(LABEL_INFO) + lbtypeSelector + LABEL_INFO);
            }
            this.componentRules = new HashMap<String, CTBranchBaseline.BaselineInfo>();
            this.generalRules = new ArrayList<String>(4);
            if (brtype == null) {
                this.generalRules.add(ELEMENT_STAR_SPACE + lbtype + NOCHECKOUT);
                this.generalRules.add(ELEMENT_STAR_SPACE + CommonUtils.FWDSLASH + cc.getMainBranchName(ObjSelUtils.getObjSelVobSel(lbtypeSelector), feedback) + CommonUtils.FWDSLASH + '0');
            } else {
                this.generalRules.add("element * CHECKEDOUT");
                this.generalRules.add(ELEMENT_STAR_SPACE_3DOT + CommonUtils.FWDSLASH + brtype + CommonUtils.FWDSLASH + "LATEST");
                if (lbtype != null) {
                    this.generalRules.add(ELEMENT_STAR_SPACE + lbtype + MKBRANCH + brtype);
                }
                this.generalRules.add(ELEMENT_STAR_SPACE + CommonUtils.FWDSLASH + cc.getMainBranchName(ObjSelUtils.getObjSelVobSel(brtypeSelector), feedback) + CommonUtils.FWDSLASH + ZERO_MKBRANCH + brtype);
            }
        }

        List<String> toStrings(CTBaseCCView view, SrvcFeedback feedback) throws WvcmException {
            int componentRulesCount = this.componentRules.size();
            if (componentRulesCount > 0 && (view == null || feedback == null)) {
                throw new IllegalStateException("Cannot generate a configuration specification with component rules without being given a view");
            }
            int initialCapacity = this.preamble.size() + componentRulesCount + this.generalRules.size();
            ArrayList<String> results = new ArrayList<String>(initialCapacity);
            results.addAll(this.preamble);
            for (String crdeUsel : this.componentRules.keySet()) {
                CTBranchBaseline.BaselineInfo blInfo = this.componentRules.get(crdeUsel);
                BaseCcComponentInfo compInfo = blInfo.compInfo;
                String uuid = compInfo.vobUuid.replaceAll("\\.", CTProvider.EMPTY_STRING).replaceAll("\\:", CTProvider.EMPTY_STRING);
                String relativePath = compInfo.getRelativePath(view, feedback);
                String line = String.format(COMPONENT_RULE_IN_CONFIG_SPEC_FMT, uuid, compInfo.vobTag, relativePath, blInfo.lbtypeName, NOCHECKOUT, crdeUsel);
                results.add(line.toString());
            }
            results.addAll(this.generalRules);
            return results;
        }

        public List<String> setBaselines(CTBaseCCView view, Map<String, CTBranchBaseline.BaselineInfo> updateBaselines, SrvcFeedback feedback) throws WvcmException {
            for (String crdeUsel : updateBaselines.keySet()) {
                this.componentRules.put(crdeUsel, updateBaselines.get(crdeUsel));
            }
            return this.toStrings(view, feedback);
        }

        public static Map<String, CTBranchBaseline.BaselineInfo> parse(CCaseLib cc, List<String> configSpecLines, SrvcFeedback feedback) throws WvcmException {
            HashMap<String, CTBranchBaseline.BaselineInfo> results = new HashMap<String, CTBranchBaseline.BaselineInfo>();
            for (String line : configSpecLines) {
                Matcher m = COMPONENT_RULE_IN_CONFIG_SPEC_PATTERN.matcher(line);
                if (!m.find()) continue;
                String vobUuid = m.group(1);
                String vobTag = m.group(2);
                String relativePath = m.group(3);
                String lbtypeName = m.group(4);
                int groupCount = m.groupCount();
                String crdvmsUsel = groupCount == 6 ? m.group(6) : (relativePath != null && relativePath.length() > 0 ? cc.getComponentSelectorFromComponentRoot(String.valueOf(vobTag) + CommonUtils.FWDSLASH + relativePath, feedback) : vobUuid);
                BaseCcComponentInfo compInfo = new BaseCcComponentInfo(null, vobTag, vobUuid, crdvmsUsel, relativePath);
                String lbTypeSelector = cc.getExtendedName(null, ObjSelUtils.formatSelector("lbtype", lbtypeName, vobTag), feedback);
                CTBranchBaseline.BaselineInfo blInfo = new CTBranchBaseline.BaselineInfo(lbTypeSelector, lbtypeName, compInfo);
                results.put(crdvmsUsel, blInfo);
            }
            return results;
        }
    }
}

