/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;

public class Collision
implements ICollision {
    private final IShareable shareable;
    private final IShare share;
    private final ArrayList<ILoadLocation> locations;
    private final boolean alreadyExists;
    private ILoadLocation loadLocation;
    private Object lock = new Object();
    private IStatus status;

    public Collision(IShareable shareable, IShare share, ILoadLocation loadLocation, boolean alreadyExists) {
        this.shareable = shareable;
        this.share = share;
        this.locations = new ArrayList();
        this.locations.add(loadLocation);
        this.alreadyExists = alreadyExists;
    }

    @Override
    public IShareable getShareable() {
        return this.shareable;
    }

    @Override
    public IShare getShare() {
        return this.share;
    }

    @Override
    public IStatus getStatus() {
        if (this.status == null) {
            ISharingDescriptor descriptor;
            String name = this.shareable.getLocalPath().toString();
            if (this.share != null) {
                ILocalChange[] changes;
                descriptor = this.share.getSharingDescriptor();
                if (this.share != null) {
                    name = String.valueOf(name) + " [" + descriptor.getConnectionName() + " - " + descriptor.getComponentName() + "]";
                }
                if ((changes = FileSystemCore.getSharingManager().getLocalChangeManager().getPendingChanges(new IShare[]{this.share})).length > 0) {
                    name = NLS.bind((String)Messages.Collision_0, (Object[])new Object[]{name, changes.length}, (Object[])new Object[0]);
                }
            }
            if (this.alreadyExists) {
                if (this.share == null || this.share.getSharingDescriptor() == null) {
                    this.status = FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.Collision_1, (Object)name, (Object[])new Object[0]), null);
                } else {
                    descriptor = this.share.getSharingDescriptor();
                    UUID descriptorId = descriptor.getRepositoryId();
                    IContextHandle descriptorConnectionHandle = descriptor.getConnectionHandle();
                    IComponentHandle descriptorComponent = descriptor.getComponent();
                    for (ILoadLocation location : this.locations) {
                        if (!location.getConnection().teamRepository().getId().equals((Object)descriptorId) || !location.getConnection().getContextHandle().equals((Object)descriptorConnectionHandle) || !location.getComponent().equals((Object)descriptorComponent)) continue;
                        this.status = FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.Collision_2, (Object)name, (Object[])new Object[0]), null);
                        break;
                    }
                    if (this.status == null) {
                        this.status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.Collision_3, (Object)name, (Object[])new Object[0]), null);
                    }
                }
            } else if (this.locations.size() > 1) {
                String firstComponent = this.locations.get(0).getComponent().getName();
                String secondComponent = this.locations.get(1).getComponent().getName();
                this.status = FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.Collision_4, (Object)name, (Object[])new Object[]{firstComponent, secondComponent}), null);
            } else {
                this.status = FileSystemStatusUtil.getStatusFor(2, name, null);
            }
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILoadLocation getLoadLocation() {
        Object object = this.lock;
        synchronized (object) {
            return this.loadLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ILoadLocation> getLocations() {
        Object object = this.lock;
        synchronized (object) {
            return this.locations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoadLocation(ILoadLocation location) {
        Object object = this.lock;
        synchronized (object) {
            this.loadLocation = location;
        }
    }

    @Override
    public boolean collidedWithExistingContent() {
        return this.alreadyExists;
    }
}

