/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load.loadRules;

import com.ibm.team.filesystem.client.operations.LoadRuleSerializationDilemmaHandler;
import com.ibm.team.filesystem.common.internal.util.StringMatcher;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ChildLoadFilter {
    private boolean include;
    private Set<String> nameFilter;
    private Set<StringMatcher> patternFilter;
    private String type;

    public ChildLoadFilter(String type, boolean include) {
        this.type = type;
        this.include = include;
        this.nameFilter = new HashSet<String>();
        this.patternFilter = new HashSet<StringMatcher>();
    }

    public void addName(String name) {
        this.nameFilter.add(name);
    }

    public void addPattern(String name) {
        this.patternFilter.add(new StringMatcher(name, false, false));
    }

    public boolean isInclude() {
        return this.include;
    }

    public Map<String, IVersionableHandle> applyFilter(Map<String, IVersionableHandle> children) {
        HashMap<String, IVersionableHandle> result;
        block13: {
            block11: {
                block12: {
                    if (!this.include) break block11;
                    if (!this.nameFilter.isEmpty() || !this.patternFilter.isEmpty()) break block12;
                    result = children;
                    break block13;
                }
                result = new HashMap();
                if (!this.nameFilter.isEmpty()) {
                    for (String string : this.nameFilter) {
                        IVersionableHandle child = children.get(string);
                        if (child == null) continue;
                        result.put(string, child);
                    }
                }
                if (this.patternFilter.isEmpty()) break block13;
                block1: for (Map.Entry entry : children.entrySet()) {
                    String childName = (String)entry.getKey();
                    if (result.containsKey(childName)) continue;
                    for (StringMatcher matcher : this.patternFilter) {
                        if (!matcher.match(childName)) continue;
                        result.put(childName, (IVersionableHandle)entry.getValue());
                        continue block1;
                    }
                }
                break block13;
            }
            if (this.nameFilter.isEmpty() && this.patternFilter.isEmpty()) {
                result = children;
            } else {
                result = new HashMap<String, IVersionableHandle>(children);
                if (!this.nameFilter.isEmpty()) {
                    for (String string : this.nameFilter) {
                        result.remove(string);
                    }
                }
                if (!this.patternFilter.isEmpty()) {
                    Iterator iterator = result.entrySet().iterator();
                    block4: while (iterator.hasNext()) {
                        Map.Entry childEntry = iterator.next();
                        String childName = (String)childEntry.getKey();
                        for (StringMatcher matcher : this.patternFilter) {
                            if (!matcher.match(childName)) continue;
                            iterator.remove();
                            continue block4;
                        }
                    }
                }
            }
        }
        return result;
    }

    public void addNames(Collection<String> names) {
        this.nameFilter.addAll(names);
    }

    public void toRule(Document document, Element parent, LoadRuleSerializationDilemmaHandler preferences, IProgressMonitor progress) {
        if (!this.nameFilter.isEmpty() || !this.patternFilter.isEmpty()) {
            Element element = document.createElement(this.type);
            if (parent != null) {
                parent.appendChild(element);
            } else {
                document.appendChild(element);
            }
            for (String name : this.nameFilter) {
                Element nameElement = document.createElement("filter");
                nameElement.setAttribute("name", name);
                element.appendChild(nameElement);
            }
            for (StringMatcher pattern : this.patternFilter) {
                Element patternElement = document.createElement("filter");
                patternElement.setAttribute("pattern", pattern.getPattern());
                element.appendChild(patternElement);
            }
        }
    }
}

