/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load.loadRules;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILoadFilter;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.load.LoadFilter;
import com.ibm.team.filesystem.client.internal.load.loadRules.ChildLoadFilter;
import com.ibm.team.filesystem.client.internal.load.loadRules.ItemLoadRequest;
import com.ibm.team.filesystem.client.internal.load.loadRules.LoadRule2;
import com.ibm.team.filesystem.client.internal.load.loadRules.ParentLoadRequest;
import com.ibm.team.filesystem.client.internal.load.loadRules.RelativeLoadLocation;
import com.ibm.team.filesystem.client.internal.load.loadRules.SandboxExaminerDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ILoadRule2;
import com.ibm.team.filesystem.client.operations.ISandboxExaminerOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class SandboxExaminer
extends FileSystemOperation
implements ISandboxExaminerOperation {
    private Map<ISandbox, Map<IWorkspaceConnection, Map<UUID, IComponentHandle>>> requests;
    private SandboxExaminerDilemmaHandler problemHandler;
    private Map<ISandbox, Collection<ILoadRule2>> loadRules;

    public SandboxExaminer(SandboxExaminerDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? SandboxExaminerDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? SandboxExaminerDilemmaHandler.getDefault() : dilemmaHandler;
        this.requests = new HashMap<ISandbox, Map<IWorkspaceConnection, Map<UUID, IComponentHandle>>>();
        this.loadRules = new HashMap<ISandbox, Collection<ILoadRule2>>();
    }

    @Override
    public void inspect(ISandbox sandbox, IWorkspaceConnection workspace, IComponentHandle component) {
        Map<UUID, IComponentHandle> requestsByWorkspace;
        Map<IWorkspaceConnection, Map<UUID, IComponentHandle>> requestsBySandbox = this.requests.get(sandbox);
        if (requestsBySandbox == null) {
            requestsBySandbox = new HashMap<IWorkspaceConnection, Map<UUID, IComponentHandle>>();
            this.requests.put(sandbox, requestsBySandbox);
        }
        if ((requestsByWorkspace = requestsBySandbox.get(workspace)) == null) {
            requestsByWorkspace = new HashMap<UUID, IComponentHandle>();
            requestsBySandbox.put(workspace, requestsByWorkspace);
        } else if (requestsByWorkspace.isEmpty()) {
            throw new IllegalStateException("Requesting to examine a single component after requesting all components");
        }
        requestsByWorkspace.put(component.getItemId(), component);
    }

    @Override
    public void inspect(ISandbox sandbox, IWorkspaceConnection workspace) throws TeamRepositoryException {
        for (IComponentHandle component : workspace.getComponents()) {
            this.inspect(sandbox, workspace, component);
        }
    }

    @Override
    public void inspect(ISandbox sandbox, IRepositoryResolver resolver, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        Collection<LoadedConfigurationDescriptor> allConfigurations = sandbox.allLoadedConfigurations((IProgressMonitor)monitor.newChild(10));
        monitor.setWorkRemaining(allConfigurations.size());
        for (LoadedConfigurationDescriptor config : allConfigurations) {
            ITeamRepository repo = resolver.getRepoFor(null, config.id);
            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            if (!(config.connectionHandle instanceof IWorkspaceHandle)) continue;
            IWorkspaceConnection connection = wm.getWorkspaceConnection((IWorkspaceHandle)config.connectionHandle, (IProgressMonitor)monitor.newChild(1));
            this.inspect(sandbox, connection, config.componentHandle);
        }
    }

    @Override
    public void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.SuspendOperation_ProgressMessage, (int)100);
        final HashSet<ConfigurationFacade> affectedConfigurations = new HashSet<ConfigurationFacade>();
        for (Map<IWorkspaceConnection, Map<UUID, IComponentHandle>> requestBySandbox : this.requests.values()) {
            affectedConfigurations.addAll(this.getAffectedConfigurations(requestBySandbox, progress.newChild(4)));
        }
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireReadForConfigurations(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(SandboxExaminer.this.problemHandler.getOutOfSyncDilemmaHandler());
                    try {
                        if (SandboxExaminer.this.verifyInSyncEnabled() && !SandboxExaminer.this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
                            SubMonitor childProgress = progress.newChild(1);
                            childProgress.setWorkRemaining(affectedConfigurations.size());
                            for (ConfigurationFacade configurationDescriptor : affectedConfigurations) {
                                verifyOp.addToVerify(configurationDescriptor.getConnection((IProgressMonitor)childProgress.newChild(1)), configurationDescriptor.getComponentHandle());
                            }
                        }
                        verifyOp.run((IProgressMonitor)progress.newChild(1));
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                    try {
                        ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(affectedConfigurations, true);
                        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        try {
                            SandboxExaminer.this.examineSandboxes((IProgressMonitor)progress.newChild(95));
                        }
                        finally {
                            copyFileAreaLock.release((IProgressMonitor)progress);
                        }
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.SuspendOperation_0, (IProgressMonitor)progress.newChild(95));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
        progress.done();
    }

    private void examineSandboxes(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(100 * this.requests.size()));
        for (Map.Entry<ISandbox, Map<IWorkspaceConnection, Map<UUID, IComponentHandle>>> entry : this.requests.entrySet()) {
            ISandbox sandbox = entry.getKey();
            ArrayList<ILoadRule2> loadRulesForSandbox = new ArrayList<ILoadRule2>();
            this.loadRules.put(sandbox, loadRulesForSandbox);
            Map<IWorkspaceConnection, Map<UUID, IComponentHandle>> workspaceRequests = entry.getValue();
            SubMonitor monitor2 = monitor.newChild(100);
            monitor2.setWorkRemaining(workspaceRequests.size() * 100);
            for (Map.Entry<IWorkspaceConnection, Map<UUID, IComponentHandle>> workspaceRequest : workspaceRequests.entrySet()) {
                IWorkspaceConnection workspace = workspaceRequest.getKey();
                ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>(workspaceRequest.getValue().values());
                if (componentHandles.isEmpty()) {
                    componentHandles.addAll(workspace.getComponents());
                }
                List components = workspace.teamRepository().itemManager().fetchCompleteItems(componentHandles, 0, (IProgressMonitor)monitor2.newChild(1));
                SubMonitor monitor3 = monitor2.newChild(99);
                monitor3.setWorkRemaining(100 * components.size());
                for (IComponent component : components) {
                    IShare[] shares = SharingManager.getInstance().allShares(sandbox.getRoot(), workspace.getContextHandle(), (IComponentHandle)component, (IProgressMonitor)monitor3.newChild(1));
                    this.determineLoad(sandbox, workspace, component, shares, loadRulesForSandbox, (IProgressMonitor)monitor3.newChild(99));
                }
            }
        }
    }

    private void determineLoad(ISandbox sandbox, IWorkspaceConnection workspace, IComponent component, IShare[] shares, Collection<ILoadRule2> loadRulesForSandbox, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(100 * shares.length));
        HashMap<UUID, IVersionableHandle> loadRoots = new HashMap<UUID, IVersionableHandle>();
        IShare[] iShareArray = shares;
        int n = shares.length;
        int n2 = 0;
        while (n2 < n) {
            IShare share = iShareArray[n2];
            IVersionableHandle loadRoot = share.getSharingDescriptor().getReloadRoot() == null ? share.getSharingDescriptor().getRootVersionable() : share.getSharingDescriptor().getReloadRoot();
            loadRoots.put(loadRoot.getItemId(), loadRoot);
            ++n2;
        }
        HashMap loadedByParent = new HashMap();
        ArrayList shareHandles = new ArrayList(loadRoots.values());
        List ancestors = workspace.configuration((IComponentHandle)component).locateAncestors(shareHandles, (IProgressMonitor)monitor.newChild(10));
        HashMap<UUID, IAncestorReport> ancestorReports = new HashMap<UUID, IAncestorReport>();
        Iterator shareIterator = shareHandles.iterator();
        for (IAncestorReport report : ancestors) {
            IVersionableHandle shareHandle = (IVersionableHandle)shareIterator.next();
            ancestorReports.put(shareHandle.getItemId(), report);
        }
        HashSet<UUID> interestingParentUUIDs = new HashSet<UUID>();
        ArrayList<IFolderHandle> interestingParents = new ArrayList<IFolderHandle>();
        IShare[] iShareArray2 = shares;
        int n3 = shares.length;
        int n4 = 0;
        while (n4 < n3) {
            IShare share = iShareArray2[n4];
            IVersionableHandle loadRoot = share.getSharingDescriptor().getReloadRoot() == null ? share.getSharingDescriptor().getRootVersionable() : share.getSharingDescriptor().getReloadRoot();
            IAncestorReport ancestorReport = (IAncestorReport)ancestorReports.get(loadRoot.getItemId());
            List pairs = ancestorReport.getNameItemPairs();
            UUID parentUUID = null;
            IFolderHandle parentFolder = null;
            if (pairs.isEmpty()) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.SandboxExaminer_0, (Object)share.getPath().toString())));
            } else {
                LoadAttributes loadAttributes;
                LinkedList<Object> sharesWithSameAttr;
                if (pairs.size() == 1) {
                    parentUUID = null;
                } else {
                    parentFolder = (IFolderHandle)((INameItemPair)pairs.get(pairs.size() - 2)).getItem();
                    parentUUID = parentFolder.getItemId();
                }
                HashMap<LoadAttributes, LinkedList<Object>> sharesUnderParent = (HashMap<LoadAttributes, LinkedList<Object>>)loadedByParent.get(parentUUID);
                if (sharesUnderParent == null) {
                    sharesUnderParent = new HashMap<LoadAttributes, LinkedList<Object>>();
                    loadedByParent.put(parentUUID, sharesUnderParent);
                }
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                LoadFilter filter = null;
                try {
                    filter = LoadFilter.getFilter(descriptor);
                }
                catch (IOException e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.SandboxExaminer_1, (Object)share.getPath().toString()), e));
                }
                String alternateName = null;
                if (share.isLoadedWithAnotherName((IProgressMonitor)monitor.newChild(1))) {
                    alternateName = share.getPath().getName();
                }
                if ((sharesWithSameAttr = (LinkedList<Object>)sharesUnderParent.get(loadAttributes = new LoadAttributes(share.getPath().getParent(), alternateName, filter))) == null) {
                    sharesWithSameAttr = new LinkedList<Object>();
                    sharesUnderParent.put(loadAttributes, sharesWithSameAttr);
                }
                sharesWithSameAttr.add(loadRoot);
                if (parentUUID != null && alternateName == null && !interestingParentUUIDs.contains(parentUUID)) {
                    interestingParents.add(parentFolder);
                    interestingParentUUIDs.add(parentUUID);
                }
            }
            ++n4;
        }
        HashMap<UUID, Map> childrenOfParents = new HashMap<UUID, Map>();
        if (!interestingParents.isEmpty()) {
            List childEntries = workspace.configuration((IComponentHandle)component).childEntries(interestingParents, (IProgressMonitor)monitor.newChild(10));
            Iterator iInterestingParents = interestingParents.iterator();
            for (Map children : childEntries) {
                IFolderHandle parentFolder = (IFolderHandle)iInterestingParents.next();
                childrenOfParents.put(parentFolder.getItemId(), children);
            }
        }
        for (Map.Entry entry : loadedByParent.entrySet()) {
            List rootsToLoad;
            LoadAttributes attributes;
            UUID parentUUID = (UUID)entry.getKey();
            Map sharesUnderParent = (Map)entry.getValue();
            if (parentUUID == null) {
                if (sharesUnderParent.size() > 1) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.SandboxExaminer_2, (Object)sharesUnderParent.size())));
                }
                for (Map.Entry loadEntry : sharesUnderParent.entrySet()) {
                    attributes = (LoadAttributes)loadEntry.getKey();
                    rootsToLoad = (List)loadEntry.getValue();
                    this.addItemLoadRequests(loadRulesForSandbox, workspace, component, attributes, rootsToLoad, ancestorReports);
                }
                continue;
            }
            if (!childrenOfParents.containsKey(parentUUID)) {
                for (Map.Entry loadEntry : sharesUnderParent.entrySet()) {
                    attributes = (LoadAttributes)loadEntry.getKey();
                    rootsToLoad = (List)loadEntry.getValue();
                    this.addItemLoadRequests(loadRulesForSandbox, workspace, component, attributes, rootsToLoad, ancestorReports);
                }
                continue;
            }
            Map childEntries = (Map)childrenOfParents.get(parentUUID);
            boolean parentLoaded = false;
            for (Map.Entry loadEntry : sharesUnderParent.entrySet()) {
                LoadAttributes attributes2 = (LoadAttributes)loadEntry.getKey();
                List rootsToLoad2 = (List)loadEntry.getValue();
                if (attributes2.alternateName == null && !parentLoaded && childEntries != null && childEntries.size() / 2 < rootsToLoad2.size()) {
                    parentLoaded = true;
                    this.addParentLoadRequests(loadRulesForSandbox, workspace, component, parentUUID, attributes2, rootsToLoad2, ancestorReports, childEntries);
                    continue;
                }
                this.addItemLoadRequests(loadRulesForSandbox, workspace, component, attributes2, rootsToLoad2, ancestorReports);
            }
        }
    }

    private void addItemLoadRequests(Collection<ILoadRule2> loadRulesForSandbox, IWorkspaceConnection workspace, IComponent component, LoadAttributes loadAttributes, List<IVersionableHandle> loadRoots, Map<UUID, IAncestorReport> ancestorReports) {
        String[] relativePathSegments = loadAttributes.relativePath.segments();
        for (IVersionableHandle loadRoot : loadRoots) {
            boolean includeComponentName = false;
            boolean includeRepoPath = false;
            IRelativeLocation relativePathForRequest = loadAttributes.relativePath;
            String[] parentRepositoryPath = this.getParentRepositoryPath(loadRoot.getItemId(), ancestorReports);
            if (!relativePathForRequest.isEmpty()) {
                if (parentRepositoryPath.length > 0 && relativePathSegments.length >= parentRepositoryPath.length) {
                    boolean isContained = true;
                    int iRepoPath = 0;
                    int iRelativePath = relativePathSegments.length - parentRepositoryPath.length;
                    while (iRepoPath < parentRepositoryPath.length) {
                        if (!parentRepositoryPath[iRepoPath].equals(relativePathSegments[iRelativePath])) {
                            isContained = false;
                            break;
                        }
                        ++iRepoPath;
                        ++iRelativePath;
                    }
                    if (isContained) {
                        relativePathForRequest = relativePathForRequest.removeLastSegments(parentRepositoryPath.length);
                        includeRepoPath = true;
                    }
                }
                if (!relativePathForRequest.isEmpty() && relativePathForRequest.getName().equals(component.getName())) {
                    relativePathForRequest = relativePathForRequest.getParent();
                    includeComponentName = true;
                }
            }
            RelativeLoadLocation relativeLoadLocation = new RelativeLoadLocation(relativePathForRequest, includeComponentName, includeRepoPath);
            String[] repositoryPath = this.getRepositoryPath(loadRoot.getItemId(), ancestorReports);
            ItemLoadRequest request = new ItemLoadRequest((IConnection)workspace, component, relativeLoadLocation, repositoryPath, loadAttributes.alternateName);
            LoadRule2 rule = this.findLoadRuleFor(loadRulesForSandbox, workspace, loadAttributes.loadFilter);
            rule.addLoadRequest(request);
        }
    }

    private String[] getParentRepositoryPath(UUID loadRootUUID, Map<UUID, IAncestorReport> ancestorReports) {
        IAncestorReport ancestorReport = ancestorReports.get(loadRootUUID);
        String[] result = new String[Math.max(0, ancestorReport.getNameItemPairs().size() - 2)];
        Iterator iNamePairs = ancestorReport.getNameItemPairs().iterator();
        iNamePairs.next();
        int i = 0;
        while (i < result.length) {
            INameItemPair pair = (INameItemPair)iNamePairs.next();
            result[i] = pair.getName();
            ++i;
        }
        return result;
    }

    private String[] getRepositoryPath(UUID loadRootUUID, Map<UUID, IAncestorReport> ancestorReports) {
        IAncestorReport ancestorReport = ancestorReports.get(loadRootUUID);
        String[] result = new String[Math.max(0, ancestorReport.getNameItemPairs().size() - 1)];
        Iterator iNamePairs = ancestorReport.getNameItemPairs().iterator();
        iNamePairs.next();
        int i = 0;
        while (i < result.length) {
            INameItemPair pair = (INameItemPair)iNamePairs.next();
            result[i] = pair.getName();
            ++i;
        }
        return result;
    }

    private void addParentLoadRequests(Collection<ILoadRule2> loadRulesForSandbox, IWorkspaceConnection workspace, IComponent component, UUID parentUUID, LoadAttributes loadAttributes, List<IVersionableHandle> loadRoots, Map<UUID, IAncestorReport> ancestorReports, Map<String, IVersionableHandle> childEntries) {
        String[] relativePathSegments = loadAttributes.relativePath.segments();
        boolean includeComponentName = false;
        boolean includeRepoPath = false;
        IRelativeLocation relativePathForRequest = loadAttributes.relativePath;
        String[] parentRepoPath = this.getParentRepositoryPath(loadRoots.get(0).getItemId(), ancestorReports);
        if (!relativePathForRequest.isEmpty()) {
            if (parentRepoPath.length > 0 && relativePathSegments.length >= parentRepoPath.length) {
                boolean isContained = true;
                int iRepoPath = 0;
                int iRelativePath = relativePathSegments.length - parentRepoPath.length;
                while (iRepoPath < parentRepoPath.length) {
                    if (!parentRepoPath[iRepoPath].equals(relativePathSegments[iRelativePath])) {
                        isContained = false;
                        break;
                    }
                    ++iRepoPath;
                    ++iRelativePath;
                }
                if (isContained) {
                    relativePathForRequest = relativePathForRequest.removeLastSegments(parentRepoPath.length);
                    includeRepoPath = true;
                }
            }
            if (component.getName().equals(relativePathForRequest.getName())) {
                relativePathForRequest = relativePathForRequest.getParent();
                includeComponentName = true;
            }
        }
        RelativeLoadLocation relativeLoadLocation = null;
        if (!relativePathForRequest.isEmpty() || includeComponentName || includeRepoPath) {
            relativeLoadLocation = new RelativeLoadLocation(relativePathForRequest, includeComponentName, includeRepoPath);
        }
        HashMap<UUID, String> allChildren = new HashMap<UUID, String>();
        for (Map.Entry<String, IVersionableHandle> entry : childEntries.entrySet()) {
            allChildren.put(entry.getValue().getItemId(), entry.getKey());
        }
        for (IVersionableHandle loadRoot : loadRoots) {
            allChildren.remove(loadRoot.getItemId());
        }
        ChildLoadFilter exclude = new ChildLoadFilter("exclude", false);
        exclude.addNames(allChildren.values());
        IFolderHandle parent = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(parentUUID, null);
        ParentLoadRequest request = new ParentLoadRequest((IConnection)workspace, component, relativeLoadLocation, null, exclude, parent, parentRepoPath);
        LoadRule2 rule = this.findLoadRuleFor(loadRulesForSandbox, workspace, loadAttributes.loadFilter);
        rule.addLoadRequest(request);
    }

    private LoadRule2 findLoadRuleFor(Collection<ILoadRule2> loadRulesForSandbox, IWorkspaceConnection workspace, ILoadFilter loadFilter) {
        LoadRule2 rule = null;
        for (ILoadRule2 loadRule : loadRulesForSandbox) {
            if (!loadRule.getConnection().equals(workspace)) continue;
            if (loadFilter == null && ((LoadRule2)loadRule).getLoadFilter() == null) {
                rule = (LoadRule2)loadRule;
                break;
            }
            if (loadFilter == null || !loadFilter.sameFilter(((LoadRule2)loadRule).getLoadFilter())) continue;
            rule = (LoadRule2)loadRule;
            break;
        }
        if (rule == null) {
            rule = new LoadRule2((IConnection)workspace, loadFilter, 0);
            loadRulesForSandbox.add(rule);
        }
        return rule;
    }

    private Collection<? extends ConfigurationFacade> getAffectedConfigurations(Map<IWorkspaceConnection, Map<UUID, IComponentHandle>> requestBySandbox, SubMonitor newChild) {
        ArrayList<ConfigurationFacade> result = new ArrayList<ConfigurationFacade>();
        for (Map.Entry<IWorkspaceConnection, Map<UUID, IComponentHandle>> workspaceRequest : requestBySandbox.entrySet()) {
            IWorkspaceConnection workspaceConnection = workspaceRequest.getKey();
            for (IComponentHandle componentHandle : workspaceRequest.getValue().values()) {
                result.add(new ConfigurationFacade((IConnection)workspaceConnection, componentHandle));
            }
        }
        return result;
    }

    @Override
    public Map<ISandbox, Collection<ILoadRule2>> getLoadRules() {
        return this.loadRules;
    }

    private class LoadAttributes {
        private IRelativeLocation relativePath;
        private String alternateName;
        private ILoadFilter loadFilter;

        public LoadAttributes(IRelativeLocation relativeLocation, String alternateName, ILoadFilter filter) {
            this.relativePath = relativeLocation == null ? RelativeLocation.EMPTY_LOCATION : relativeLocation;
            this.alternateName = alternateName;
            this.loadFilter = filter;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.alternateName == null ? 0 : this.alternateName.hashCode());
            result = 31 * result + (this.relativePath == null ? 0 : this.relativePath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LoadAttributes other = (LoadAttributes)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.alternateName == null ? other.alternateName != null : !this.alternateName.equals(other.alternateName)) {
                return false;
            }
            if (this.loadFilter == null ? other.loadFilter != null : !this.loadFilter.sameFilter(other.loadFilter)) {
                return false;
            }
            return !(this.relativePath == null ? other.relativePath != null : !this.relativePath.equals(other.relativePath));
        }

        private SandboxExaminer getOuterType() {
            return SandboxExaminer.this;
        }
    }
}

