/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.PathPair;
import com.ibm.team.internal.repository.rcp.dbhm.CachedDiskBackedHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.core.runtime.Path;

public class IgnoreFileAgeDBHM
extends CachedDiskBackedHashMap<PathPair, AgeRecord> {
    public void put(PathPair pair, DateStamp age, long size) {
        this.put(pair, new AgeRecord(age, size));
    }

    public boolean shouldReload(PathPair pair, DateStamp dateStamp, long size) {
        AgeRecord rec = (AgeRecord)this.get(pair);
        return rec == null || !rec.dateStamp.equals(dateStamp) || rec.size != size;
    }

    protected long persistStream(ByteArrayOutputStream out) throws IOException {
        long offset = this.heap.allocate((long)out.size());
        out.writeTo(this.heap.getOutputStream(offset));
        return offset;
    }

    protected long writeObject(Object o, int flags) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(out);
        if ((1 & flags) != 0) {
            PathPair pair = (PathPair)o;
            ILocation root = pair.getRoot();
            oos.writeUTF(root.getStorageId());
            oos.writeUTF(root.toString());
            oos.writeUTF(pair.getInnerPath().toPath().toPortableString());
        } else {
            oos.writeObject(o);
        }
        oos.flush();
        return this.persistStream(out);
    }

    protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(in);
        if ((1 & flags) != 0) {
            String rootStorageId = ois.readUTF();
            String rootLocationStr = ois.readUTF();
            ILocation location = SharingManager.getInstance().getStorageManager(rootStorageId).createLocation(rootLocationStr);
            Path inner = new Path(ois.readUTF());
            return new PathPair(location, new RelativeLocation(inner.segments()));
        }
        return ois.readObject();
    }

    public static class AgeRecord
    implements Serializable {
        private static final long serialVersionUID = 1920333109154851884L;
        DateStamp dateStamp;
        long size;

        public AgeRecord(DateStamp ds, long size) {
            this.dateStamp = ds;
            this.size = size;
        }
    }

    public static class DateStamp
    implements Serializable {
        private static final long serialVersionUID = -5169000745225521803L;
        public final long fsTimeStamp;
        public final long ideTimeStamp;

        public DateStamp(long fsTimeStamp, long ideTimeStamp) {
            this.fsTimeStamp = fsTimeStamp < 0L ? 0L : fsTimeStamp;
            this.ideTimeStamp = ideTimeStamp;
        }

        public DateStamp(IFileStorage storage) throws FileSystemException {
            this(storage.getLocalTimeStamp(), storage.getModificationStamp());
        }

        public boolean equals(Object o) {
            if (!(o instanceof DateStamp)) {
                return false;
            }
            DateStamp other = (DateStamp)o;
            if (this.fsTimeStamp == other.fsTimeStamp) {
                if (this.fsTimeStamp == this.ideTimeStamp || other.fsTimeStamp == other.ideTimeStamp) {
                    return true;
                }
                return this.ideTimeStamp == other.ideTimeStamp;
            }
            return false;
        }
    }
}

