/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.IValidatingParameterWrapper;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;

public class ParmsItemHandle
implements IValidatingParameterWrapper {
    public String itemId;
    public String itemTypeName;
    public String itemTypeNamespace;

    public ParmsItemHandle() {
    }

    public ParmsItemHandle(IItemHandle handle) {
        this.itemId = handle.getItemId().getUuidValue();
        this.itemTypeName = handle.getItemType().getName();
        this.itemTypeNamespace = handle.getItemType().getNamespaceURI();
    }

    @Override
    public void validate(String requestName, Object ... path) {
        ParmValidation.requiredValue(this.itemId, requestName, path, "itemId");
        ParmValidation.requiredValue(this.itemTypeName, requestName, path, "itemType");
        ParmValidation.requiredValue(this.itemTypeNamespace, requestName, path, "itemNamespace");
    }

    public IItemHandle getItemHandle() throws TeamRepositoryException {
        if (this.itemId == null || this.itemTypeName == null || this.itemTypeNamespace == null) {
            return null;
        }
        UUID uuid = UUID.valueOf((String)this.itemId);
        IItemType type = IItemType.IRegistry.INSTANCE.getItemType(this.itemTypeName, this.itemTypeNamespace);
        if (type == null) {
            return null;
        }
        IItemHandle handle = type.createItemHandle(uuid, null);
        return handle;
    }
}

