/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.content.util;

import com.ibm.team.repository.common.internal.content.util.BadHeapException;
import com.ibm.team.repository.common.internal.content.util.CachedDiskBackedHashMap;
import com.ibm.team.repository.common.internal.content.util.DBHMException;
import com.ibm.team.repository.common.internal.content.util.PersistentBTreeHeap;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.UnsynchronizedByteArrayInputStream;
import com.ibm.team.repository.common.utils.UnsynchronizedByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;

public class PersistentDiskBackedHashMap<K, V>
extends CachedDiskBackedHashMap<K, V> {
    private boolean doneInitializing;
    private boolean closed;

    public PersistentDiskBackedHashMap(long initialCapacity, double loadFactor, int maxCacheSize, File file) {
        super(initialCapacity, loadFactor, maxCacheSize);
        try {
            this.initFromFile(file);
        }
        catch (IOException e) {
            throw new DBHMException(e);
        }
    }

    public PersistentDiskBackedHashMap(long initialCapacity, double loadFactor, File file) {
        super(initialCapacity, loadFactor);
        try {
            this.initFromFile(file);
        }
        catch (IOException e) {
            throw new DBHMException(e);
        }
    }

    public PersistentDiskBackedHashMap(long initialCapacity, File file) {
        super(initialCapacity);
        try {
            this.initFromFile(file);
        }
        catch (IOException e) {
            throw new DBHMException(e);
        }
    }

    public PersistentDiskBackedHashMap(File file) {
        try {
            this.initFromFile(file);
        }
        catch (IOException e) {
            throw new DBHMException(e);
        }
    }

    protected void initFromFile(File f) throws IOException {
        PersistentBTreeHeap h = this.newPersistentBTreeHeap(f);
        boolean success = false;
        try {
            byte[] data = h.getPersistedData();
            if (data.length == 0) {
                this.heap = h;
                this.doneInitializing = true;
                this.initTablePtr();
            } else {
                DataInputStream in = new DataInputStream(new UnsynchronizedByteArrayInputStream(data));
                try {
                    byte format = in.readByte();
                    if (format != 1) {
                        String msg = NLS.bind(Messages.getServerString("PersistentDiskBackedHashMap.ErrorVersionMismatch"), format, 1);
                        throw new IOException(msg);
                    }
                    this.tablePtr = in.readLong();
                    this.size = in.readLong();
                    this.capacity = in.readLong();
                    this.numHeapADTs = in.readLong();
                }
                finally {
                    in.close();
                }
                this.heap = h;
                super.init();
                this.doneInitializing = true;
            }
            success = true;
        }
        catch (Throwable throwable) {
            if (!success) {
                try {
                    h.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (!success) {
            try {
                h.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected PersistentBTreeHeap newPersistentBTreeHeap(File f) throws IOException {
        try {
            return new PersistentBTreeHeap(f);
        }
        catch (BadHeapException e) {
            throw new DBHMException(e);
        }
    }

    @Override
    protected void initHeap() throws IOException {
        if (this.doneInitializing) {
            super.initHeap();
        }
    }

    @Override
    protected void initTablePtr() throws IOException {
        if (this.doneInitializing) {
            super.initTablePtr();
        }
    }

    public void close() throws IOException {
        this.persist();
        ((PersistentBTreeHeap)this.heap).close();
        this.closed = true;
    }

    public void persist() throws IOException {
        this.flushCache();
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(24);
        try {
            DataOutputStream dOut = new DataOutputStream(out);
            try {
                dOut.writeByte(1);
                dOut.writeLong(this.tablePtr);
                dOut.writeLong(this.size);
                dOut.writeLong(this.capacity);
                dOut.writeLong(this.numHeapADTs);
                dOut.flush();
                ((PersistentBTreeHeap)this.heap).setPersistedData(out.toByteArray());
                ((PersistentBTreeHeap)this.heap).persist();
            }
            finally {
                dOut.close();
            }
        }
        finally {
            out.close();
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            try {
                this.close();
            }
            catch (IOException iOException) {}
        }
        super.finalize();
    }
}

