/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.queryast.impl;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.queryast.ComparisonOp;
import com.ibm.team.repository.common.internal.queryast.ElementType;
import com.ibm.team.repository.common.internal.queryast.FilterElement;
import com.ibm.team.repository.common.internal.queryast.FunctionType;
import com.ibm.team.repository.common.internal.queryast.Literal;
import com.ibm.team.repository.common.internal.queryast.NumericScalarFunction;
import com.ibm.team.repository.common.internal.queryast.QueryDataElement;
import com.ibm.team.repository.common.internal.queryast.QueryastFactory;
import com.ibm.team.repository.common.internal.queryast.QueryastPackage;
import com.ibm.team.repository.common.internal.queryast.ScalarFunction;
import com.ibm.team.repository.common.internal.queryast.SelectionElement;
import com.ibm.team.repository.common.internal.queryast.StringScalarFunction;
import com.ibm.team.repository.common.internal.queryast.impl.AbstractQueryElementImpl;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.query.ast.IBoolean;
import com.ibm.team.repository.common.query.ast.IDateTime;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.INumericScalarFunction;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IStringScalarFunction;
import com.ibm.team.repository.common.query.ast.IUUID;
import java.util.Date;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class LiteralImpl
extends AbstractQueryElementImpl
implements Literal {
    protected static final ElementType KIND_EDEFAULT = ElementType.STRING_LITERAL;
    protected ElementType kind = KIND_EDEFAULT;
    protected boolean kindESet;
    protected static final String STRING_VALUE_EDEFAULT = "";
    protected String stringValue = "";

    protected LiteralImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return QueryastPackage.Literals.LITERAL;
    }

    @Override
    public ElementType getKind() {
        return this.kind;
    }

    @Override
    public void setKind(ElementType newKind) {
        ElementType oldKind = this.kind;
        this.kind = newKind == null ? KIND_EDEFAULT : newKind;
        boolean oldKindESet = this.kindESet;
        this.kindESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldKind, (Object)this.kind, !oldKindESet));
        }
    }

    @Override
    public void unsetKind() {
        ElementType oldKind = this.kind;
        boolean oldKindESet = this.kindESet;
        this.kind = KIND_EDEFAULT;
        this.kindESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 0, (Object)oldKind, (Object)KIND_EDEFAULT, oldKindESet));
        }
    }

    @Override
    public boolean isSetKind() {
        return this.kindESet;
    }

    @Override
    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public void setStringValue(String newStringValue) {
        String oldStringValue = this.stringValue;
        this.stringValue = newStringValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldStringValue, (Object)this.stringValue));
        }
    }

    public IPredicate _eq(Date dateToCompare) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.EQUALS_LITERAL, (FilterElement)this, dateToCompare);
    }

    @Override
    public IPredicate _eq(IDateTime dateTime) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.EQUALS_LITERAL, (FilterElement)this, dateTime);
    }

    public IPredicate _gt(Date dateToCompare) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.GREATER_THAN_LITERAL, (FilterElement)this, dateToCompare);
    }

    @Override
    public IPredicate _gt(IDateTime dateTime) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.GREATER_THAN_LITERAL, (FilterElement)this, dateTime);
    }

    public IPredicate _gtOrEq(Date dateToCompare) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.GT_OR_EQ_LITERAL, (FilterElement)this, dateToCompare);
    }

    @Override
    public IPredicate _gtOrEq(IDateTime dateTime) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.GT_OR_EQ_LITERAL, (FilterElement)this, dateTime);
    }

    public IPredicate _ls(Date dateToCompare) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.LESS_THAN_LITERAL, (FilterElement)this, dateToCompare);
    }

    @Override
    public IPredicate _lt(IDateTime dateTime) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.LESS_THAN_LITERAL, (FilterElement)this, dateTime);
    }

    public IPredicate _lsOrEq(Date dateToCompare) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.LT_OR_EQ_LITERAL, (FilterElement)this, dateToCompare);
    }

    @Override
    public IPredicate _ltOrEq(IDateTime dateTime) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.LT_OR_EQ_LITERAL, (FilterElement)this, dateTime);
    }

    public IPredicate _notEq(Date dateToCompare) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, (FilterElement)this, dateToCompare);
    }

    @Override
    public IPredicate _notEq(IDateTime dateTime) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, (FilterElement)this, dateTime);
    }

    @Override
    public INumericScalarFunction _indexOf(IString aString, Integer i) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        numericScalarFunction.getArgs().add((Object)this);
        QueryDataElement queryDataElement = QueryastFactory.eINSTANCE.createQueryDataElement(aString);
        numericScalarFunction.getArgs().add((Object)queryDataElement);
        Literal literal = QueryastFactory.eINSTANCE.createNumericLiteral(i);
        numericScalarFunction.getArgs().add((Object)literal);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _indexOf(IString aString, INumeric i) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        numericScalarFunction.getArgs().add((Object)this);
        QueryDataElement queryDataElement1 = QueryastFactory.eINSTANCE.createQueryDataElement(aString);
        numericScalarFunction.getArgs().add((Object)queryDataElement1);
        QueryDataElement queryDataElement2 = QueryastFactory.eINSTANCE.createQueryDataElement(i);
        numericScalarFunction.getArgs().add((Object)queryDataElement2);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _indexOf(IString aString) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        numericScalarFunction.getArgs().add((Object)this);
        QueryDataElement queryDataElement1 = QueryastFactory.eINSTANCE.createQueryDataElement(aString);
        numericScalarFunction.getArgs().add((Object)queryDataElement1);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _indexOf(String aString, Integer i) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        numericScalarFunction.getArgs().add((Object)this);
        Literal literal1 = QueryastFactory.eINSTANCE.createStringLiteral(aString);
        numericScalarFunction.getArgs().add((Object)literal1);
        Literal literal2 = QueryastFactory.eINSTANCE.createNumericLiteral(i);
        numericScalarFunction.getArgs().add((Object)literal2);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _indexOf(String aString, INumeric i) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        numericScalarFunction.getArgs().add((Object)this);
        Literal literal1 = QueryastFactory.eINSTANCE.createStringLiteral(aString);
        numericScalarFunction.getArgs().add((Object)literal1);
        QueryDataElement queryDataElement2 = QueryastFactory.eINSTANCE.createQueryDataElement(i);
        numericScalarFunction.getArgs().add((Object)queryDataElement2);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _indexOf(String aString) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        numericScalarFunction.getArgs().add((Object)this);
        Literal literal1 = QueryastFactory.eINSTANCE.createStringLiteral(aString);
        numericScalarFunction.getArgs().add((Object)literal1);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _length() {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LENGTH_LITERAL);
        this.addLiteralToScalarFunction(numericScalarFunction);
        return numericScalarFunction;
    }

    @Override
    public IStringScalarFunction _lower() {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.LOWER_LITERAL);
        this.addLiteralToScalarFunction(stringScalarFunction);
        return stringScalarFunction;
    }

    @Override
    public IStringScalarFunction _upper() {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.UPPER_LITERAL);
        this.addLiteralToScalarFunction(stringScalarFunction);
        return stringScalarFunction;
    }

    @Override
    public IStringScalarFunction _substring(Integer i1, Integer i2) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.SUBSTRING_LITERAL);
        this.addLiteralToScalarFunction(stringScalarFunction);
        Literal literal1 = QueryastFactory.eINSTANCE.createNumericLiteral(i1);
        stringScalarFunction.getArgs().add((Object)literal1);
        Literal literal2 = QueryastFactory.eINSTANCE.createNumericLiteral(i2);
        stringScalarFunction.getArgs().add((Object)literal2);
        return stringScalarFunction;
    }

    @Override
    public IStringScalarFunction _substring(Integer i1, INumeric i2) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.SUBSTRING_LITERAL);
        this.addLiteralToScalarFunction(stringScalarFunction);
        Literal literal1 = QueryastFactory.eINSTANCE.createNumericLiteral(i1);
        stringScalarFunction.getArgs().add((Object)literal1);
        QueryDataElement queryDataElement2 = QueryastFactory.eINSTANCE.createQueryDataElement(i2);
        stringScalarFunction.getArgs().add((Object)queryDataElement2);
        return stringScalarFunction;
    }

    @Override
    public IStringScalarFunction _substring(INumeric i1, Integer i2) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.SUBSTRING_LITERAL);
        this.addLiteralToScalarFunction(stringScalarFunction);
        QueryDataElement queryDataElement1 = QueryastFactory.eINSTANCE.createQueryDataElement(i1);
        stringScalarFunction.getArgs().add((Object)queryDataElement1);
        Literal literal2 = QueryastFactory.eINSTANCE.createNumericLiteral(i2);
        stringScalarFunction.getArgs().add((Object)literal2);
        return stringScalarFunction;
    }

    @Override
    public IStringScalarFunction _substring(INumeric i1, INumeric i2) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.SUBSTRING_LITERAL);
        this.addLiteralToScalarFunction(stringScalarFunction);
        QueryDataElement queryDataElement1 = QueryastFactory.eINSTANCE.createQueryDataElement(i1);
        stringScalarFunction.getArgs().add((Object)queryDataElement1);
        QueryDataElement queryDataElement2 = QueryastFactory.eINSTANCE.createQueryDataElement(i2);
        stringScalarFunction.getArgs().add((Object)queryDataElement2);
        return stringScalarFunction;
    }

    @Override
    public IStringScalarFunction _concat(IString s) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.CONCAT_LITERAL);
        this.addLiteralToScalarFunction(stringScalarFunction);
        QueryDataElement queryDataElement = QueryastFactory.eINSTANCE.createQueryDataElement(s);
        stringScalarFunction.getArgs().add((Object)queryDataElement);
        return stringScalarFunction;
    }

    @Override
    public IStringScalarFunction _concat(String s) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.CONCAT_LITERAL);
        this.addLiteralToScalarFunction(stringScalarFunction);
        Literal literal = QueryastFactory.eINSTANCE.createStringLiteral(s);
        stringScalarFunction.getArgs().add((Object)literal);
        return stringScalarFunction;
    }

    private StringScalarFunction createStringScalarFunction(FunctionType functionType) {
        StringScalarFunction stringScalarFunction = QueryastFactory.eINSTANCE.createStringScalarFunction(functionType);
        return stringScalarFunction;
    }

    private NumericScalarFunction createNumericScalarFunction(FunctionType functionType) {
        NumericScalarFunction numericScalarFunction = QueryastFactory.eINSTANCE.createNumericScalarFunction(functionType);
        return numericScalarFunction;
    }

    private void addLiteralToScalarFunction(ScalarFunction scalarFunction) {
        scalarFunction.getArgs().add((Object)this);
    }

    @Override
    public IPredicate _eq(UUID uuid) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.EQUALS_LITERAL, (FilterElement)this, uuid);
    }

    @Override
    public IPredicate _eq(IUUID uuid) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.EQUALS_LITERAL, (FilterElement)this, uuid);
    }

    @Override
    public IPredicate _eq(IString string) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.EQUALS_LITERAL, (FilterElement)this, string);
    }

    @Override
    public IPredicate _eq(String stringToCompare) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.EQUALS_LITERAL, (FilterElement)this, stringToCompare);
    }

    @Override
    public IPredicate _notEq(IString string) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, (FilterElement)this, string);
    }

    @Override
    public IPredicate _notEq(String stringToCompare) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, (FilterElement)this, stringToCompare);
    }

    @Override
    public IPredicate _eq(IBoolean value) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.EQUALS_LITERAL, (FilterElement)this, value);
    }

    @Override
    public INumericScalarFunction _abs() {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.ABS_LITERAL);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _mod(INumeric numeric) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.MOD_LITERAL);
        QueryDataElement queryDataElement = QueryastFactory.eINSTANCE.createQueryDataElement(numeric);
        numericScalarFunction.getArgs().add((Object)queryDataElement);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _mod(Integer number) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.MOD_LITERAL);
        Literal literal = QueryastFactory.eINSTANCE.createNumericLiteral(number);
        numericScalarFunction.getArgs().add((Object)literal);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _sqrt() {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.SQRT_LITERAL);
        return numericScalarFunction;
    }

    @Override
    public IPredicate _eq(Number numberToCompare) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.EQUALS_LITERAL, (FilterElement)this, numberToCompare);
    }

    @Override
    public IPredicate _eq(INumeric numeric) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.EQUALS_LITERAL, (FilterElement)this, numeric);
    }

    @Override
    public IPredicate _notEq(Number numberToCompare) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, (FilterElement)this, numberToCompare);
    }

    @Override
    public IPredicate _notEq(INumeric numeric) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, (FilterElement)this, numeric);
    }

    @Override
    public IPredicate _gt(Number numberToCompare) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.GREATER_THAN_LITERAL, (FilterElement)this, numberToCompare);
    }

    @Override
    public IPredicate _gt(INumeric numeric) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.GREATER_THAN_LITERAL, (FilterElement)this, numeric);
    }

    @Override
    public IPredicate _gtOrEq(Number numberToCompare) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.GT_OR_EQ_LITERAL, (FilterElement)this, numberToCompare);
    }

    @Override
    public IPredicate _gtOrEq(INumeric numeric) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.GT_OR_EQ_LITERAL, (FilterElement)this, numeric);
    }

    @Override
    public IPredicate _lt(Number numberToCompare) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.LESS_THAN_LITERAL, (FilterElement)this, numberToCompare);
    }

    @Override
    public IPredicate _lt(INumeric numeric) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.LESS_THAN_LITERAL, (FilterElement)this, numeric);
    }

    @Override
    public IPredicate _ltOrEq(Number numberToCompare) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.LT_OR_EQ_LITERAL, (FilterElement)this, numberToCompare);
    }

    @Override
    public IPredicate _ltOrEq(INumeric numeric) {
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.LT_OR_EQ_LITERAL, (FilterElement)this, numeric);
    }

    private void addDoubleQuotedOn(StringBuffer b, Object ... args) {
        b.append('\"');
        int i = 0;
        while (i < args.length) {
            char[] a = args[i].toString().toCharArray();
            int j = 0;
            while (j < a.length) {
                if (a[j] == '\\') {
                    b.append("\\\\");
                } else {
                    b.append(a[j]);
                }
                ++j;
            }
            ++i;
        }
        b.append('\"');
    }

    @Override
    public void toDynamicJavaStringOn(StringBuffer b) {
        this.toJavaStringOn(b);
    }

    @Override
    public void toJavaStringOn(StringBuffer b) {
        ElementType kind = this.getKind();
        if (this.isString()) {
            this.addDoubleQuotedOn(b, this.getStringValue());
        } else if (((Object)((Object)kind)).equals((Object)ElementType.ITEM_TYPE_LITERAL)) {
            b.append("ItemUtil.itemTypeFor(");
            ItemType type = ItemUtil.string2ItemType(this.getStringValue());
            this.addDoubleQuotedOn(b, type.getName());
            b.append(", ");
            this.addDoubleQuotedOn(b, type.getNamespaceURI());
            b.append(")");
        } else if (this.isDateTime()) {
            String aValue = this.getStringValue();
            String timeZone = aValue.indexOf("Z") > -1 ? "Z" : "-";
            b.append("java.sql.Timestamp.valueOf(");
            this.addDoubleQuotedOn(b, aValue.substring(0, 10), " ", aValue.substring(11, 19), aValue.substring(19, 20).equals(".") ? aValue.substring(19, aValue.lastIndexOf(timeZone)) : STRING_VALUE_EDEFAULT);
            b.append(")");
        } else if (((Object)((Object)kind)).equals((Object)ElementType.INT_LITERAL) || ((Object)((Object)kind)).equals((Object)ElementType.LONG_LITERAL)) {
            b.append(this.getStringValue());
        } else if (((Object)((Object)kind)).equals((Object)ElementType.BIG_DECIMAL_LITERAL)) {
            b.append("new BigDecimal(");
            this.addDoubleQuotedOn(b, this.getStringValue());
            b.append(")");
        } else if (this.isBoolean()) {
            b.append(this.getStringValue());
        } else if (this.isUUID()) {
            b.append("UUID.valueOf(");
            this.addDoubleQuotedOn(b, this.getStringValue());
            b.append(")");
        } else if (this.isEnum()) {
            b.append("ElementType.get(").append(this.getStringValue()).append(")");
        } else {
            b.append(this.getStringValue());
        }
    }

    @Override
    public String toSelectionNameString() {
        StringBuffer b = new StringBuffer();
        this.toJavaStringOn(b);
        return b.toString();
    }

    @Override
    public boolean isString() {
        return ((Object)((Object)this.kind)).equals((Object)ElementType.STRING_LITERAL);
    }

    @Override
    public boolean isDateTime() {
        return ((Object)((Object)this.kind)).equals((Object)ElementType.DATE_TIME_LITERAL);
    }

    @Override
    public boolean isBoolean() {
        return ((Object)((Object)this.kind)).equals((Object)ElementType.BOOLEAN_LITERAL);
    }

    @Override
    public boolean isNumber() {
        return ((Object)((Object)this.kind)).equals((Object)ElementType.INT_LITERAL) || ((Object)((Object)this.kind)).equals((Object)ElementType.LONG_LITERAL) || ((Object)((Object)this.kind)).equals((Object)ElementType.BIG_DECIMAL_LITERAL);
    }

    @Override
    public boolean isUUID() {
        return ((Object)((Object)this.kind)).equals((Object)ElementType.UUID_LITERAL);
    }

    @Override
    public boolean isEnum() {
        return ((Object)((Object)this.kind)).equals((Object)ElementType.ENUM_LITERAL);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getKind();
            }
            case 1: {
                return this.getStringValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setKind((ElementType)((Object)newValue));
                return;
            }
            case 1: {
                this.setStringValue((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.unsetKind();
                return;
            }
            case 1: {
                this.setStringValue(STRING_VALUE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.isSetKind();
            }
            case 1: {
                return STRING_VALUE_EDEFAULT == null ? this.stringValue != null : !STRING_VALUE_EDEFAULT.equals(this.stringValue);
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class baseClass) {
        if (baseClass == QueryDataElement.class) {
            return -1;
        }
        if (baseClass == FilterElement.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == SelectionElement.class) {
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class baseClass) {
        if (baseClass == QueryDataElement.class) {
            return -1;
        }
        if (baseClass == FilterElement.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == SelectionElement.class) {
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (kind: ");
        if (this.kindESet) {
            result.append((Object)this.kind);
        } else {
            result.append("<unset>");
        }
        result.append(", stringValue: ");
        result.append(this.stringValue);
        result.append(')');
        return result.toString();
    }

    @Override
    public boolean isReferingToPath(String p) {
        return false;
    }

    @Override
    public boolean isWellFormed() {
        return true;
    }
}

