/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.internal.util.AbstractComponentChildElementDescriptor;
import com.ibm.team.repository.common.internal.util.EvolutionDescriptor;
import com.ibm.team.repository.common.internal.util.GeneralizedAttributeDescriptor;
import com.ibm.team.repository.common.internal.util.IModelElementDescriptor;
import com.ibm.team.repository.common.internal.util.VersionStringComparator;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.model.RepositoryFactory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;

class ModelElementDescriptor
extends AbstractComponentChildElementDescriptor
implements IModelElementDescriptor {
    private static final String EVOLUTION_ELEMENT = "evolution";
    private static final String DTO_EVOLUTION_ELEMENT = "dtoEvolution";
    private static final String DTO_MODEL_ELEMENT = "dtoModel";
    private SortedSet<EvolutionDescriptor> evolutions;
    private Map<String, Map<String, IType>> generalizationDataCache;

    ModelElementDescriptor(IConfigurationElement element) {
        super(element, element.getName());
    }

    @Override
    protected void checkElement() {
        if (!DTO_MODEL_ELEMENT.equalsIgnoreCase(this.getElement().getName())) {
            this.checkNameAttribute();
            this.checkVersionAttribute();
        }
        this.checkUriAttribute();
    }

    @Override
    protected void processChild(IConfigurationElement child) {
        String name = child.getName();
        if (EVOLUTION_ELEMENT.equalsIgnoreCase(name) || DTO_EVOLUTION_ELEMENT.equalsIgnoreCase(name)) {
            this.processEvolutionElement(child);
        } else {
            super.processChild(child);
        }
    }

    private void processEvolutionElement(IConfigurationElement element) {
        EvolutionDescriptor desc = new EvolutionDescriptor(element);
        this.getEvolutions().add(desc);
        this.addGeneralizedDataToCache(desc);
    }

    private void addGeneralizedDataToCache(EvolutionDescriptor desc) {
        Map<String, Map<String, GeneralizedAttributeDescriptor>> gads = desc.getGeneralizedAttributeDescriptors();
        for (Map.Entry<String, Map<String, GeneralizedAttributeDescriptor>> entry : gads.entrySet()) {
            String className = entry.getKey();
            Map<String, IType> attribToTypes = this.getGeneralizationDataCache().get(className);
            if (attribToTypes == null) {
                attribToTypes = new HashMap<String, IType>(5);
                this.getGeneralizationDataCache().put(className, attribToTypes);
            }
            for (Map.Entry<String, GeneralizedAttributeDescriptor> inner : entry.getValue().entrySet()) {
                String attributeName = inner.getKey();
                if (attribToTypes.containsKey(attributeName)) {
                    throw new RuntimeException("Multiple generalize declarations on the same attribute not yet supported");
                }
                GeneralizedAttributeDescriptor gad = inner.getValue();
                String namespace = gad.getOldNamespace();
                String type = gad.getOldType();
                ItemType itemType = RepositoryFactory.eINSTANCE.createItemType();
                itemType.setNamespaceURI(namespace);
                itemType.setName(type);
                attribToTypes.put(attributeName, itemType);
            }
        }
    }

    private Map<String, Map<String, IType>> getGeneralizationDataCache() {
        if (this.generalizationDataCache == null) {
            this.generalizationDataCache = new HashMap<String, Map<String, IType>>(10);
        }
        return this.generalizationDataCache;
    }

    public String getOriginalVersionAttribute() {
        return this.getAttribute("originalVersion");
    }

    @Override
    public boolean hasAttributeEvolved(String className, String attribName) {
        for (EvolutionDescriptor evolutionDescriptor : this.getEvolutions()) {
            if (evolutionDescriptor.getNewAttribute(className, attribName) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAttributeBeenMadeNullable(String className, String attribName) {
        for (EvolutionDescriptor evolutionDescriptor : this.getEvolutions()) {
            if (evolutionDescriptor.getNullableAttribute(className, attribName) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasTypeEvolved(String className) {
        for (EvolutionDescriptor evolutionDescriptor : this.getEvolutions()) {
            if (evolutionDescriptor.getNewType(className) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getModelVersionForComponentVersion(String componentVersion) {
        Iterator iter = this.getEvolutions().iterator();
        VersionStringComparator c = new VersionStringComparator();
        while (iter.hasNext()) {
            EvolutionDescriptor entry = (EvolutionDescriptor)iter.next();
            if (c.compare(entry.getComponentVersion(), componentVersion) > 0) continue;
            return entry.getModelVersion();
        }
        return this.getOriginalVersionAttribute();
    }

    @Override
    public boolean attributeExistedInVersion(String className, String attributeName, String componentVersion) {
        VersionStringComparator c = new VersionStringComparator();
        for (EvolutionDescriptor desc : this.getEvolutions()) {
            if (c.compare(desc.getComponentVersion(), componentVersion) <= 0) {
                return true;
            }
            if (desc.getNewAttribute(className, attributeName) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean typeExistedInVersion(String className, String componentVersion) {
        Iterator iter = this.getEvolutions().iterator();
        VersionStringComparator c = new VersionStringComparator();
        while (iter.hasNext()) {
            EvolutionDescriptor desc = (EvolutionDescriptor)iter.next();
            if (c.compare(desc.getComponentVersion(), componentVersion) <= 0) {
                return true;
            }
            if (desc.getNewType(className) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public String requiredClientUpgradeVersion(String className, String componentVersion) {
        Iterator iter = this.getEvolutions().iterator();
        VersionStringComparator c = new VersionStringComparator();
        while (iter.hasNext()) {
            EvolutionDescriptor desc = (EvolutionDescriptor)iter.next();
            if (c.compare(desc.getComponentVersion(), componentVersion) <= 0) {
                return null;
            }
            if (desc.getNewType(className) == null) continue;
            return desc.getComponentVersion();
        }
        return null;
    }

    @Override
    public IType getNamespaceAndTypeBeforeAttributeWasGeneralized(String className, String attribName) {
        Map<String, IType> attrToType = this.getGeneralizationDataCache().get(className);
        if (attrToType == null) {
            return null;
        }
        return attrToType.get(attribName);
    }

    @Override
    public boolean isClientAndServerCompatible(String clientVersion, String serverVersion) {
        if (clientVersion.equals(serverVersion)) {
            return true;
        }
        for (EvolutionDescriptor desc : this.getEvolutions()) {
            if (desc.getModelVersion().equals(serverVersion)) {
                return true;
            }
            if (desc.isNonClientCompatibilityBreakingChange()) continue;
            return false;
        }
        return false;
    }

    private synchronized SortedSet<EvolutionDescriptor> getEvolutions() {
        if (this.evolutions == null) {
            this.evolutions = new TreeSet<EvolutionDescriptor>(new EvolutionDescriptorComponentVersionComparator());
        }
        return this.evolutions;
    }

    private static final class EvolutionDescriptorComponentVersionComparator
    implements Comparator<EvolutionDescriptor> {
        private final VersionStringComparator versionComparator = new VersionStringComparator(true);

        private EvolutionDescriptorComponentVersionComparator() {
        }

        @Override
        public int compare(EvolutionDescriptor o1, EvolutionDescriptor o2) {
            if (o1 == o2) {
                return 0;
            }
            int componentDifference = this.versionComparator.compare(o1.getComponentVersion(), o2.getComponentVersion());
            if (componentDifference != 0) {
                return componentDifference;
            }
            if (o1.isDtoEvolution()) {
                String msg = NLS.bind((String)"Found two dtoEvolution elements with the same componentVersion value in bundle {0}.", (Object)o1.getBundleSymbolicName());
                throw new IllegalStateException(msg);
            }
            return this.versionComparator.compare(o1.getModelVersion(), o2.getModelVersion());
        }
    }
}

