/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.common.advice;

import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IParticipantReport;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.internal.common.Messages;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class TeamOperationCanceledException
extends TeamRepositoryException {
    public TeamOperationCanceledException(String message) {
        super(message);
    }

    public TeamOperationCanceledException(IOperationReport report, String message) {
        super(message);
        this.setData(report);
    }

    public IOperationReport getReport() {
        return (IOperationReport)this.getData();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        this.printReport(new StreamPrinter(s));
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        this.printReport(new WriterPrinter(s));
    }

    private void printReport(Printer printer) {
        IOperationReport report = this.getReport();
        if (report != null) {
            this.print(report, printer, 1);
        }
    }

    private void print(IProcessReport report, Printer printer, int depth) {
        printer.println(NLS.bind(Messages.getCommonString("TeamOperationCanceledException.0"), report.getName()), depth);
        String id = null;
        if (report instanceof IOperationReport) {
            id = ((IOperationReport)report).getOperationId();
        } else if (report instanceof IParticipantReport) {
            id = ((IParticipantReport)report).getParticipantIdentifier();
        }
        printer.println(NLS.bind(Messages.getCommonString("TeamOperationCanceledException.1"), id), depth);
        printer.println(NLS.bind(Messages.getCommonString("TeamOperationCanceledException.2"), this.getSeverityString(report.getSeverity())), depth);
        this.print(report.getInfos(), printer, depth + 1);
        IProcessReport[] nestedReports = report.getNestedReports();
        int i = 0;
        while (i < nestedReports.length) {
            this.print(nestedReports[i], printer, depth + 1);
            ++i;
        }
    }

    private void print(IReportInfo[] infos, Printer printer, int depth) {
        int i = 0;
        while (i < infos.length) {
            String data;
            IReportInfo info = infos[i];
            printer.println(NLS.bind(Messages.getCommonString("TeamOperationCanceledException.3"), info.getSummary()), depth);
            String description = info.getDescription();
            if (description != null && description.length() > 0) {
                printer.println(NLS.bind(Messages.getCommonString("TeamOperationCanceledException.4"), description), depth);
            }
            printer.println(NLS.bind(Messages.getCommonString("TeamOperationCanceledException.5"), this.getSeverityString(info.getSeverity())), depth);
            if (info.getIdentifier().equals("com.ibm.team.process.internal.operationException") && (data = info.getData()) != null && data.length() > 0) {
                printer.println(Messages.getCommonString("TeamOperationCanceledException.6"), depth);
                printer.println(data);
            }
            ++i;
        }
    }

    private String getSeverityString(int severity) {
        switch (severity) {
            case 0: {
                return Messages.getCommonString("TeamOperationCanceledException.7");
            }
            case 4: {
                return Messages.getCommonString("TeamOperationCanceledException.8");
            }
            case 2: {
                return Messages.getCommonString("TeamOperationCanceledException.9");
            }
        }
        return Messages.getCommonString("TeamOperationCanceledException.10");
    }

    private abstract class Printer {
        private Printer() {
        }

        public void println(String string, int depth) {
            int i = 0;
            while (i < depth) {
                this.print('\t');
                ++i;
            }
            this.println(string);
        }

        protected abstract void println(String var1);

        protected abstract void print(char var1);
    }

    private class StreamPrinter
    extends Printer {
        private final PrintStream fStream;

        public StreamPrinter(PrintStream stream) {
            this.fStream = stream;
        }

        @Override
        protected void println(String string) {
            this.fStream.println(string);
        }

        @Override
        protected void print(char ch) {
            this.fStream.print(ch);
        }
    }

    private class WriterPrinter
    extends Printer {
        private final PrintWriter fWriter;

        public WriterPrinter(PrintWriter writer) {
            this.fWriter = writer;
        }

        @Override
        public void println(String string) {
            this.fWriter.println(string);
        }

        @Override
        protected void print(char ch) {
            this.fWriter.print(ch);
        }
    }
}

