/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression.variables;

import com.ibm.team.workitem.common.expression.variables.AnyoneVariable;
import com.ibm.team.workitem.common.expression.variables.AttributeParameterVariable;
import com.ibm.team.workitem.common.expression.variables.CurrentMilestoneVariable;
import com.ibm.team.workitem.common.expression.variables.CurrentUserVariable;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.MyCategoriesVariable;
import com.ibm.team.workitem.common.expression.variables.RelativeDateVariable;
import com.ibm.team.workitem.common.expression.variables.StatusVariable;
import com.ibm.team.workitem.common.expression.variables.WorkItemTypeVariable;
import java.util.ArrayList;
import java.util.List;

public class AttributeVariableFactory {
    private static final AttributeVariableFactory fgInstance = new AttributeVariableFactory();
    private List<String> fVariableNames;

    private AttributeVariableFactory() {
    }

    public static AttributeVariableFactory getInstance() {
        return fgInstance;
    }

    public IAttributeVariable<?> getVariable(String id) {
        if (id.equals("currentUser")) {
            return new CurrentUserVariable();
        }
        if (id.equals("now")) {
            return new RelativeDateVariable();
        }
        if (id.equals("state")) {
            return new StatusVariable();
        }
        if (id.equals("my categories")) {
            return new MyCategoriesVariable();
        }
        if (id.equals("current milestone")) {
            return new CurrentMilestoneVariable();
        }
        if (id.equals("typeCategory")) {
            return new WorkItemTypeVariable();
        }
        if (id.equals("anyone")) {
            return new AnyoneVariable();
        }
        if (id.equals("parameterVariable")) {
            return new AttributeParameterVariable();
        }
        return null;
    }

    public AttributeParameterVariable createParameterVariable(String attributeIdentifier) {
        if (this.fVariableNames == null) {
            this.fVariableNames = new ArrayList<String>();
        }
        String variableName = this.createUniqueVariableName(attributeIdentifier);
        return new AttributeParameterVariable(variableName);
    }

    public AttributeParameterVariable createParameterVariableWithName(String variableName) {
        if (this.fVariableNames == null) {
            this.fVariableNames = new ArrayList<String>();
        }
        if (!this.fVariableNames.contains(variableName)) {
            this.fVariableNames.add(variableName);
        }
        return new AttributeParameterVariable(variableName);
    }

    public boolean removeParameterVariable(IAttributeVariable<?> variable) {
        if (this.fVariableNames != null && variable != null) {
            return this.fVariableNames.remove(variable.getName());
        }
        return false;
    }

    private String createUniqueVariableName(String attributeIdentifier) {
        String result = String.valueOf(attributeIdentifier) + (this.fVariableNames.size() + 1);
        if (!this.fVariableNames.contains(result)) {
            this.fVariableNames.add(result);
        }
        return result;
    }
}

