/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.workflow.WorkflowInfo;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractAttributesByTypeAndStateAdvisor
implements IOperationAdvisor {
    private static final String WORK_ITEM = "workItem";
    private static final String CREATION = "creation";
    private static final String ID_ATTR = "id";
    private static final String UUID_ATTR = "UUID";
    public static final String PROPERTIES_ELEMENT = "properties";
    public static final String WORKFLOW_PROPERTIES_ELEMENT = "workflowProperties";
    public static final String TYPE_ATTRIBUTE = "workItemType";
    public static final String CATEGORY_ATTRIBUTE = "workItemTypeCategory";
    public static final String STATE_ID_ATTRIBUTE = "stateId";
    public static final String RESOLUTION_ID_ATTRIBUTE = "resolutionId";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String ID_ATTRIBUTE = "id";

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object data = operation.getOperationData();
        if (data instanceof ISaveParameter) {
            ISaveParameter saveParameter = (ISaveParameter)data;
            this.addProblems(advisorConfiguration, saveParameter, collector, monitor);
        }
    }

    private void addProblems(IProcessConfigurationElement advisorConfiguration, ISaveParameter saveParameter, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditable auditable = saveParameter.getNewState();
        if (auditable instanceof IWorkItem) {
            String workflowAction;
            IWorkItem workItem;
            IAuditableCommon auditableCommon = saveParameter.getSaveOperationParameter().getAuditableCommon();
            IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
            Set<String> attributeIds = AbstractAttributesByTypeAndStateAdvisor.getConfiguredAttributes(workItemCommon, workItem = (IWorkItem)auditable, workflowAction = saveParameter.getWorkflowAction(), advisorConfiguration, monitor);
            if (attributeIds.isEmpty()) {
                return;
            }
            this.processAttributes(saveParameter, workItem, attributeIds, workItemCommon, collector, monitor);
        }
    }

    protected abstract void processAttributes(ISaveParameter var1, IWorkItem var2, Collection<String> var3, IWorkItemCommon var4, IAdvisorInfoCollector var5, IProgressMonitor var6) throws TeamRepositoryException;

    public static Set<String> getConfiguredAttributes(IWorkItemCommon workItemCommon, IWorkItem workItem, String workflowAction, IProcessConfigurationElement advisorConfiguration, IProgressMonitor monitor) throws TeamRepositoryException {
        String resolutionId;
        IWorkItemType workItemType = workItemCommon.findWorkItemType(workItem.getProjectArea(), workItem.getWorkItemType(), monitor);
        if (workItemType == null) {
            return Collections.emptySet();
        }
        Set<String> attributeIds = AbstractAttributesByTypeAndStateAdvisor.readTypeAdvisorConfiguration(workItemType, advisorConfiguration);
        String stateId = AbstractAttributesByTypeAndStateAdvisor.findTargetStateId(workItem, workflowAction, workItemCommon, monitor);
        Identifier<IResolution> resolution = workItem.getResolution2();
        String string = resolutionId = resolution != null ? resolution.getStringIdentifier() : null;
        if (stateId != null) {
            attributeIds.addAll(AbstractAttributesByTypeAndStateAdvisor.readWorkflowAdvisorConfiguration(workItemType, stateId, resolutionId, advisorConfiguration));
        }
        return attributeIds;
    }

    private static String findTargetStateId(IWorkItem workItem, String actionId, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        Identifier<IState> state = workItem.getState2();
        IWorkflowInfo wfInfo = ((WorkItemCommon)workItemCommon).findWorkflowInfo(workItem, monitor);
        if (state == null && actionId == null && wfInfo != null) {
            String string = actionId = wfInfo.getStartActionId() == null ? null : wfInfo.getStartActionId().getStringIdentifier();
        }
        if (wfInfo != null && state != null && !Arrays.asList(wfInfo.getAllStateIds()).contains(state)) {
            String string = actionId = wfInfo.getStartActionId() == null ? null : wfInfo.getStartActionId().getStringIdentifier();
        }
        if (actionId != null && wfInfo != null && (state = wfInfo.getActionResultState(Identifier.create(IWorkflowAction.class, actionId))) == null) {
            String string = actionId = wfInfo.getStartActionId() == null ? null : wfInfo.getStartActionId().getStringIdentifier();
            if (actionId != null) {
                state = wfInfo.getActionResultState(Identifier.create(IWorkflowAction.class, actionId));
            }
        }
        if (state != null) {
            String stateId = state.getStringIdentifier();
            try {
                Integer.parseInt(stateId);
                stateId = "s" + stateId;
            }
            catch (NumberFormatException numberFormatException) {}
            return stateId;
        }
        return null;
    }

    public static Set<String> readWorkflowAdvisorConfiguration(IWorkItemType workItemType, String stateId, String resolutionId, IProcessConfigurationElement advisorConfiguration) {
        HashSet<String> attributeIds = new HashSet<String>();
        IProcessConfigurationElement[] configurationElements = advisorConfiguration.getChildren();
        int i = 0;
        while (i < configurationElements.length) {
            String requiredResolutionId;
            IProcessConfigurationElement configurationElement = configurationElements[i];
            if (WORKFLOW_PROPERTIES_ELEMENT.equals(configurationElement.getName()) && stateId.equals(configurationElement.getAttribute(STATE_ID_ATTRIBUTE)) && ((requiredResolutionId = WorkflowInfo.stripOffPrefix(configurationElement.getAttribute(RESOLUTION_ID_ATTRIBUTE), 'r')) == null || requiredResolutionId.equals(resolutionId))) {
                if (workItemType.getIdentifier().equals(configurationElement.getAttribute(TYPE_ATTRIBUTE))) {
                    AbstractAttributesByTypeAndStateAdvisor.readAttributeIds(attributeIds, configurationElement.getChildren());
                }
                if (workItemType.getCategory().equals(configurationElement.getAttribute(CATEGORY_ATTRIBUTE))) {
                    AbstractAttributesByTypeAndStateAdvisor.readAttributeIds(attributeIds, configurationElement.getChildren());
                }
            }
            ++i;
        }
        return attributeIds;
    }

    private static Set<String> readTypeAdvisorConfiguration(IWorkItemType workItemType, IProcessConfigurationElement advisorConfiguration) {
        HashSet<String> attributeIds = new HashSet<String>();
        IProcessConfigurationElement[] configurationElements = advisorConfiguration.getChildren();
        int i = 0;
        while (i < configurationElements.length) {
            IProcessConfigurationElement configurationElement = configurationElements[i];
            if (PROPERTIES_ELEMENT.equals(configurationElement.getName())) {
                if (configurationElement.getAttribute(TYPE_ATTRIBUTE) == null && configurationElement.getAttribute(CATEGORY_ATTRIBUTE) == null) {
                    AbstractAttributesByTypeAndStateAdvisor.readAttributeIds(attributeIds, configurationElement.getChildren());
                } else {
                    if (workItemType.getIdentifier().equals(configurationElement.getAttribute(TYPE_ATTRIBUTE))) {
                        AbstractAttributesByTypeAndStateAdvisor.readAttributeIds(attributeIds, configurationElement.getChildren());
                    }
                    if (workItemType.getCategory().equals(configurationElement.getAttribute(CATEGORY_ATTRIBUTE))) {
                        AbstractAttributesByTypeAndStateAdvisor.readAttributeIds(attributeIds, configurationElement.getChildren());
                    }
                }
            }
            ++i;
        }
        return attributeIds;
    }

    private static void readAttributeIds(Set<String> properties, IProcessConfigurationElement[] configurationElements) {
        int i = 0;
        while (i < configurationElements.length) {
            String property;
            IProcessConfigurationElement configurationElement = configurationElements[i];
            if (PROPERTY_ELEMENT.equals(configurationElement.getName()) && (property = configurationElement.getAttribute("id")) != null && property.length() != 0) {
                if ("version".equals(property)) {
                    property = IWorkItem.FOUND_IN_PROPERTY;
                }
                property = WorkItemAttributes.getAttributeId(Identifier.create(IAttribute.class, property));
                properties.add(property);
            }
            ++i;
        }
    }
}

