/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ProjectTimeCodesCache
extends CacheHelper {
    private static final String TIMETRACKING_CONFIG_POINT = "com.ibm.team.tpt.timetracking";
    private static final String TIMECODE_ELEMENT = "timecode";
    private static final String TIMECODE_LIST_ELEMENT = "timecodes";
    private static final String TIMECODES_CONFIG = "configuration";
    private Map<UUID, List<IWorkItemCommon.ITimeCode>> fCache = new HashMap<UUID, List<IWorkItemCommon.ITimeCode>>();

    public ProjectTimeCodesCache(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fCache.put(projectAreaHandle.getItemId(), this.readTimeCodes(projectAreaHandle));
    }

    public List<IWorkItemCommon.ITimeCode> getTimeCodes(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectAreaHandle, monitor);
        List<IWorkItemCommon.ITimeCode> timeCodes = this.fCache.get(projectAreaHandle.getItemId());
        if (timeCodes == null) {
            return Collections.emptyList();
        }
        return timeCodes;
    }

    private List<IWorkItemCommon.ITimeCode> readTimeCodes(IProjectAreaHandle projectAreaHandle) throws TeamRepositoryException {
        IProcessConfigurationElement[] dataElements;
        IProjectArea projectArea = this.getAuditableCommon().resolveAuditable((IAuditableHandle)projectAreaHandle, ItemProfile.PROJECT_AREA_FULL, null);
        IProcessConfigurationData data = this.getConfigurationPointData(TIMETRACKING_CONFIG_POINT, projectArea);
        if (data != null && (dataElements = data.getElements()) != null) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = dataElements;
            int n = dataElements.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement[] iProcessConfigurationElementArray2;
                IProcessConfigurationElement ele = iProcessConfigurationElementArray[n2];
                if (ele.getName().equals(TIMECODES_CONFIG) && ele.getAttribute("id").equals(TIMECODE_ELEMENT) && ele.getChildren() != null && (iProcessConfigurationElementArray2 = ele.getChildren()).length != 0) {
                    IProcessConfigurationElement configChild = iProcessConfigurationElementArray2[0];
                    return this.getTimecodeList(configChild);
                }
                ++n2;
            }
        }
        return null;
    }

    private IProcessConfigurationData getConfigurationPointData(String configPt, IProjectArea projectArea) throws TeamRepositoryException {
        IProcessConfigurationData data = null;
        NullProgressMonitor monitor = new NullProgressMonitor();
        IAuditableCommonProcess processService = this.getAuditableCommon().getProcess((IProcessAreaHandle)projectArea, (IProgressMonitor)monitor);
        if (processService != null) {
            data = processService.findProcessConfiguration(configPt, (IProgressMonitor)monitor);
        }
        return data;
    }

    private List<IWorkItemCommon.ITimeCode> getTimecodeList(IProcessConfigurationElement element) throws TeamRepositoryException {
        IProcessConfigurationElement[] childElementList;
        ArrayList<IWorkItemCommon.ITimeCode> result = new ArrayList<IWorkItemCommon.ITimeCode>();
        if (TIMECODE_LIST_ELEMENT.equals(element.getName()) && (childElementList = element.getChildren()) != null && childElementList.length > 0) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = childElementList;
            int n = childElementList.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement childElement = iProcessConfigurationElementArray[n2];
                if (childElement.getName().equals(TIMECODE_ELEMENT)) {
                    String id = childElement.getAttribute("id");
                    String label = childElement.getAttribute("name");
                    TimeCode timeCode = new TimeCode(id, label);
                    result.add(timeCode);
                }
                ++n2;
            }
        }
        return result;
    }

    private class TimeCode
    implements IWorkItemCommon.ITimeCode {
        private final String fLabel;
        private final String fId;

        public TimeCode(String id, String label) {
            this.fId = id;
            this.fLabel = label;
        }

        @Override
        public String getTimeCodeId() {
            return this.fId;
        }

        @Override
        public String getTimeCodeLabel() {
            return this.fLabel;
        }
    }
}

