/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.AttributeValueProviderRegistry;
import com.ibm.team.workitem.common.internal.attributeValueProviders.ICondition;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.ProviderContext;
import com.ibm.team.workitem.common.internal.util.AttributesAdvisorHelper;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReadOnlyAttributesByConditionAdvisor
implements IOperationAdvisor {
    public static final String ADVISOR_ID = "com.ibm.team.workitem.advisor.readOnlyAttributes";
    public static final String READ_ONLY_ATTRIBUTES = "readOnlyAttributes";

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        ISaveParameter saveParameter;
        IAuditable auditable;
        Object data = operation.getOperationData();
        if (data instanceof ISaveParameter && (auditable = (saveParameter = (ISaveParameter)data).getNewState()) instanceof IWorkItem) {
            IWorkItem newWorkItem = (IWorkItem)auditable;
            IAuditableCommon auditableCommon = saveParameter.getSaveOperationParameter().getAuditableCommon();
            IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
            List<String> attributes = ReadOnlyAttributesByConditionAdvisor.getReadOnlyAttributes(newWorkItem, workItemCommon, saveParameter.getWorkflowAction(), advisorConfiguration, false, monitor);
            if (attributes.isEmpty()) {
                return;
            }
            this.processAttributes(saveParameter, newWorkItem, attributes, workItemCommon, collector, monitor);
        }
    }

    public static List<String> getReadOnlyAttributes(IWorkItem workItem, IWorkItemCommon workItemCommon, String workflowAction, IProcessConfigurationElement advisorConfiguration, boolean ignoreScriptBasedAttributeAdvisors, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<String> attributes = new ArrayList<String>();
        for (AttributesAdvisorHelper.AttributeAdvisorConfiguration cfg : AttributesAdvisorHelper.getConfiguration(READ_ONLY_ATTRIBUTES, workItem.getProjectArea(), workItemCommon, advisorConfiguration, monitor)) {
            ICondition filter;
            IConfiguration providerConfiguration = cfg.getConfiguration(new ProviderContext(workflowAction));
            if (ignoreScriptBasedAttributeAdvisors && providerConfiguration.getScriptClass() != null || !(filter = AttributeValueProviderRegistry.getInstance().getCondition(providerConfiguration)).matches(workItem, workItemCommon, providerConfiguration, monitor)) continue;
            attributes.addAll(cfg.getAttributeIdentifiers());
        }
        return attributes;
    }

    private void processAttributes(ISaveParameter saveParameter, IWorkItem newWorkItem, List<String> attributes, IWorkItemCommon workItemCommon, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItem oldWorkItem;
        IAuditable oldAuditable = saveParameter.getOldState();
        if (!(oldAuditable instanceof IWorkItem)) {
            IWorkItemType workItemType = workItemCommon.findWorkItemType(newWorkItem.getProjectArea(), newWorkItem.getWorkItemType(), monitor);
            oldWorkItem = ((WorkItemCommon)workItemCommon).createWorkItem(workItemType, monitor);
        } else {
            oldWorkItem = (IWorkItem)oldAuditable;
        }
        for (String attributeId : attributes) {
            IAttribute attribute = workItemCommon.findAttribute(newWorkItem.getProjectArea(), attributeId, monitor);
            if (attribute == null || !oldWorkItem.hasAttribute(attribute) || !newWorkItem.hasAttribute(attribute)) continue;
            this.processAttribute(saveParameter, workItemCommon.getAuditableCommon(), newWorkItem, oldWorkItem, attribute, collector, monitor);
        }
    }

    private void processAttribute(ISaveParameter saveParameter, IAuditableCommon auditableCommon, IWorkItem newWorkItem, IWorkItem oldWorkItem, IAttribute attribute, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object newValue;
        Object oldValue;
        if (IWorkItem.COMMENTS_PROPERTY.equals(attribute.getIdentifier())) {
            oldValue = oldWorkItem.getComments().getContents().length;
            newValue = newWorkItem.getComments().getContents().length;
        } else {
            oldValue = attribute.getValue(auditableCommon, oldWorkItem, monitor);
            newValue = attribute.getValue(auditableCommon, newWorkItem, monitor);
        }
        if (!AttributesAdvisorHelper.equals(newValue, oldValue)) {
            TimeZone userTimeZone = saveParameter.getSaveOperationParameter().getUserTimeZone();
            IAdvisorInfo info = collector.createProblemInfo(this.getSummary(attribute), this.getDescription(newWorkItem, attribute, userTimeZone), ADVISOR_ID);
            info.setProblemObject((Object)newWorkItem.getItemHandle());
            info.setData(AttributesAdvisorHelper.createData(newWorkItem, attribute, READ_ONLY_ATTRIBUTES));
            collector.addInfo((IReportInfo)info);
        }
    }

    private String getSummary(IAttribute attribute) {
        return NLS.bind((String)Messages.getString("ReadOnlyAttributesByConditionAdvisor.ATTRIBUTE_MODIFIED_SUMMARY"), (Object)attribute.getDisplayName(), (Object[])new Object[0]);
    }

    private String getDescription(IWorkItem workItem, IAttribute attribute, TimeZone userTimeZone) {
        return NLS.bind((String)Messages.getString("ReadOnlyAttributesByConditionAdvisor.ATTRIBUTE_MODIFIED_DESCRIPTION"), (Object)attribute.getDisplayName(), (Object[])new Object[]{WorkItemTextUtilities.formatWorkItemId(workItem, userTimeZone)});
    }
}

