/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.identifiers;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.identifiers.AttributeFacade;
import com.ibm.team.workitem.common.internal.identifiers.IdentifierRegistry;
import com.ibm.team.workitem.common.internal.identifiers.Messages;
import java.lang.reflect.Constructor;

public class AttributeFacadeFactory {
    private final IWorkItemCommon fItemCommon;
    private final IProjectAreaHandle fProjectArea;

    public AttributeFacadeFactory(IProjectAreaHandle projectArea, IWorkItemCommon itemCommon) {
        this.fProjectArea = projectArea;
        this.fItemCommon = itemCommon;
    }

    public AttributeFacade create(Class<? extends IdentifierRegistry> identifierClass, Class<? extends AttributeFacade> facadeClass) {
        try {
            Constructor<? extends AttributeFacade> ctor = facadeClass.getDeclaredConstructor(Class.class, IProjectAreaHandle.class, IWorkItemCommon.class);
            return ctor.newInstance(identifierClass, this.fProjectArea, this.fItemCommon);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(Messages.getString("AttributeFacadeFactory_ERROR_ON_INSTANTIATE_FACADE"));
        }
    }
}

