/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.oslc.mappings;

import com.ibm.team.calm.foundation.common.CustomNamespaceContext;
import com.ibm.team.calm.foundation.common.Namespaces;
import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.oslc.OSLCCoreIdentifiers;
import com.ibm.team.calm.foundation.common.oslc.Version;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeTypeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.OSLCAttributeDefinitionRegistry;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AttributeRegistry {
    private static AttributeRegistry fgRegistry;
    private final Map<String, IAttributeTypeDescriptor> fTypeDescriptors = new HashMap<String, IAttributeTypeDescriptor>();
    private Timestamp fLastModified;

    public static synchronized AttributeRegistry getInstance() {
        if (fgRegistry == null) {
            fgRegistry = new AttributeRegistry();
            new OSLCAttributeDefinitionRegistry().start();
        }
        return fgRegistry;
    }

    private AttributeRegistry() {
    }

    void addTypeDescriptor(IAttributeTypeDescriptor descriptor) {
        this.fTypeDescriptors.put(descriptor.getAttributeTypeIdentifier(), descriptor);
        this.setLastModified(System.currentTimeMillis());
    }

    void removeTypeDescriptor(String attributeType) {
        this.fTypeDescriptors.remove(attributeType);
        this.setLastModified(System.currentTimeMillis());
    }

    public boolean hasAttributeType(String attributeType) {
        return this.fTypeDescriptors.get(attributeType) != null;
    }

    public IAttributeTypeDescriptor getTypeDescriptor(String attributeType) {
        return this.fTypeDescriptors.get(attributeType);
    }

    public IAttributeTypeDescriptor getTypeDescriptorByItemType(IItemType itemType) {
        String itemTypeId = String.valueOf(itemType.getNamespaceURI()) + '.' + itemType.getName();
        for (IAttributeTypeDescriptor desc : this.fTypeDescriptors.values()) {
            if (!itemTypeId.equals(desc.getItemTypeId())) continue;
            return desc;
        }
        return null;
    }

    public Collection<IAttributeDescriptor> getAttributeDescriptor(String attributeType) {
        IAttributeTypeDescriptor typeMapping = this.fTypeDescriptors.get(attributeType);
        return typeMapping != null ? typeMapping.getAttributeDescriptors() : Collections.emptyList();
    }

    public IAttributeDescriptor getAttributeDescriptor(String attributeType, String internalAttributeId) {
        IAttributeTypeDescriptor typeMapping = this.fTypeDescriptors.get(attributeType);
        return typeMapping != null ? typeMapping.getAttributeDescriptor(internalAttributeId) : null;
    }

    public IAttributeDescriptor getAttributeDescriptor(String attributeType, Property property, Version version) {
        return this.getAttributeDescriptor(attributeType, property.getNamespaceURI(), property.getName(), version);
    }

    public IAttributeDescriptor getAttributeDescriptor(String attributeType, String nsUri, String elementName, Version version) {
        IAttributeTypeDescriptor typeMapping = this.fTypeDescriptors.get(attributeType);
        return typeMapping != null ? typeMapping.getAttributeDescriptor(version, nsUri, elementName) : null;
    }

    public Collection<IAttributeTypeDescriptor> getTypeDescriptors(Version version) {
        ArrayList<IAttributeTypeDescriptor> descriptors = new ArrayList<IAttributeTypeDescriptor>(this.fTypeDescriptors.values());
        Iterator iterator = descriptors.iterator();
        while (iterator.hasNext()) {
            IAttributeTypeDescriptor descriptor = (IAttributeTypeDescriptor)iterator.next();
            if (descriptor.matchesVersion(version)) continue;
            iterator.remove();
        }
        return descriptors;
    }

    public CustomNamespaceContext getNamespaceContext(String attributeType, Version version) {
        CustomNamespaceContext namespaceContext = null;
        IAttributeTypeDescriptor typeDescriptor = this.getTypeDescriptor(attributeType);
        if (typeDescriptor != null) {
            namespaceContext = typeDescriptor.getNamespaceContext(version);
        }
        if (namespaceContext == null) {
            namespaceContext = Namespaces.createDefaultContext();
            if (OSLCCoreIdentifiers.VERSION_OSLC_CORE_20.equals((Object)version)) {
                namespaceContext.setPrefixSuggestion("http://purl.org/dc/terms/", "dcterms");
            }
        }
        return namespaceContext;
    }

    public Timestamp getLastModified() {
        return this.fLastModified;
    }

    private void setLastModified(long lastModified) {
        this.fLastModified = new Timestamp(lastModified);
    }
}

