/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.team.repository.common.query.ast.IDateTimeField;
import com.ibm.team.repository.common.query.ast.IDateTimeInputArg;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IFilterElement;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.INumericField;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.expression.variables.TimeSpan;
import com.ibm.team.workitem.common.internal.expression.ITransformationContext;
import com.ibm.team.workitem.common.model.AttributeOperation;
import java.sql.Timestamp;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ComparisonOperation
extends AttributeOperation {
    private final boolean fRangeCorrection;

    protected ComparisonOperation(String identifier, String displayName) {
        this(identifier, displayName, true);
    }

    protected ComparisonOperation(String identifier, String displayName, boolean rangeCorrection) {
        super(identifier, displayName);
        this.fRangeCorrection = rangeCorrection;
    }

    @Override
    public boolean evaluate(Object left, Object right, IEvaluationContext context, IProgressMonitor monitor) {
        if (left instanceof Comparable && right instanceof Comparable) {
            return this.compare((Comparable)left, (Comparable)right);
        }
        return false;
    }

    protected abstract boolean compare(Comparable<Object> var1, Comparable<Object> var2);

    @Override
    public IPredicate getPredicate(ITransformationContext context, IProgressMonitor monitor) {
        IPredicate predicate;
        IField field = context.getField();
        if (field instanceof IDateTimeField) {
            IDateTimeInputArg inputArg = context.getQuery().newDateTimeArg();
            if (context.getValue() instanceof Timestamp) {
                if (this.fRangeCorrection) {
                    TimeSpan timeSpan = TimeSpan.createTimeSpan((Timestamp)context.getValue(), 5, context.getTimeZone());
                    context.addParameter(this.getTimeSpanReference(timeSpan));
                } else {
                    context.addParameter(context.getValue());
                }
            } else if (context.getValue() instanceof TimeSpan) {
                TimeSpan timeSpan = (TimeSpan)context.getValue();
                context.addParameter(this.getTimeSpanReference(timeSpan));
            } else {
                context.addParameter(context.getValue());
            }
            predicate = context.getAttribute().isStateExtension() ? this.handleStateExtension(context, (IFilterElement)inputArg) : this.createPredicate((IDateTimeField)field, inputArg);
        } else if (field instanceof INumericField) {
            INumeric inputArg = this.createNumericInputArg(context);
            context.addParameter(context.getValue());
            predicate = context.getAttribute().isStateExtension() ? this.handleStateExtension(context, (IFilterElement)inputArg) : this.createPredicate((INumericField)field, inputArg);
        } else {
            throw new IllegalArgumentException("Unsupported field type");
        }
        return predicate;
    }

    protected abstract IPredicate createPredicate(INumericField var1, INumeric var2);

    protected abstract IPredicate createPredicate(IDateTimeField var1, IDateTimeInputArg var2);

    protected abstract IPredicate handleStateExtension(ITransformationContext var1, IFilterElement var2);

    protected abstract Timestamp getTimeSpanReference(TimeSpan var1);
}

