/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query.impl;

import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ExpressionVisitor;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.ParameterVariableContext;
import java.util.Collection;
import java.util.HashSet;

public class ParameterVariableResolver
extends ExpressionVisitor {
    private final ParameterVariableContext fContext;
    private final Collection<IAttributeVariable<?>> fUnresolvedVariables;

    public ParameterVariableResolver(ParameterVariableContext context) {
        this.fContext = context != null ? context : new ParameterVariableContext();
        this.fUnresolvedVariables = new HashSet();
    }

    @Override
    public boolean visit(Term term) {
        Object[] objectArray = term.getExpressions().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableAttributeExpression curVariableExpression;
            IAttributeVariable<?> curVariable;
            Object cur = objectArray[n2];
            if (cur instanceof VariableAttributeExpression && (curVariable = (curVariableExpression = (VariableAttributeExpression)cur).getVariable()) != null && curVariable.isParameter()) {
                Expression curValueExpression = this.fContext.getVariableValue(curVariable.getName());
                if (this.fContext.hasVariableValue(curVariable.getName())) {
                    term.replace((Expression)cur, curValueExpression);
                } else {
                    this.fUnresolvedVariables.add(curVariable);
                }
            }
            ++n2;
        }
        return super.visit(term);
    }

    public Collection<IAttributeVariable<?>> getUnresolvedVariables() {
        return this.fUnresolvedVariables;
    }
}

