/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.rcp.dto.impl;

import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IParticipantReport;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.repository.common.IReconcileReport;
import com.ibm.team.workitem.common.internal.rcp.dto.SaveResultDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.impl.Messages;
import com.ibm.team.workitem.common.internal.rcp.dto.impl.MultiSaveResultDTOImpl;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class MultiSaveResultDTOCustomImpl
extends MultiSaveResultDTOImpl {
    private static final int INTERNAL_CODE = 1;

    @Override
    public int getSeverity() {
        int maxSeverity = 0;
        for (SaveResultDTO result : this.getSaveResults()) {
            maxSeverity = this.maxSeverity(maxSeverity, result.getSeverity());
        }
        return maxSeverity;
    }

    @Override
    public boolean isSuccessful() {
        for (SaveResultDTO result : this.getSaveResults()) {
            if (result.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isConflictingUpdate() {
        for (SaveResultDTO result : this.getSaveResults()) {
            if (!result.isConflictingUpdate()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IStatus getStatus() {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        for (SaveResultDTO result : this.getSaveResults()) {
            IStatus status = result.getStatus();
            if (status.isOK()) continue;
            statuses.add(status);
        }
        if (statuses.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (statuses.size() == 1) {
            return (IStatus)statuses.get(0);
        }
        return new MultiStatus("com.ibm.team.workitem.common", 1, statuses.toArray(new IStatus[statuses.size()]), Messages.getString("MultiSaveResultDTOCustomImpl.SAVE_STATUS"), null);
    }

    @Override
    public String getFailureMessage() {
        if (this.isConflictingUpdate()) {
            return Messages.getString("MultiSaveResultDTOCustomImpl.CONFLICTING_UPDATE_MESSAGE");
        }
        for (SaveResultDTO result : this.getSaveResults()) {
            IStatus status = result.getStatus();
            if (status.getSeverity() == 4 || status.getSeverity() == 8) {
                return status.getMessage();
            }
            IOperationReport operationReport = result.getOperationReport();
            if (operationReport == null || operationReport.getSeverity() != 4) continue;
            IParticipantReport[] participantReports = operationReport.getParticipantReports();
            int i = 0;
            while (i < participantReports.length) {
                IParticipantReport participantReport = participantReports[i];
                if (participantReport.getSeverity() == 4) {
                    IReportInfo[] advisorProblems = participantReport.getInfos();
                    int j = 0;
                    while (j < advisorProblems.length) {
                        IReportInfo advisorProblem = advisorProblems[j];
                        if (advisorProblem.getSeverity() == 4) {
                            return advisorProblem.getSummary();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return this.isSuccessful() ? Messages.getString("MultiSaveResultDTOCustomImpl.SUCCESS_MESSAGE") : Messages.getString("MultiSaveResultDTOCustomImpl.FAILED_MESSAGE");
    }

    @Override
    public IReconcileReport[] getReconcileReports() {
        List saveResults = this.getSaveResults();
        ArrayList<IReconcileReport> reconcileReports = new ArrayList<IReconcileReport>(saveResults.size());
        for (SaveResultDTO saveResult : saveResults) {
            if (saveResult.getReconcileReport() == null) continue;
            reconcileReports.add(saveResult.getReconcileReport());
        }
        return reconcileReports.toArray(new IReconcileReport[reconcileReports.size()]);
    }

    private int maxSeverity(int left, int right) {
        if (left == 4 || right == 4) {
            return 4;
        }
        return Math.max(left, right);
    }
}

