/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.setup.builders;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import com.ibm.team.workitem.common.internal.model.ApprovalDescriptor;
import com.ibm.team.workitem.common.internal.model.ModelFactory;
import com.ibm.team.workitem.common.internal.setup.builders.ApprovalBuilder;
import com.ibm.team.workitem.common.internal.setup.builders.WorkItemBuilderContext;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovalType;
import com.ibm.team.workitem.common.model.IApprovals;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import java.sql.Timestamp;
import java.util.List;

public class ApprovalDescriptorBuilder
extends AbstractArtifactBuilder<IApprovalDescriptor> {
    protected static final ValueKey<String> NAME = new ValueKey(String.valueOf(ApprovalDescriptorBuilder.class.getName()) + ".name");
    protected static final ValueKey<Integer> ID = new ValueKey(String.valueOf(ApprovalDescriptorBuilder.class.getName()) + ".id");
    protected static final ValueKey<UUID> INTERNAL_ID = new ValueKey(String.valueOf(ApprovalDescriptorBuilder.class.getName()) + ".internalId");
    protected static final ValueKey<String> TYPE = new ValueKey(String.valueOf(ApprovalDescriptorBuilder.class.getName()) + ".type");
    protected static final ValueKey<String> STATE = new ValueKey(String.valueOf(ApprovalDescriptorBuilder.class.getName()) + ".state");
    protected static final ValueKey<Timestamp> DUE_DATE = new ValueKey(String.valueOf(ApprovalDescriptorBuilder.class.getName()) + ".dueDate");

    public ApprovalDescriptorBuilder(IArtifactBuilderContext context) {
        super(context);
    }

    public ApprovalDescriptorBuilder id(int id) {
        this.setBuilderValue(ID, id);
        return this;
    }

    public ApprovalDescriptorBuilder internalId(UUID uuid) {
        this.setBuilderValue(INTERNAL_ID, uuid);
        return this;
    }

    public ApprovalDescriptorBuilder name(String name) {
        this.setBuilderValue(NAME, name);
        return this;
    }

    public ApprovalDescriptorBuilder typeIdentifier(String typeIdentifier) {
        this.setBuilderValue(TYPE, typeIdentifier);
        return this;
    }

    public ApprovalDescriptorBuilder type(IApprovalType type) {
        this.setBuilderValue(TYPE, type != null ? type.getIdentifier() : null);
        return this;
    }

    public ApprovalDescriptorBuilder cumulativeStateIdentifier(String stateIdentifier) {
        this.setBuilderValue(STATE, stateIdentifier);
        return this;
    }

    public ApprovalDescriptorBuilder cumulativeState(IApprovalState state) {
        this.setBuilderValue(STATE, state != null ? state.getIdentifier() : null);
        return this;
    }

    public ApprovalDescriptorBuilder dueDate(Timestamp dueDate) {
        this.setBuilderValue(DUE_DATE, dueDate);
        return this;
    }

    public ApprovalDescriptorBuilder approvals(ApprovalBuilder ... approvalBuilders) {
        if (approvalBuilders != null) {
            this.addChildBuilder((IArtifactBuilder[])approvalBuilders);
        }
        return this;
    }

    protected IApprovalDescriptor doBuild(BuildContext buildContext) {
        IApprovals approvals = (IApprovals)buildContext.getProperty(WorkItemBuilderContext.APPROVALS);
        ApprovalDescriptor approvalDescriptor = this.artifactExists() ? (ApprovalDescriptor)this.getExistingArtifact() : (approvals != null ? (ApprovalDescriptor)approvals.createDescriptor((String)this.getBuilderValue(TYPE, WorkItemApprovals.APPROVAL_TYPE.getIdentifier()), (String)this.getBuilderValue(NAME, WorkItemApprovals.APPROVAL_TYPE.getDisplayName())) : ModelFactory.eINSTANCE.createApprovalDescriptor());
        approvalDescriptor.setName((String)this.chooseValue(NAME, approvalDescriptor.getName()));
        approvalDescriptor.setId((Integer)this.chooseValue(ID, approvalDescriptor.getId()));
        approvalDescriptor.setInternalId((UUID)this.chooseValue(INTERNAL_ID, approvalDescriptor.getInternalId(), UUID.generate()));
        approvalDescriptor.setTypeIdentifier((String)this.chooseValue(TYPE, approvalDescriptor.getTypeIdentifier()));
        approvalDescriptor.setCumulativeStateIdentifier((String)this.chooseValue(STATE, approvalDescriptor.getCumulativeStateIdentifier()));
        approvalDescriptor.setDueDate((Timestamp)this.chooseValue(DUE_DATE, approvalDescriptor.getDueDate()));
        if (approvals != null) {
            approvals.add(approvalDescriptor);
        }
        BuildContext childContext = new BuildContext(buildContext);
        childContext.setProperty(WorkItemBuilderContext.APPROVAL_DESCRIPTOR, (Object)approvalDescriptor);
        List childBuilders = this.getChildBuilders();
        for (IArtifactBuilder cur : childBuilders) {
            cur.build(childContext);
        }
        return approvalDescriptor;
    }

    protected IApprovalDescriptor doSave(BuildContext context) throws TeamRepositoryException {
        throw new UnsupportedOperationException("Cannot save approval descriptors standalone. To save an apporval, build it into a workitem and save the workitem");
    }
}

