/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.setup.builders;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import com.ibm.team.workitem.common.internal.model.Approvals;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.setup.builders.ApprovalDescriptorBuilder;
import com.ibm.team.workitem.common.internal.setup.builders.WorkItemBuilder;
import com.ibm.team.workitem.common.internal.setup.builders.WorkItemBuilderContext;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovals;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.LinkedList;
import java.util.List;

public class ApprovalsBuilder
extends AbstractArtifactBuilder<IApprovals> {
    private static final ValueKey<IWorkItem> WORKITEM = new ValueKey(String.valueOf(ApprovalsBuilder.class.getName()) + ".workitem");
    private static final ValueKey<List<IApprovalDescriptor>> APPROVAL_DESCRIPTORS = new ValueKey(String.valueOf(ApprovalsBuilder.class.getName()) + ".approvalDescriptors");

    public ApprovalsBuilder(IArtifactBuilderContext buildContext) {
        super(buildContext);
        this.setBuilderValue(APPROVAL_DESCRIPTORS, new LinkedList());
    }

    public ApprovalsBuilder workitem(IWorkItem workItem) {
        this.setBuilderValue(WORKITEM, workItem);
        return this;
    }

    public ApprovalsBuilder workitem(WorkItemBuilder workItemBuilder) {
        this.setBuilderValue(WORKITEM, (IWorkItem)workItemBuilder.build());
        return this;
    }

    public ApprovalsBuilder descriptors(ApprovalDescriptorBuilder ... descriptors) {
        if (descriptors != null) {
            ApprovalDescriptorBuilder[] approvalDescriptorBuilderArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ApprovalDescriptorBuilder builder = approvalDescriptorBuilderArray[n2];
                this.addChildBuilder(new IArtifactBuilder[]{builder});
                ++n2;
            }
        }
        return this;
    }

    protected IApprovals doBuild(BuildContext buildContext) {
        IWorkItem workItem = (IWorkItem)this.getBuilderValue(WORKITEM, (IWorkItem)buildContext.getProperty(WorkItemBuilderContext.WORKITEM));
        if (workItem == null) {
            throw new IllegalArgumentException("Builder must call .workitem() or pass workitem in the build context before calling build()");
        }
        IApprovals approvals = this.artifactExists() ? (IApprovals)this.getExistingArtifact() : new Approvals((WorkItem)workItem);
        for (IArtifactBuilder childBuilder : this.getChildBuilders()) {
            childBuilder.build(new BuildContext(buildContext).setProperty(WorkItemBuilderContext.APPROVALS, (Object)approvals));
        }
        return approvals;
    }

    protected IApprovals doSave(BuildContext context) throws TeamRepositoryException {
        throw new UnsupportedOperationException("Cannot save approvals standalone. To save an apporval, build it into a workitem and save the workitem");
    }
}

