/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.setup.builders;

import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.internal.expression.QueryableLinkAttribute;
import com.ibm.team.workitem.common.internal.setup.builders.ExpressionBuilder;
import com.ibm.team.workitem.common.internal.util.QueryableAttributePath;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;

public class AttributeExpressionBuilder
extends ExpressionBuilder<AttributeExpression> {
    protected static final ValueKey<AttributeOperation> OPERATION = new ValueKey(String.valueOf(AttributeExpressionBuilder.class.getName()) + ".operation");
    protected static final ValueKey<IQueryableAttribute> QUERY_ATTRIBUTE = new ValueKey(String.valueOf(AttributeExpressionBuilder.class.getName()) + ".queryAttribute");
    protected static final ValueKey<String> ATTRIBUTE_ID = new ValueKey(String.valueOf(AttributeExpressionBuilder.class.getName()) + ".attributeId");
    protected static final ValueKey<IAttribute> ATTRIBUTE = new ValueKey(String.valueOf(AttributeExpressionBuilder.class.getName()) + ".attribute");
    protected static final ValueKey<IProjectAreaHandle> PROJECT_AREA = new ValueKey(String.valueOf(AttributeExpressionBuilder.class.getName()) + ".projectArea");
    protected static final ValueKey<IEndPointDescriptor> END_POINT = new ValueKey(String.valueOf(AttributeExpressionBuilder.class.getName()) + ".endPoint");
    protected static final ValueKey<Object> VALUE = new ValueKey(String.valueOf(AttributeExpressionBuilder.class.getName()) + ".value");

    public AttributeExpressionBuilder(IArtifactBuilderContext buildContext) {
        super(buildContext);
    }

    public AttributeExpressionBuilder operation(AttributeOperation operation) {
        this.setBuilderValue(OPERATION, operation);
        return this;
    }

    public AttributeExpressionBuilder attribute(IQueryableAttribute attribute) {
        this.setBuilderValue(QUERY_ATTRIBUTE, attribute);
        return this;
    }

    public AttributeExpressionBuilder attribute(IAttribute attribute) {
        this.setBuilderValue(ATTRIBUTE, attribute);
        return this;
    }

    public AttributeExpressionBuilder attribute(IAttribute attribute, IEndPointDescriptor endPoint) {
        this.setBuilderValue(ATTRIBUTE, attribute);
        this.setBuilderValue(END_POINT, endPoint);
        return this;
    }

    public AttributeExpressionBuilder attribute(IProjectAreaHandle projectArea, String attributeId) {
        this.setBuilderValue(PROJECT_AREA, projectArea);
        this.setBuilderValue(ATTRIBUTE_ID, attributeId);
        return this;
    }

    public AttributeExpressionBuilder attribute(String attributeId) {
        this.setBuilderValue(ATTRIBUTE_ID, attributeId);
        return this;
    }

    public AttributeExpressionBuilder attribute(IProjectAreaHandle projectArea, IEndPointDescriptor endPoint) {
        this.setBuilderValue(PROJECT_AREA, projectArea);
        this.setBuilderValue(END_POINT, endPoint);
        return this;
    }

    public AttributeExpressionBuilder attribute(IEndPointDescriptor endPoint) {
        this.setBuilderValue(END_POINT, endPoint);
        return this;
    }

    public AttributeExpressionBuilder attribute(IProjectAreaHandle projectArea, String attributeId, IEndPointDescriptor endPoint) {
        this.setBuilderValue(PROJECT_AREA, projectArea);
        this.setBuilderValue(ATTRIBUTE_ID, attributeId);
        this.setBuilderValue(END_POINT, endPoint);
        return this;
    }

    public AttributeExpressionBuilder attribute(String attributeId, IEndPointDescriptor endPoint) {
        this.setBuilderValue(ATTRIBUTE_ID, attributeId);
        this.setBuilderValue(END_POINT, endPoint);
        return this;
    }

    public AttributeExpressionBuilder value(Object value) {
        this.setBuilderValue(VALUE, value);
        return this;
    }

    protected AttributeExpression doBuild(BuildContext context) {
        IQueryableAttribute attribute = (IQueryableAttribute)this.getBuilderValue(QUERY_ATTRIBUTE);
        AttributeOperation operation = (AttributeOperation)this.getBuilderValue(OPERATION, attribute != null ? AttributeTypes.getAttributeType(attribute.getAttributeType()).getOperations()[0] : AttributeTypes.getAttributeType("smallString").getOperations()[0]);
        return new AttributeExpression(attribute, operation, this.getBuilderValue(VALUE));
    }

    @Override
    AttributeExpression prepareSave(BuildContext context) throws TeamRepositoryException {
        if (!this.isBuilderValueSet(PROJECT_AREA) && context.isPropertySet(BuildContext.PROJECT_AREA)) {
            this.setBuilderValue(PROJECT_AREA, (IProjectAreaHandle)context.getProperty(BuildContext.PROJECT_AREA));
        }
        IQueryableAttribute attribute = this.getAttribute();
        AttributeOperation operation = (AttributeOperation)this.getBuilderValue(OPERATION, this.getDefaultOperation(attribute));
        Object value = this.getBuilderValue(VALUE);
        if (value instanceof IAttributeVariable) {
            return new VariableAttributeExpression(attribute, operation, (IAttributeVariable)value);
        }
        return new AttributeExpression(attribute, operation, value);
    }

    private IQueryableAttribute getAttribute() throws TeamRepositoryException {
        if (this.isBuilderValueSet(QUERY_ATTRIBUTE)) {
            return (IQueryableAttribute)this.getBuilderValue(QUERY_ATTRIBUTE);
        }
        if (this.isBuilderValueSet(ATTRIBUTE)) {
            return QueryableAttributes.getFactory(IWorkItem.ITEM_TYPE).findAttribute(((IAttribute)this.getBuilderValue(ATTRIBUTE)).getProjectArea(), this.getAttributePath(((IAttribute)this.getBuilderValue(ATTRIBUTE)).getIdentifier()), (IAuditableCommon)this.getContext().getLibrary(IAuditableCommon.class), null);
        }
        if (this.isBuilderValueSet(ATTRIBUTE_ID)) {
            return QueryableAttributes.getFactory(IWorkItem.ITEM_TYPE).findAttribute((IProjectAreaHandle)this.getBuilderValue(PROJECT_AREA), this.getAttributePath((String)this.getBuilderValue(ATTRIBUTE_ID)), (IAuditableCommon)this.getContext().getLibrary(IAuditableCommon.class), null);
        }
        if (this.isBuilderValueSet(END_POINT)) {
            return QueryableAttributes.getFactory(IWorkItem.ITEM_TYPE).findAttribute((IProjectAreaHandle)this.getBuilderValue(PROJECT_AREA), null, (IAuditableCommon)this.getContext().getLibrary(IAuditableCommon.class), null);
        }
        throw new TeamRepositoryException("Attribute is not set");
    }

    private AttributeOperation getDefaultOperation(IQueryableAttribute attribute) {
        if (this.isBuilderValueSet(OPERATION)) {
            return (AttributeOperation)this.getBuilderValue(OPERATION);
        }
        if (attribute instanceof QueryableLinkAttribute) {
            return AttributeOperation.LINK_EXISTS;
        }
        return AttributeTypes.getAttributeType(attribute.getAttributeType()).getOperations()[0];
    }

    private String getAttributePath(String attributeId) {
        return this.isBuilderValueSet(END_POINT) ? (attributeId != null ? QueryableAttributePath.createPathString(QueryableLinkAttribute.createIdentifier((IEndPointDescriptor)this.getBuilderValue(END_POINT)), attributeId) : QueryableLinkAttribute.createIdentifier((IEndPointDescriptor)this.getBuilderValue(END_POINT))) : attributeId;
    }
}

