/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.setup.builders;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.model.Deliverable;
import com.ibm.team.workitem.common.model.IDeliverable;
import java.sql.Timestamp;

public class DeliverableBuilder
extends AbstractArtifactBuilder<IDeliverable> {
    protected static final ValueKey<IProjectAreaHandle> PROJECT_AREA = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".projectArea");
    protected static final ValueKey<String> NAME = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".displayName");
    protected static final ValueKey<XMLString> DESCRIPTION = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".description");
    protected static final ValueKey<UUID> CONTEXT_ID = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".contextId");
    protected static final ValueKey<Timestamp> CREATION_DATE = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".creationDate");
    protected static final ValueKey<Boolean> ARCHIVED = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".archived");
    protected static final ValueKey<Boolean> FILTERED = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".filtered");

    public DeliverableBuilder(IArtifactBuilderContext context) {
        super(context);
    }

    public DeliverableBuilder contextId(UUID contextId) {
        this.setBuilderValue(CONTEXT_ID, contextId);
        return this;
    }

    public DeliverableBuilder projectArea(IProjectAreaHandle projectArea) {
        this.setBuilderValue(PROJECT_AREA, projectArea);
        return this;
    }

    public DeliverableBuilder name(String name) {
        this.setBuilderValue(NAME, name);
        return this;
    }

    public DeliverableBuilder description(String description) {
        return this.description(XMLString.createFromPlainText((String)description));
    }

    public DeliverableBuilder description(XMLString description) {
        this.setBuilderValue(DESCRIPTION, description);
        return this;
    }

    public DeliverableBuilder archived(boolean archived) {
        this.setBuilderValue(ARCHIVED, archived);
        return this;
    }

    public DeliverableBuilder filtered(boolean filtered) {
        this.setBuilderValue(FILTERED, filtered);
        return this;
    }

    public DeliverableBuilder creationDate(Timestamp creationDate) {
        this.setBuilderValue(CREATION_DATE, creationDate);
        return this;
    }

    protected IDeliverable doBuild(BuildContext buildContext) {
        Deliverable deliverable = (Deliverable)this.artifact(IDeliverable.ITEM_TYPE);
        deliverable.setProjectArea((IProjectAreaHandle)this.getBuilderValue(PROJECT_AREA, deliverable.getProjectArea()));
        deliverable.setContextId((UUID)this.getBuilderValue(CONTEXT_ID, deliverable.getContextId()));
        return this.setDeliverableFields(deliverable);
    }

    protected IDeliverable doSave(BuildContext saveContext) throws TeamRepositoryException {
        if (!(this.artifactExists() || this.isBuilderValueSet(PROJECT_AREA) || saveContext.isPropertySet(BuildContext.PROJECT_AREA))) {
            throw new IllegalStateException("Cannot create a deliverable without setting the project area via projectArea() call or the saveContext");
        }
        IAuditableCommon auditableCommon = (IAuditableCommon)this.getContext().getLibrary(IAuditableCommon.class);
        IWorkItemCommon workItemCommon = (IWorkItemCommon)this.getContext().getLibrary(IWorkItemCommon.class);
        IDeliverable deliverable = this.artifactExists() ? (IDeliverable)this.artifact(IDeliverable.ITEM_TYPE) : workItemCommon.createDeliverable((IProjectAreaHandle)this.getBuilderValue(PROJECT_AREA, (IProjectAreaHandle)saveContext.getProperty(BuildContext.PROJECT_AREA)), (String)this.getBuilderValue(NAME, "Deliverable " + UUID.generate().getUuidValue()), null);
        workItemCommon.saveDeliverable(this.setDeliverableFields(deliverable), null);
        return auditableCommon.resolveAuditable(deliverable, IDeliverable.FULL_PROFILE, null);
    }

    protected IDeliverable setDeliverableFields(IDeliverable deliverable) {
        deliverable.setName((String)this.chooseValue(NAME, "Deliverable " + UUID.generate()));
        deliverable.setHTMLDescription((XMLString)this.chooseValue(DESCRIPTION, XMLString.createFromPlainText((String)"some description")));
        deliverable.setArchived((Boolean)this.chooseValue(ARCHIVED, false));
        deliverable.setFiltered((Boolean)this.chooseValue(FILTERED, false));
        deliverable.setCreationDate((Timestamp)this.chooseValue(CREATION_DATE, new Timestamp(System.currentTimeMillis())));
        return deliverable;
    }
}

