/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.template.xml;

import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.oslc.OSLCIdentifiers;
import com.ibm.team.calm.foundation.common.oslc.RDFIdentifiers;
import com.ibm.team.links.common.ILink;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.identifiers.AttributeFacade;
import com.ibm.team.workitem.common.internal.identifiers.AttributeFacadeFactory;
import com.ibm.team.workitem.common.internal.identifiers.IInternalAttributeIdentifiers;
import com.ibm.team.workitem.common.internal.identifiers.IPublicAttribute;
import com.ibm.team.workitem.common.internal.identifiers.IPublicItem;
import com.ibm.team.workitem.common.internal.identifiers.IdentifierMapping;
import com.ibm.team.workitem.common.internal.template.AttributeVariable;
import com.ibm.team.workitem.common.internal.template.WorkItemDescriptor;
import com.ibm.team.workitem.common.internal.template.WorkItemTemplate;
import com.ibm.team.workitem.common.internal.template.WorkItemTemplateFacade;
import com.ibm.team.workitem.common.internal.template.WorkItemTemplateIdentifierRegistry;
import com.ibm.team.workitem.common.internal.template.xml.IllegalFormatException;
import com.ibm.team.workitem.common.internal.template.xml.Messages;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.template.IAttributeVariable;
import com.ibm.team.workitem.common.template.ITemplateAttributeIdentifiers;
import com.ibm.team.workitem.common.template.ITemplateTypeIdentifiers;
import com.ibm.team.workitem.common.template.IWorkItemDescriptor;
import com.ibm.team.workitem.common.template.IWorkItemTemplate;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTemplateParser {
    private static final String ILLEGAL_FORMAT_ERROR = Messages.getString("XMLTemplateParser.ERROR_ILLEGAL_FORMAT");
    private final IProjectAreaHandle fProjectArea;
    private final AttributeFacade fAttributeFacade;

    public XMLTemplateParser(IProjectAreaHandle project, IWorkItemCommon common) {
        this.fProjectArea = project;
        this.fAttributeFacade = new AttributeFacadeFactory(project, common).create(WorkItemTemplateIdentifierRegistry.class, WorkItemTemplateFacade.class);
    }

    public IWorkItemTemplate parseTemplate(String tmplXML) throws TeamRepositoryException {
        WorkItemTemplate result = null;
        Element root = XMLTemplateParser.parseTemplateXml(tmplXML);
        String identifier = this.getElementValue(ITemplateAttributeIdentifiers.IDENTIFIER, root);
        result = new WorkItemTemplate(identifier, this.fProjectArea);
        result.setName((String)this.fAttributeFacade.getInternalValue(IInternalAttributeIdentifiers.WORKITEM_NAME, this.getElementValue(ITemplateAttributeIdentifiers.NAME, root)));
        result.setDescription((String)this.fAttributeFacade.getInternalValue(IInternalAttributeIdentifiers.WORKITEM_DESCRIPTION, this.getElementValue(ITemplateAttributeIdentifiers.DESCRIPTION, root)));
        result.setOwner((IContributorHandle)this.fAttributeFacade.getInternalValue(IInternalAttributeIdentifiers.WORKITEM_OWNER, this.getResourceValue(ITemplateAttributeIdentifiers.OWNER, root)));
        NodeList workItemNodes = root.getElementsByTagName(this.fAttributeFacade.qualify(ITemplateTypeIdentifiers.WORKITEM_DESCRIPTIONS));
        if (workItemNodes != null && workItemNodes.getLength() > 0) {
            NodeList childNodes = workItemNodes.item(0).getChildNodes();
            int idx = 0;
            int len = childNodes.getLength();
            while (idx < len) {
                Node curItem = childNodes.item(idx);
                if (curItem != null && curItem instanceof Element) {
                    result.addVariables(this.getTemplateVariableValues(curItem));
                }
                ++idx;
            }
        }
        result.setContent(tmplXML);
        return result;
    }

    public List<IWorkItemDescriptor> parseWorkItemDescriptors(String tmplXML) throws TeamRepositoryException {
        if (tmplXML != null) {
            ArrayList<IWorkItemDescriptor> result = new ArrayList<IWorkItemDescriptor>();
            Element root = XMLTemplateParser.parseTemplateXml(tmplXML);
            NodeList itemsNode = root.getElementsByTagName(this.fAttributeFacade.qualify(ITemplateTypeIdentifiers.WORKITEM_DESCRIPTIONS));
            if (itemsNode != null && itemsNode.getLength() > 0) {
                NodeList childNodes = itemsNode.item(0).getChildNodes();
                int idx = 0;
                int len = childNodes.getLength();
                while (idx < len) {
                    Node cur = childNodes.item(idx);
                    if (cur != null && cur instanceof Element) {
                        result.add(this.parseWorkItemDescriptor(cur));
                    }
                    ++idx;
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    private IAttributeVariable[] getTemplateVariableValues(Node workItemNode) {
        ArrayList<AttributeVariable> result = new ArrayList<AttributeVariable>();
        NodeList itemAttributes = workItemNode.getChildNodes();
        int idx = 0;
        int len = itemAttributes.getLength();
        while (idx < len) {
            String rdfRes;
            Node curAttrNode = itemAttributes.item(idx);
            if (curAttrNode != null && "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/".equals(curAttrNode.getNamespaceURI()) && (rdfRes = this.getAttributeValue(RDFIdentifiers.RESOURCE, curAttrNode)) != null && rdfRes.indexOf("${") > -1) {
                result.add(new AttributeVariable(rdfRes));
            }
            ++idx;
        }
        return result.toArray(new IAttributeVariable[result.size()]);
    }

    public static Element parseTemplateXml(String xml) throws IllegalFormatException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(null);
            byte[] bytes = xml.getBytes(HttpUtil.CharsetEncoding.UTF8.toCharset().name());
            Document document = documentBuilder.parse(new ByteArrayInputStream(bytes));
            return document.getDocumentElement();
        }
        catch (Exception exception) {
            throw new IllegalFormatException(ILLEGAL_FORMAT_ERROR);
        }
    }

    private IWorkItemDescriptor parseWorkItemDescriptor(Node workItemNode) throws IllegalFormatException, TeamRepositoryException {
        if (workItemNode == null || workItemNode.getChildNodes() == null || workItemNode.getChildNodes().getLength() == 0) {
            throw new IllegalFormatException(ILLEGAL_FORMAT_ERROR);
        }
        WorkItemDescriptor result = new WorkItemDescriptor();
        result.addAttribute(this.fAttributeFacade.getInternalIdentifier(ITemplateAttributeIdentifiers.WORKITEM_TYPE), workItemNode.getLocalName());
        result.addAttribute(this.fAttributeFacade.getInternalIdentifier(ITemplateAttributeIdentifiers.WORKITEM_IDENTIFIER), this.getAttributeValue(RDFIdentifiers.ID, workItemNode));
        NodeList attrNodes = workItemNode.getChildNodes();
        int attrIdx = 0;
        int attrCount = attrNodes.getLength();
        while (attrIdx < attrCount) {
            Identifier<IPublicAttribute> curPubId;
            Identifier<? extends IItem> curIntId;
            Node curNode = attrNodes.item(attrIdx);
            if (curNode instanceof Element && (curIntId = this.getInternalIdentifier(curNode, curPubId = IdentifierMapping.createPublicAttributeIdentifier(ITemplateTypeIdentifiers.CHANGE_REQUEST, curNode.getLocalName()))) != null) {
                if (IAttribute.class.isAssignableFrom(curIntId.getType())) {
                    if (ITemplateAttributeIdentifiers.WORKITEM_APPROVALS.equals(curPubId)) {
                        this.parseApprovals(result, curNode);
                    } else if (ITemplateAttributeIdentifiers.WORKITEM_COMMENTS.equals(curPubId)) {
                        this.parseComments(result, curNode);
                    } else {
                        this.parseAttribute(result, curNode, curPubId, curIntId);
                    }
                } else if (ILink.class.isAssignableFrom(curIntId.getType())) {
                    this.parseLink(result, curNode, curIntId);
                }
            }
            ++attrIdx;
        }
        return result;
    }

    private void parseApprovals(WorkItemDescriptor result, Node node) throws IllegalFormatException {
        NodeList descriptors = node.getChildNodes();
        int descIdx = 0;
        int descCount = descriptors.getLength();
        while (descIdx < descCount) {
            Node curDesc = descriptors.item(descIdx);
            String descName = null;
            String descType = null;
            String descDueDate = null;
            List<IWorkItemDescriptor.IApproval> descApprovals = null;
            if (curDesc != null && curDesc instanceof Element && curDesc.hasChildNodes()) {
                descType = curDesc.getLocalName();
                NodeList attrNodes = curDesc.getChildNodes();
                int attrIdx = 0;
                int attrCount = attrNodes.getLength();
                while (attrIdx < attrCount) {
                    Node curAttr = attrNodes.item(attrIdx);
                    if (curAttr != null && curAttr instanceof Element) {
                        if (ITemplateAttributeIdentifiers.NAME.getStringIdentifier().equals(curAttr.getLocalName())) {
                            descName = this.getElementValue(curAttr);
                        } else if (ITemplateAttributeIdentifiers.WORKITEM_DUE_DATE.getStringIdentifier().equals(curAttr.getLocalName())) {
                            descDueDate = this.getElementValue(curAttr);
                        } else if (ITemplateAttributeIdentifiers.WORKITEM_APPROVAL_TASKS.getStringIdentifier().equals(curAttr.getLocalName())) {
                            descApprovals = this.parseApprovalTasks(curAttr);
                        }
                    }
                    ++attrIdx;
                }
                if (this.isValidString(descName) && this.isValidString(descType)) {
                    WorkItemDescriptor.ApprovalDescriptor appDesc = new WorkItemDescriptor.ApprovalDescriptor(descName, descType);
                    if (descApprovals != null && !descApprovals.isEmpty()) {
                        appDesc.setApprovals(descApprovals);
                    }
                    appDesc.setDueDate(descDueDate);
                    result.addApprovalDescriptor(appDesc);
                } else {
                    String message = NLS.bind((String)Messages.getString("XMLTemplateParser.ERROR_PARSING_ATTRIBUTE_VALUE"), (Object)ITemplateAttributeIdentifiers.WORKITEM_APPROVALS.getStringIdentifier(), (Object[])new Object[0]);
                    throw new IllegalFormatException(message);
                }
            }
            ++descIdx;
        }
    }

    private List<IWorkItemDescriptor.IApproval> parseApprovalTasks(Node node) throws IllegalFormatException {
        ArrayList<IWorkItemDescriptor.IApproval> result = new ArrayList<IWorkItemDescriptor.IApproval>();
        NodeList appNodes = node.getChildNodes();
        int appIdx = 0;
        int appCount = appNodes.getLength();
        while (appIdx < appCount) {
            Node curApp = appNodes.item(appIdx);
            if (curApp != null && curApp instanceof Element) {
                String approver = this.getAttributeValue(RDFIdentifiers.RESOURCE, curApp);
                String state = this.getElementValue(curApp);
                if (this.isValidString(approver) && this.isValidString(state)) {
                    result.add(new WorkItemDescriptor.Approval(approver, state));
                } else {
                    String message = NLS.bind((String)Messages.getString("XMLTemplateParser.ERROR_PARSING_ATTRIBUTE_VALUE"), (Object)ITemplateAttributeIdentifiers.WORKITEM_APPROVAL_TASKS.getStringIdentifier(), (Object[])new Object[0]);
                    throw new IllegalFormatException(message);
                }
            }
            ++appIdx;
        }
        return result;
    }

    private void parseComments(WorkItemDescriptor result, Node node) {
        NodeList children = node.getChildNodes();
        int childIdx = 0;
        int len = children.getLength();
        while (childIdx < len) {
            Node curChild = children.item(childIdx);
            if (curChild != null && curChild instanceof Element) {
                String creator = this.getAttributeValue(RDFIdentifiers.RESOURCE, curChild);
                String content = this.getElementValue(curChild);
                if (this.isValidString(creator) && this.isValidString(content)) {
                    result.addComment(new WorkItemDescriptor.Comment(creator, content));
                }
            }
            ++childIdx;
        }
    }

    private void parseAttribute(WorkItemDescriptor result, Node node, Identifier<IPublicAttribute> publicIdentifier, Identifier<? extends IItem> internalIdentifier) throws IllegalFormatException {
        boolean isParentNode = this.isParentNode(node);
        String value = this.getAttributeValue(RDFIdentifiers.RESOURCE, node);
        if (value == null && !isParentNode) {
            value = this.getElementValue(node);
        }
        if (value != null) {
            Object attributeValue = null;
            Identifier<? extends IItem> attrIdentifier = internalIdentifier;
            attributeValue = value.indexOf("${") > -1 ? new AttributeVariable(value) : this.fAttributeFacade.getInternalValue(attrIdentifier, value);
            if (attributeValue != null) {
                if (this.fAttributeFacade.isMultiValueAttribute(attrIdentifier)) {
                    ArrayList<Object> multiValue = (ArrayList<Object>)result.getValue(attrIdentifier);
                    if (multiValue == null) {
                        multiValue = new ArrayList<Object>();
                    }
                    multiValue.add(attributeValue);
                    result.addAttribute(attrIdentifier, multiValue);
                } else {
                    result.addAttribute(attrIdentifier, attributeValue);
                }
            } else {
                throw new IllegalFormatException(NLS.bind((String)Messages.getString("XMLTemplateParser.ERROR_CANNOT_ASSIGN_ATTRIBUTE_VALUE"), (Object)value, (Object[])new Object[]{publicIdentifier.getScopedIdentifier()}));
            }
        }
        if (isParentNode) {
            NodeList childNodes = node.getChildNodes();
            int childIdx = 0;
            int childCount = childNodes.getLength();
            while (childIdx < childCount) {
                Node curChild = childNodes.item(childIdx);
                if (curChild != null && curChild instanceof Element) {
                    Identifier<IPublicAttribute> curPubId = IdentifierMapping.createPublicAttributeIdentifier(ITemplateTypeIdentifiers.CHANGE_REQUEST, curChild.getLocalName());
                    Identifier<? extends IItem> curIntId = this.getInternalIdentifier(curChild, curPubId);
                    this.parseAttribute(result, curChild, curPubId, curIntId);
                }
                ++childIdx;
            }
        }
    }

    private boolean isParentNode(Node node) {
        NodeList children;
        int lenth;
        int count = 0;
        if (node != null && (lenth = (children = node.getChildNodes()).getLength()) > 0) {
            int idx = 0;
            while (idx < lenth) {
                Node cur = children.item(idx);
                if (cur != null && cur instanceof Element) {
                    ++count;
                }
                ++idx;
            }
        }
        return count > 0;
    }

    private void parseLink(WorkItemDescriptor result, Node node, Identifier<? extends IItem> internalIdentifier) {
        String referenceUrl = this.getAttributeValue(RDFIdentifiers.RESOURCE, node);
        String referenceName = this.getAttributeValue(OSLCIdentifiers.LABEL, node);
        if (referenceUrl != null && !referenceUrl.equals("#null")) {
            if (referenceUrl.startsWith("#")) {
                referenceUrl = referenceUrl.substring(1);
            }
            result.addLink(internalIdentifier, referenceName, referenceUrl);
        } else if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            int childIdx = 0;
            while (childIdx < children.getLength()) {
                Node aChild = children.item(childIdx);
                referenceUrl = this.getAttributeValue(RDFIdentifiers.RESOURCE, aChild);
                referenceName = this.getAttributeValue(OSLCIdentifiers.LABEL, aChild);
                if (referenceUrl != null && !referenceUrl.equals("#null")) {
                    if (referenceUrl.startsWith("#")) {
                        referenceUrl = referenceUrl.substring(1);
                    }
                    result.addLink(internalIdentifier, referenceName, referenceUrl);
                }
                ++childIdx;
            }
        }
    }

    private Identifier<? extends IItem> getInternalIdentifier(Node curNode, Identifier<IPublicAttribute> curPubId) {
        Identifier<Object> curIntId = this.fAttributeFacade.getInternalIdentifier(curPubId);
        if (curIntId == null && "http://jazz.net/xmlns/prod/jazz/rtc/ext/1.0/".equals(curNode.getNamespaceURI())) {
            curIntId = IdentifierMapping.createWorkItemAttributeIdentifier(curNode.getLocalName());
        }
        return curIntId;
    }

    private String getAttributeValue(Property property, Node node) {
        if (node.hasAttributes()) {
            NamedNodeMap attributes = node.getAttributes();
            int idx = 0;
            int len = attributes.getLength();
            while (idx < len) {
                Node attrNode = attributes.item(idx);
                if (property.getNamespaceURI().equals(attrNode.getNamespaceURI()) && property.getName().equals(attrNode.getLocalName())) {
                    return attrNode.getNodeValue();
                }
                ++idx;
            }
        }
        return null;
    }

    private String getResourceValue(Identifier<? extends IPublicItem> identifier, Element root) {
        NodeList nodes = root.getElementsByTagNameNS(this.fAttributeFacade.getNamespace(identifier), identifier.getStringIdentifier());
        if (nodes != null && nodes.getLength() > 0) {
            Element resourceNode = (Element)nodes.item(0);
            return resourceNode.getAttributeNS(RDFIdentifiers.RESOURCE.getNamespaceURI(), RDFIdentifiers.RESOURCE.getName());
        }
        return null;
    }

    private String getElementValue(Identifier<? extends IPublicItem> identifier, Element root) {
        NodeList nodes = root.getElementsByTagNameNS(this.fAttributeFacade.getNamespace(identifier), identifier.getStringIdentifier());
        if (nodes != null && nodes.getLength() > 0) {
            Node node = nodes.item(0);
            return this.getElementValue(node);
        }
        return null;
    }

    private String getElementValue(Node node) {
        Node valueNode;
        if (node.hasChildNodes() && (valueNode = node.getChildNodes().item(0)) != null) {
            return valueNode.getNodeValue();
        }
        return null;
    }

    private boolean isValidString(String str) {
        return str != null && str.length() > 0;
    }
}

