/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.model.Category;
import com.ibm.team.workitem.common.internal.model.DefaultModel;
import com.ibm.team.workitem.common.internal.util.CategoriesManager;
import com.ibm.team.workitem.common.internal.util.CategoryTreeNode;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.internal.util.PermissionContext;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class CategoriesHelper {
    public static final String DELIMITER = "/";
    private static final int NAME_SPACE_SEGMENTS = 1;

    public static ICategory createRootCategory(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        LocalizationContext context = LocalizationContext.createProjectAreaContext(auditableCommon, projectArea, monitor);
        CategoryId categoryId = CategoryId.createCategoryId(DELIMITER + DefaultModel.getNullCategoryName(context) + DELIMITER);
        return CategoriesHelper.createCategory(auditableCommon, projectArea, categoryId);
    }

    public static ICategory createCategory(IAuditableCommon auditableCommon, ICategory parent, String name) {
        Assert.isTrue((boolean)parent.isComplete());
        CategoryId categoryId = CategoriesHelper.createCategoryId(parent.getCategoryId(), name);
        Category category = CategoriesHelper.createCategory(auditableCommon, parent.getProjectArea(), categoryId);
        category.setArchived(parent.isArchived());
        category.setFiltered(((Category)parent).isFiltered());
        category.setReadAccessEnabled(((Category)parent).isReadAccessEnabled());
        category.setDefaultTeamArea(((Category)parent).getDefaultTeamArea());
        category.getTeamAreas().addAll(((Category)parent).getTeamAreas());
        PermissionContext.setDefault((IItem)category);
        return category;
    }

    private static Category createCategory(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, CategoryId categoryId) {
        Category category = (Category)auditableCommon.createAuditable(ICategory.ITEM_TYPE);
        category.setProjectArea(projectArea);
        category.setCategoryId(categoryId);
        category.setName(CategoriesHelper.getName(categoryId));
        PermissionContext.setDefault((IItem)category);
        return category;
    }

    private static String getName(CategoryId categoryId) {
        String[] segments = categoryId.getInternalRepresentation().split(DELIMITER);
        if (segments.length == 0) {
            return "";
        }
        return segments[segments.length - 1];
    }

    public static List<ICategoryHandle> findExistingCategories(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return WorkItemQueries.categoryByProjectArea(auditableCommon, projectArea).toList(monitor);
    }

    public static int getDepth(CategoryId categoryId) {
        int i = 0;
        String id = categoryId.getInternalRepresentation();
        int j = id.indexOf(DELIMITER);
        while (j != -1) {
            j = id.indexOf(DELIMITER, j + 1);
            ++i;
        }
        return Math.max(0, i - 2 - 1);
    }

    public static String getHierarchicalName(CategoryId categoryId) {
        StringBuilder name = new StringBuilder();
        String[] segments = CategoriesHelper.getNamePath(categoryId);
        int i = 0;
        while (i < segments.length) {
            String segment = segments[i];
            name.append(segment);
            if (i + 1 < segments.length) {
                name.append(DELIMITER);
            }
            ++i;
        }
        return name.toString();
    }

    public static CategoryId getParentId(CategoryId categoryId) {
        ArrayList<String> segments = new ArrayList<String>(Arrays.asList(categoryId.getInternalRepresentation().split(DELIMITER)));
        if (segments.size() > 0 && "".equals(segments.get(0))) {
            segments.remove(0);
        }
        if (segments.size() <= 1) {
            return null;
        }
        segments.remove(segments.size() - 1);
        StringBuilder parentId = new StringBuilder(DELIMITER);
        for (String segment : segments) {
            parentId.append(segment);
            parentId.append(DELIMITER);
        }
        return CategoryId.createCategoryId(parentId.toString());
    }

    public static String[] getNamePath(CategoryId categoryId) {
        List<String> segments = new ArrayList<String>(Arrays.asList(categoryId.getInternalRepresentation().split(DELIMITER)));
        int strip = 1;
        if (segments.size() > 0 && "".equals(segments.get(0))) {
            ++strip;
        }
        segments = segments.subList(Math.min(strip, segments.size()), segments.size());
        return segments.toArray(new String[segments.size()]);
    }

    public static void updateCategoryId(Category category, CategoryId from, String to) {
        Assert.isTrue((boolean)category.getCategoryId().getInternalRepresentation().startsWith(from.getInternalRepresentation()));
        int i = from.getInternalRepresentation().split(DELIMITER).length - 1;
        String[] segments = category.getCategoryId().getInternalRepresentation().split(DELIMITER);
        segments[i] = to;
        StringBuilder id = new StringBuilder(DELIMITER);
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment.length() != 0) {
                id.append(segment);
                id.append(DELIMITER);
            }
            ++n2;
        }
        category.setCategoryId(CategoryId.createCategoryId(id.toString()));
    }

    public static void updateCategoryId(Category category, CategoryId from, CategoryId to) {
        Assert.isTrue((boolean)category.getCategoryId().getInternalRepresentation().startsWith(from.getInternalRepresentation()));
        StringBuilder id = new StringBuilder(to.getInternalRepresentation());
        id.append(category.getCategoryId().getInternalRepresentation().substring(from.getInternalRepresentation().length()));
        category.setCategoryId(CategoryId.createCategoryId(id.toString()));
    }

    public static CategoryId createCategoryId(ICategory rootCategory, String ... namePath) {
        Assert.isTrue((boolean)rootCategory.isUnassigned());
        StringBuilder id = new StringBuilder(rootCategory.getCategoryId().getInternalRepresentation());
        String[] stringArray = namePath;
        int n = namePath.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Assert.isTrue((!name.contains(DELIMITER) ? 1 : 0) != 0);
            id.append(name);
            id.append(DELIMITER);
            ++n2;
        }
        return CategoryId.createCategoryId(id.toString());
    }

    public static CategoryId createCategoryId(CategoryId parentId, String name) {
        Assert.isTrue((!name.contains(DELIMITER) ? 1 : 0) != 0);
        String newid = String.valueOf(parentId.getInternalRepresentation()) + name + DELIMITER;
        return CategoryId.createCategoryId(newid);
    }

    public static List<ICategory> findVisibleCategories(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IContributorHandle contributor, ItemProfile<ICategory> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        return CategoriesHelper.findVisibleCategories(auditableCommon, projectArea, contributor, false, profile, monitor);
    }

    public static boolean isVisible(IAuditableCommon auditableCommon, ICategory category, IContributorHandle contributorHandle, Map<IProcessAreaHandle, IProcessArea> processAreaMap, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!category.isFiltered()) {
            return true;
        }
        List<ITeamAreaHandle> associatedTeamAreas = category.getAssociatedTeamAreas();
        if (!associatedTeamAreas.isEmpty()) {
            for (ITeamAreaHandle associatedTeamAreaHandle : associatedTeamAreas) {
                IProcessArea teamArea = processAreaMap.get(associatedTeamAreaHandle);
                if (teamArea == null) {
                    teamArea = auditableCommon.resolveAuditable((IAuditableHandle)associatedTeamAreaHandle, ItemProfile.PROCESS_AREA_DEFAULT, monitor);
                    processAreaMap.put((IProcessAreaHandle)associatedTeamAreaHandle, teamArea);
                }
                if (!teamArea.hasMember(contributorHandle)) continue;
                return true;
            }
        } else {
            IProjectAreaHandle categoryProjectAreaHandle = category.getProjectArea();
            IProcessArea categoryProjectArea = processAreaMap.get(categoryProjectAreaHandle);
            if (categoryProjectArea == null) {
                categoryProjectArea = auditableCommon.resolveAuditable((IAuditableHandle)categoryProjectAreaHandle, ItemProfile.PROCESS_AREA_DEFAULT, monitor);
                processAreaMap.put((IProcessAreaHandle)categoryProjectAreaHandle, categoryProjectArea);
            }
            if (categoryProjectArea.hasMember(contributorHandle)) {
                return true;
            }
        }
        return false;
    }

    public static List<ICategory> findVisibleCategories(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IContributorHandle contributor, boolean includeArchived, ItemProfile<ICategory> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        if (contributor == null) {
            IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
            return workItemCommon.findCategories(projectArea, profile, null);
        }
        CategoriesManager manager = CategoriesManager.createInstance(auditableCommon, false, projectArea, monitor);
        ArrayList<ICategoryHandle> categories = new ArrayList<ICategoryHandle>();
        CategoriesHelper.collect(categories, manager.getRoot(), contributor, includeArchived);
        return auditableCommon.resolveAuditablesPermissionAware(categories, profile, monitor);
    }

    private static void collect(List<ICategoryHandle> categories, CategoryTreeNode node, IContributorHandle contributor, boolean includeArchived) {
        boolean filtered;
        if (node.isArchived() && !includeArchived) {
            return;
        }
        boolean hasVisibleSubtree = false;
        for (CategoryTreeNode child : node.getChildren()) {
            int size = categories.size();
            CategoriesHelper.collect(categories, child, contributor, includeArchived);
            hasVisibleSubtree |= categories.size() > size;
        }
        boolean bl = filtered = node.isFiltered() && !CategoriesHelper.isInCurrentTeams(node, contributor) && !hasVisibleSubtree;
        if (node.getParent() != null && !node.getItem().isNewItem() && !filtered) {
            categories.add(node.getCategory());
        }
    }

    private static boolean isInCurrentTeams(CategoryTreeNode node, IContributorHandle contributor) {
        List<ITeamAreaHandle> handles = node.getTeamAreas();
        for (ITeamAreaHandle handle : handles) {
            ITeamArea teamArea = node.getManager().getTeamArea(handle);
            if (!teamArea.hasMember(contributor)) continue;
            return true;
        }
        return node.getTeamAreas().isEmpty() ? node.getManager().getProjectArea().hasMember(contributor) : false;
    }

    public static boolean isRootCategoryId(CategoryId categoryId) {
        String string = categoryId.getInternalRepresentation();
        return string.startsWith(DELIMITER) && string.indexOf(DELIMITER, DELIMITER.length()) == string.length() - DELIMITER.length();
    }

    public static boolean isValidCategoryId(CategoryId categoryId) {
        String string = categoryId.getInternalRepresentation();
        return string.startsWith(DELIMITER) && string.indexOf(DELIMITER, DELIMITER.length()) != -1;
    }
}

