/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.QueryIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class DataQueryIterator<T>
extends QueryIterator<T> {
    private static final int PAGE_SIZE = 512;
    private final IAuditableCommon fAuditableCommon;
    private final IDataQuery fQuery;
    private final Object[] fParameters;
    private final UUID[] fContextIds;
    private final QueryIterator.ReadMode fReadMode;
    private IDataQueryPage fPage;
    private Iterator<T> fIterator;

    public DataQueryIterator(IAuditableCommon auditableCommon, IDataQuery query, Object[] parameters, UUID[] contextIds, QueryIterator.ReadMode mode) {
        this.fAuditableCommon = auditableCommon;
        this.fQuery = query;
        this.fParameters = parameters != null ? parameters : IQueryService.EMPTY_PARAMETERS;
        this.fContextIds = contextIds;
        this.fReadMode = mode != null ? mode : QueryIterator.ReadMode.COMMITTED;
    }

    @Override
    public boolean hasNext(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return this.fIterator.hasNext();
    }

    @Override
    public T next(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return this.fIterator.next();
    }

    private void update(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fPage == null) {
            this.fPage = this.fReadMode == QueryIterator.ReadMode.COMMITTED ? this.fAuditableCommon.queryDataInContext(this.fQuery, this.fParameters, 512, this.fContextIds, monitor) : this.fAuditableCommon.uncommittedQueryData(this.fQuery, this.fParameters, 512, monitor);
            this.fIterator = this.toList(this.fPage).iterator();
        }
        while (!this.fIterator.hasNext() && this.fPage.hasNext()) {
            this.fPage = (IDataQueryPage)this.fAuditableCommon.fetchPage(this.fPage.getToken(), this.fPage.getNextStartPosition(), 512, monitor);
            this.fIterator = this.toList(this.fPage).iterator();
        }
    }

    private List<T> toList(IDataQueryPage page) {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < page.getSize()) {
            list.add(page.getRow(i).getObject(0));
            ++i;
        }
        return list;
    }
}

