/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.Assert;

public class SeparatedStringIterator
implements Iterator<String> {
    private final String fValue;
    private final char fSeparator;
    private final char fEscapeChar;
    private String fNext;
    private int fPos;

    public SeparatedStringIterator(String value, char separator, char escapeChar) {
        Assert.isNotNull((Object)value);
        this.fValue = value;
        this.fSeparator = separator;
        this.fEscapeChar = escapeChar;
        this.fNext = this.computeNext();
    }

    @Override
    public boolean hasNext() {
        return this.fNext != null;
    }

    private String computeNext() {
        if (this.fPos > this.fValue.length()) {
            return null;
        }
        if (this.fPos == this.fValue.length()) {
            ++this.fPos;
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int pos = this.fPos;
        while (pos < this.fValue.length()) {
            char c = this.fValue.charAt(pos);
            if (c == this.fEscapeChar) {
                Assert.isTrue((pos + 1 < this.fValue.length() ? 1 : 0) != 0);
                builder.append(this.fValue.charAt(pos + 1));
                pos += 2;
                continue;
            }
            if (c == this.fSeparator) {
                ++pos;
                break;
            }
            builder.append(c);
            ++pos;
        }
        this.fPos = pos;
        return builder.toString();
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String next = this.fNext;
        this.fNext = this.computeNext();
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

