/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashMap;
import java.util.HashSet;
import java.util.Set;

public class TimeoutCacheHelper<K, V> {
    private static final long TIMEOUT = 600000L;
    private ItemHandleAwareHashMap<K, V> fOldCache = new ItemHandleAwareHashMap();
    private ItemHandleAwareHashMap<K, V> fCache = new ItemHandleAwareHashMap();
    private long fTimeout = -1L;

    public synchronized void put(K key, V value) {
        this.invalidateCache();
        this.fCache.put(key, value);
        this.fOldCache.remove(key);
    }

    public synchronized V get(K key) {
        this.invalidateCache();
        if (this.fCache.containsKey(key)) {
            return this.fCache.get(key);
        }
        return this.fOldCache.get(key);
    }

    public synchronized Set<K> getKeySet() {
        HashSet<K> combinedSet = new HashSet<K>();
        combinedSet.addAll(this.fCache.keySet());
        combinedSet.addAll(this.fOldCache.keySet());
        return combinedSet;
    }

    private void invalidateCache() {
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.fTimeout) {
            ItemHandleAwareHashMap<K, V> tmp = this.fOldCache;
            tmp.clear();
            this.fOldCache = this.fCache;
            this.fCache = tmp;
            this.fTimeout = currentTime + 600000L;
        }
    }
}

