/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.workitem.common.internal.util.Messages;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ValidationUtils {
    private static final String INVALID_ID_CHARS = "~!@#$%^&*()+|}{:\"?><,/';[]\\=` ";
    private static final Pattern INVALID_ID_BEGINNING_CHARS = Pattern.compile("^[\\d\\-\\.]");

    public static boolean isValidPhraseSearch(String search) {
        int quoteIndex;
        if (search == null || search.length() == 0) {
            return true;
        }
        search = search.trim();
        int quoteCount = 0;
        int i = 0;
        while (i < search.length()) {
            if (search.charAt(i) == '\"') {
                ++quoteCount;
            }
            ++i;
        }
        if (quoteCount < 2) {
            return true;
        }
        boolean startsWithQuote = search.startsWith("\"");
        boolean endsWithQuote = search.endsWith("\"");
        boolean containsQuote = search.contains("\"");
        if (startsWithQuote && !endsWithQuote) {
            return false;
        }
        if (!startsWithQuote && endsWithQuote) {
            return false;
        }
        if (!startsWithQuote && !endsWithQuote && containsQuote) {
            return false;
        }
        return !startsWithQuote || !endsWithQuote || (quoteIndex = search.indexOf("\"", 1)) + 1 == search.length();
    }

    public static IStatus validatePhraseSearch(String search) {
        if (!ValidationUtils.isValidPhraseSearch(search)) {
            return new Status(2, "com.ibm.team.workitem.common", Messages.getString("ValidationUtils.INVALID_PHRASE_SEARCH"));
        }
        return Status.OK_STATUS;
    }

    public static boolean isValidIdentifier(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return false;
        }
        if (INVALID_ID_BEGINNING_CHARS.matcher(identifier).find()) {
            return false;
        }
        int i = 0;
        while (i < identifier.length()) {
            if (INVALID_ID_CHARS.indexOf(identifier.charAt(i)) != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

