/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.valuesetproviders;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.UriUtil;
import com.ibm.team.workitem.api.common.WorkItem;
import com.ibm.team.workitem.api.common.connectors.ConnectorException;
import com.ibm.team.workitem.api.common.connectors.HttpConnectorParameters;
import com.ibm.team.workitem.api.common.connectors.IHttpConnector;
import com.ibm.team.workitem.api.common.connectors.ILog;
import com.ibm.team.workitem.api.common.connectors.IResponse;
import com.ibm.team.workitem.api.common.connectors.IResponseEntry;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IFilteredValueSetProvider;
import com.ibm.team.workitem.common.internal.scripting.WorkItemAPIType;
import com.ibm.team.workitem.common.internal.valuesetproviders.Messages;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class HttpFilteredValueSetProvider
implements IFilteredValueSetProvider<Object> {
    private static final String HTTP_CONNECTOR = "HttpConnector";
    public static final String HTTPPARAMS = "httpparams";
    public static final String URL_PARAM = "url";
    public static final String XPATH_PARAM = "xpath";
    public static final String COLUMNXPATHS_PARAM = "columnxpath";
    public static final String COLUMNIDS_PARAM = "columnid";
    public static final String FORMBASEDURL_PARAM = "formbasedurl";
    public static final String FORMBASEDUSER_PARAM = "formbaseduser";
    public static final String FORMBASEDPASS_PARAM = "formbasedpass";
    public static final String CREDENTIALSID_PARAM = "credentialid";
    public static final String USEBASIC_PARAM = "usebasic";
    public static final String USEFORM_PARAM = "useform";
    public static final String USEOAUTH_PARAM = "useoauth";
    public static final String USERNAME_PARAM = "username";
    public static final String PASSWORD_PARAM = "password";
    public static final String IGNORECERTIFICATES_PARAM = "ignorecertificates";
    public static final String SEPARATOR = "|";
    public static final String FORMAT_PARAM = "format";
    public static final String FILTER_PARAM = "filterByLabel";
    public static final String SORT_PARAM = "sortByLabel";
    public static final String FILTER_PROPERTY = "filter";
    private static final Pattern NAMED_PARAMETER_PATTERN = Pattern.compile("\\$\\{([^\\}]*)\\}");
    private static final Pattern ENUMERATED_PARAMETER_PATTERN = Pattern.compile("\\$\\{([0-9]*)\\}");
    private static final String LABEL_PROPERTY = "label";
    private static final String VALUE_PROPERTY = "value";
    private static final int MAX_RESULTS = 150;

    @Override
    public List<Object> getValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getFilteredValueSet(attribute, workItem, workItemCommon, configuration, "", monitor);
    }

    @Override
    public List<Object> getFilteredValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, String filter, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getFilteredValueSet(attribute, workItem, workItemCommon, configuration, filter, monitor, null);
    }

    public List<Object> getFilteredValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, String filter, IProgressMonitor monitor, ILog log) throws TeamRepositoryException {
        IHttpConnector connector = (IHttpConnector)workItemCommon.getDataConnector(HTTP_CONNECTOR);
        return this.getFilteredValueSet(attribute, workItem, workItemCommon, configuration, filter, connector, monitor, log);
    }

    public List<Object> getFilteredValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, String filter, IHttpConnector connector, IProgressMonitor monitor, ILog log) throws TeamRepositoryException {
        String format;
        IResponse values;
        IConfiguration conf = configuration.getChild(HTTPPARAMS);
        HttpConnectorParameters params = HttpFilteredValueSetProvider.readParameters(conf, workItem, filter, workItemCommon);
        params.log = log;
        try {
            this.log(log, Messages.getString("HttpFilteredValueSetProvider_RETRIEVING_VALUES"));
            values = connector.get(params);
        }
        catch (ConnectorException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        boolean filterByLabel = HttpFilteredValueSetProvider.readBoolean(conf, FILTER_PARAM, false);
        boolean sortByLabel = HttpFilteredValueSetProvider.readBoolean(conf, SORT_PARAM, false);
        Pattern regEx = null;
        if (filter != null && filter.length() > 0 && filterByLabel) {
            regEx = Pattern.compile("^" + Pattern.quote(filter), 2);
            this.log(log, NLS.bind((String)Messages.getString("HttpFilteredValueSetProvider_FILTERING"), (Object)filter));
        }
        if ((format = conf.getString(FORMAT_PARAM)) == null) {
            format = "";
        }
        int count = 0;
        LinkedList<Object> result = new LinkedList<Object>();
        while (values.hasNext() && count < 150) {
            IResponseEntry entry = values.next();
            String line = "";
            if (format.length() == 0) {
                int i = 0;
                while (i < entry.size()) {
                    line = String.valueOf(line) + entry.getByPosition(i);
                    ++i;
                }
            } else {
                String[] entries = new String[entry.size()];
                int i = 0;
                while (i < entry.size()) {
                    entries[i] = entry.getByPosition(i);
                    ++i;
                }
                line = HttpFilteredValueSetProvider.substituteEnumeratedAttributes(format, entries);
            }
            if (regEx != null && !regEx.matcher(line).find()) continue;
            result.add(line);
            ++count;
        }
        if (result.size() > 1) {
            this.log(log, NLS.bind((String)Messages.getString("HttpFilteredValueSetProvider_RETRIEVED_N_VALUES"), (Object)result.size()));
        } else {
            this.log(log, Messages.getString("HttpFilteredValueSetProvider_RETRIEVED_1_VALUE"));
        }
        if (sortByLabel) {
            Collections.sort(result, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
        }
        return result;
    }

    private static String substituteEnumeratedAttributes(String str, String[] parameters) {
        Matcher matcher = ENUMERATED_PARAMETER_PATTERN.matcher(str);
        StringBuffer builder = new StringBuffer();
        while (matcher.find()) {
            try {
                int index = Integer.valueOf(matcher.group(1));
                matcher.appendReplacement(builder, parameters[index]);
            }
            catch (NumberFormatException numberFormatException) {
                matcher.appendReplacement(builder, "$0");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.getString("HttpFilteredValueSetProvider_INVALID_PARAMETER"), (Object)matcher.group(1)));
            }
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    private static String substituteNamedAttributes(String str, IWorkItem workItem, String filter, IWorkItemCommon workItemCommon) throws TeamRepositoryException {
        if (str == null) {
            return "";
        }
        Object workItemWrapper = workItem == null ? new WorkItem(){

            public Object getValue(String attributeId) {
                return "";
            }

            public Object getLabel(String attributeId) {
                return "";
            }

            public boolean isAttributeSet(String attributeId) {
                return false;
            }
        } : new WorkItemAPIType(workItem, workItemCommon, null);
        Matcher matcher = NAMED_PARAMETER_PATTERN.matcher(str);
        StringBuffer builder = new StringBuffer();
        while (matcher.find()) {
            String property = matcher.group(1);
            if (property.equals(FILTER_PROPERTY)) {
                matcher.appendReplacement(builder, filter == null ? "" : UriUtil.encode((String)filter));
                continue;
            }
            int delimeter = property.lastIndexOf(46);
            String attributeID = property.substring(0, delimeter);
            String mod = property.substring(delimeter + 1);
            if (mod.equals(LABEL_PROPERTY)) {
                Object label = workItemWrapper.getLabel(attributeID);
                matcher.appendReplacement(builder, label != null ? UriUtil.encode((String)label.toString()) : "");
                continue;
            }
            if (mod.equals(VALUE_PROPERTY)) {
                Object value = workItemWrapper.getValue(attributeID);
                matcher.appendReplacement(builder, value != null ? value.toString() : "");
                continue;
            }
            matcher.appendReplacement(builder, "$0");
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    private static HttpConnectorParameters readParameters(IConfiguration conf, IWorkItem workItem, String filter, IWorkItemCommon workItemCommon) throws TeamRepositoryException {
        HttpConnectorParameters httpParams = new HttpConnectorParameters();
        String url = HttpFilteredValueSetProvider.readString(conf, URL_PARAM, null);
        String xpath = HttpFilteredValueSetProvider.readString(conf, XPATH_PARAM, null);
        httpParams.url = HttpFilteredValueSetProvider.substituteNamedAttributes(url, workItem, filter, workItemCommon);
        httpParams.xpath = HttpFilteredValueSetProvider.substituteNamedAttributes(xpath, workItem, filter, workItemCommon);
        httpParams.columnXpaths = HttpFilteredValueSetProvider.readStringArray(conf, COLUMNXPATHS_PARAM, SEPARATOR);
        httpParams.columnIds = HttpFilteredValueSetProvider.readStringArray(conf, COLUMNIDS_PARAM, SEPARATOR);
        httpParams.formBasedAuthenticationLoginURL = HttpFilteredValueSetProvider.readString(conf, FORMBASEDURL_PARAM, null);
        httpParams.formBasedAuthenticationUsernameInputName = HttpFilteredValueSetProvider.readString(conf, FORMBASEDUSER_PARAM, null);
        httpParams.formBasedAuthenticationPasswordInputName = HttpFilteredValueSetProvider.readString(conf, FORMBASEDPASS_PARAM, null);
        httpParams.credentialsId = HttpFilteredValueSetProvider.readString(conf, CREDENTIALSID_PARAM, null);
        httpParams.useBasicAuthentication = HttpFilteredValueSetProvider.readBoolean(conf, USEBASIC_PARAM, false);
        httpParams.useFormAuthentication = HttpFilteredValueSetProvider.readBoolean(conf, USEFORM_PARAM, false);
        httpParams.useOAuth = HttpFilteredValueSetProvider.readBoolean(conf, USEOAUTH_PARAM, false);
        httpParams.userName = HttpFilteredValueSetProvider.readString(conf, USERNAME_PARAM, null);
        httpParams.password = HttpFilteredValueSetProvider.readString(conf, PASSWORD_PARAM, "");
        httpParams.ignoreInvalidCertificates = HttpFilteredValueSetProvider.readBoolean(conf, IGNORECERTIFICATES_PARAM, false);
        return httpParams;
    }

    private static String readString(IConfiguration conf, String key, String defaultValue) {
        String val = conf.getString(key);
        if (val == null) {
            val = defaultValue;
        } else if (val.length() == 0) {
            return defaultValue;
        }
        return val;
    }

    private static boolean readBoolean(IConfiguration conf, String key, boolean defaultValue) {
        String val = conf.getString(key);
        if (val != null) {
            return val.toLowerCase().equals("true");
        }
        return defaultValue;
    }

    private static String[] readStringArray(IConfiguration conf, String key, String separator) {
        String val = conf.getString(key);
        if (val == null) {
            val = "";
        } else if (val.length() == 0) {
            return null;
        }
        return val.split(Pattern.quote(separator));
    }

    private void log(ILog log, String message) {
        if (log != null) {
            log.log(this.getClass().getSimpleName(), message, null);
        }
    }
}

