/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.wiki.transformer;

import com.ibm.team.workitem.common.internal.wiki.transformer.ILexerInput;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;

public final class LexerInput
implements ILexerInput {
    private static final char[] EMPTY = new char[0];
    private final PushbackReader fReader;
    private int fCharPos;
    private boolean fEOF;

    public LexerInput(String str) {
        this.fReader = new PushbackReader(new StringReader(str), str.length());
    }

    @Override
    public boolean eof() {
        return this.fEOF;
    }

    @Override
    public char[] read(int len) {
        char[] cbuf;
        block7: {
            if (len == 0) {
                return EMPTY;
            }
            if (this.fEOF) {
                return null;
            }
            try {
                cbuf = new char[len];
                int r = this.fReader.read(cbuf);
                if (r != len && r != -1) {
                    this.fReader.unread(cbuf, 0, r);
                }
                if (r == -1) {
                    this.fEOF = true;
                }
                if (r == len) break block7;
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.fCharPos += len;
        return cbuf;
    }

    @Override
    public int read() {
        int read;
        block4: {
            if (this.fEOF) {
                return -1;
            }
            try {
                read = this.fReader.read();
                if (read != -1) break block4;
                this.fEOF = true;
                return -1;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ++this.fCharPos;
        return read;
    }

    @Override
    public void unread(char[] cbuf) {
        if (cbuf.length == 0) {
            return;
        }
        try {
            this.fReader.unread(cbuf);
            this.fCharPos -= cbuf.length;
            this.fEOF = false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unread(int read) {
        if (read == -1) {
            return;
        }
        try {
            this.fReader.unread(read);
            --this.fCharPos;
            this.fEOF = false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getCurrentOffset() {
        return this.fCharPos - 1;
    }
}

