/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.workflow;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.internal.workflow.CombinedWorkflowInfos;
import com.ibm.team.workitem.common.internal.workflow.DefaultWorkflow;
import com.ibm.team.workitem.common.internal.workflow.IWorkflowDescriptor;
import com.ibm.team.workitem.common.internal.workflow.IWorkflowManager;
import com.ibm.team.workitem.common.internal.workflow.Messages;
import com.ibm.team.workitem.common.internal.workflow.StateGroup;
import com.ibm.team.workitem.common.internal.workflow.StateGroupRegistry;
import com.ibm.team.workitem.common.internal.workflow.StateGroups;
import com.ibm.team.workitem.common.internal.workflow.WorkflowException;
import com.ibm.team.workitem.common.internal.workflow.WorkflowInfo;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.workflow.ICombinedWorkflowInfos;
import com.ibm.team.workitem.common.workflow.IStateGroup;
import com.ibm.team.workitem.common.workflow.IStateGroups;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.common.workflow.StateResolutionPair;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class WorkflowManager
extends CacheHelper
implements IWorkflowManager {
    public static final String WORK_FLOW_CONFIGURATION_DATA_POINT = "com.ibm.team.workitem.configuration.workflow";
    public static final String DEFINITION_ELEMENT = "workflowDefinition";
    public static final String DEFINITION_ELEMENT_ID_ATTRIBUTE = "id";
    public static final String WORKFLOW_ELEMENT = "workflow";
    public static final String WORKFLOW_ELEMENT_NAME_ATTRIBUTE = "name";
    public static final String ACTION_ELEMENT = "action";
    public static final String ACTION_ELEMENT_ID_ATTRIBUTE = "id";
    public static final String ACTION_ELEMENT_NAME_ATTRIBUTE = "name";
    public static final String STATE_GROUP_ELEMENT = "stateGroupDefinition";
    public static final String STATE_GROUP_CATEGORY_ATTRIBUTE = "category";
    public static final String STATE_GROUP_ID_ATTRIBUTE = "id";
    public static final String STATE_GROUP_NAME_ATTRIBUTE = "name";
    public static final String STATE_GROUP_ICON_ATTRIBUTE = "icon";
    public static final String STATE_GROUP_OSLC_GROUP = "oslcGroup";
    private static final String STATE_GROUP_OPEN_ICON = "platform:/plugin/com.ibm.team.workitem.common/icons/obj16/state_open.gif";
    private static final String STATE_GROUP_IN_PROGRESS_ICON = "platform:/plugin/com.ibm.team.workitem.common/icons/obj16/state_inprogress.gif";
    private static final String STATE_GROUP_RESOLVED_ICON = "platform:/plugin/com.ibm.team.workitem.common/icons/obj16/state_resolved.gif";
    private static final String WORK_FLOW_BINDINGS_CONFIGURATION_DATA_POINT = "com.ibm.team.workitem.configuration.workflowBinding";
    private static final String BINDING_ELEMENT = "workItemCategoryBinding";
    private static final String WORK_ITEM_CATEGORY_ID_ATTRIBUTE = "workItemCategoryId";
    private static final String WORKFLOW_ID_ATTRIBUTE = "workflowId";
    private static final String EXTENSION_POINT_PLUGIN_ID = "com.ibm.team.workitem.common";
    private static final String WORKFLOW_DESCRIPTION_EXTENSION_POINT_ID = "com.ibm.team.workitem.common.workflowDescription";
    private static final String WORKFLOW_BINDING_EXTENSION_POINT_ID = "com.ibm.team.workitem.common.workflowBinding";
    private static IWorkflowInfo NULL_WORKFLOWINFO = new IWorkflowInfo(){

        @Override
        public String getIdentifier() {
            return "com.ibm.team.workitem.nullworkflow";
        }

        @Override
        public String getName() {
            return "Null Workflow";
        }

        @Override
        public Identifier<IState>[] getAllStateIds() {
            return new Identifier[0];
        }

        @Override
        public Identifier<IState>[] getStateIds(int stateGroups) {
            return new Identifier[0];
        }

        @Override
        public boolean stateGroupContains(int stateGroups, Identifier<IState> stateId) {
            return false;
        }

        @Override
        public int getStateGroup(Identifier<IState> stateId) {
            return 0;
        }

        @Override
        public IStateGroup getStateGroup(Identifier<IState> stateId, Identifier<IResolution> resolutionId) {
            return null;
        }

        @Override
        public String getStateName(Identifier<IState> stateId) {
            return null;
        }

        @Override
        public URL getStateIconName(Identifier<IState> stateId) {
            return null;
        }

        @Override
        public Identifier<IWorkflowAction>[] getActionIds(Identifier<IState> stateId) {
            return new Identifier[0];
        }

        @Override
        public Identifier<IResolution>[] getStateResolutionIds(Identifier<IState> stateId) {
            return new Identifier[0];
        }

        @Override
        public boolean getShowResoution(Identifier<IState> state) {
            return false;
        }

        @Override
        public Identifier<IWorkflowAction> getStartActionId() {
            return null;
        }

        @Override
        public Identifier<IWorkflowAction> getResolveActionId() {
            return null;
        }

        @Override
        public Identifier<IWorkflowAction> getReopenActionId() {
            return null;
        }

        @Override
        public Identifier<IWorkflowAction>[] getAllActionIds() {
            return new Identifier[0];
        }

        @Override
        public String getActionName(Identifier<IWorkflowAction> actionId) {
            return null;
        }

        @Override
        public URL getActionIconName(Identifier<IWorkflowAction> actionId) {
            return null;
        }

        @Override
        public Identifier<IResolution>[] getResolutionIds(Identifier<IWorkflowAction> actionId) {
            return new Identifier[0];
        }

        @Override
        public Identifier<IState> getActionResultState(Identifier<IWorkflowAction> actionId) {
            return null;
        }

        @Override
        public Identifier<IResolution>[] getAllResolutionIds() {
            return new Identifier[0];
        }

        @Override
        public String getResolutionName(Identifier<IResolution> resolutionId) {
            return null;
        }

        @Override
        public URL getResolutionIconName(Identifier<IResolution> resolutionId) {
            return null;
        }
    };
    private final ProjectAreaRegistry fGlobalMapping = new ProjectAreaRegistry(null, this.getAuditableCommon().getRepositoryURI());
    private final Map<UUID, ProjectAreaRegistry> fProjectAreaRegistry = new HashMap<UUID, ProjectAreaRegistry>();

    public WorkflowManager(IAuditableCommon auditableCommon) {
        super(auditableCommon);
        IExtensionRegistry registry = WorkflowManager.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement ce;
            int j;
            IConfigurationElement[] elements;
            int i;
            IExtension[] extensions;
            IExtensionPoint extensionPoint = registry.getExtensionPoint(WORKFLOW_DESCRIPTION_EXTENSION_POINT_ID);
            if (extensionPoint != null) {
                extensions = extensionPoint.getExtensions();
                i = 0;
                while (i < extensions.length) {
                    elements = extensions[i].getConfigurationElements();
                    j = 0;
                    while (j < elements.length) {
                        ce = elements[j];
                        String id = ce.getAttribute("id");
                        if (id != null) {
                            this.fGlobalMapping.fRegistry.put(id, ce);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if ((extensionPoint = registry.getExtensionPoint(WORKFLOW_BINDING_EXTENSION_POINT_ID)) != null) {
                extensions = extensionPoint.getExtensions();
                i = 0;
                while (i < extensions.length) {
                    elements = extensions[i].getConfigurationElements();
                    j = 0;
                    while (j < elements.length) {
                        ce = elements[j];
                        this.fGlobalMapping.fBinding.put(ce.getAttribute(WORK_ITEM_CATEGORY_ID_ATTRIBUTE), ce.getAttribute(WORKFLOW_ID_ATTRIBUTE));
                        ++j;
                    }
                    ++i;
                }
            }
        }
        this.fGlobalMapping.addStateGroup(new StateGroup("open", "open", Messages.getString("WorkflowManager.GROUP_OPEN_NAME"), null, Collections.<IStateGroup.OSLCGroup>emptyList()));
        this.fGlobalMapping.addStateGroup(new StateGroup("inprogress", "inprogress", Messages.getString("WorkflowManager.GROUP_IN_PROGRESS_NAME"), null, Collections.singletonList(IStateGroup.OSLCGroup.INPROGRESS)));
        this.fGlobalMapping.addStateGroup(new StateGroup("closed", "closed", Messages.getString("WorkflowManager.GROUP_RESOLVED_NAME"), null, Collections.singletonList(IStateGroup.OSLCGroup.CLOSED)));
    }

    public void registerWorkflow(String workflowId, IWorkflowDescriptor descriptor) {
        if (workflowId != null) {
            descriptor.setId(workflowId);
            this.fGlobalMapping.fRegistry.put(workflowId, descriptor);
        }
    }

    public String getWorkflowId(IWorkItem wi, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getWorkflowId(wi, false, monitor);
    }

    private String getWorkflowId(IWorkItem workItem, boolean shortOp, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon peer;
        if (shortOp) {
            Assert.isTrue((boolean)workItem.isPropertySet(IWorkItem.TYPE_PROPERTY));
            Assert.isTrue((boolean)workItem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY));
        } else if (!(workItem.isPropertySet(IWorkItem.TYPE_PROPERTY) && workItem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY) || workItem.isNewItem())) {
            workItem = this.getAuditableCommon().resolveAuditable(workItem, IWorkItem.SMALL_PROFILE, monitor);
        }
        String workItemType = workItem.getWorkItemType();
        if (workItemType != null && (peer = this.getAuditableCommon().getPeer(IWorkItemCommon.class)) != null) {
            IWorkItemType wt = null;
            wt = shortOp ? peer.findCachedWorkItemType(workItem.getProjectArea(), workItemType) : peer.findWorkItemType(workItem.getProjectArea(), workItemType, monitor);
            if (wt != null) {
                String category = wt.getCategory();
                return this.getWorkflowIdForCategory(workItem.getProjectArea(), category, shortOp, monitor);
            }
        }
        return null;
    }

    public String getWorkItemTypeCategory(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemType wt;
        IWorkItemCommon peer;
        String workItemType = workItem.getWorkItemType();
        if (workItemType != null && workItemType.length() > 0 && (peer = this.getAuditableCommon().getPeer(IWorkItemCommon.class)) != null && (wt = peer.findWorkItemType(workItem.getProjectArea(), workItemType, monitor)) != null) {
            return wt.getCategory();
        }
        return null;
    }

    public String getWorkflowIdForCategory(IProjectAreaHandle projectArea, String category, boolean shortOp, IProgressMonitor monitor) {
        if (projectArea != null) {
            return this.getProjectAreaRegistry(projectArea, shortOp, monitor).getWorkflowIdForCategory(category);
        }
        return (String)this.fGlobalMapping.fBinding.get(category);
    }

    public IWorkflowDescriptor getWorkflowDescriptor(IProjectAreaHandle projectArea, String workflowId, boolean shortOp, IProgressMonitor monitor) throws WorkflowException {
        IWorkflowDescriptor workflowDescriptor = null;
        ProjectAreaRegistry projectAreaMapping = null;
        if (projectArea != null && (projectAreaMapping = this.getProjectAreaRegistry(projectArea, shortOp, monitor)) != null) {
            workflowDescriptor = projectAreaMapping.getWorkflowDescriptor(workflowId);
        }
        if (workflowDescriptor == null || projectAreaMapping == null) {
            projectAreaMapping = this.fGlobalMapping;
        }
        return projectAreaMapping.getWorkflowDescriptor(workflowId);
    }

    public IWorkflowInfo getWorkflowInfo(IProjectAreaHandle projectArea, String workflowId, boolean shortOp, IProgressMonitor monitor) {
        IWorkflowInfo info = null;
        ProjectAreaRegistry projectAreaMapping = null;
        if (projectArea != null && (projectAreaMapping = this.getProjectAreaRegistry(projectArea, shortOp, monitor)) != null) {
            info = projectAreaMapping.getWorkflowInfo(workflowId);
        }
        if (info == null || projectAreaMapping == null) {
            projectAreaMapping = this.fGlobalMapping;
        }
        return projectAreaMapping.getWorkflowInfo(workflowId);
    }

    public IWorkflowInfo getCachedWorkflowInfo(IWorkItem workItem) {
        String workflowId = null;
        try {
            workflowId = this.getWorkflowId(workItem, true, null);
        }
        catch (TeamRepositoryException e) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.CANNOT_RETRIEVE_WORKFLOWID_FROM_WORKITEM"), (Exception)((Object)e));
        }
        if (workflowId == null) {
            return null;
        }
        return this.getWorkflowInfo(workItem.getProjectArea(), workflowId, true, null);
    }

    public IWorkflowInfo getWorkflowInfo(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkflowInfo info = this.getBoundWorkflowInfo(workItem, monitor);
        if (info == null) {
            info = NULL_WORKFLOWINFO;
        }
        return info;
    }

    public IWorkflowInfo getBoundWorkflowInfo(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        String workflowId = this.getWorkflowId(workItem, false, monitor);
        IWorkflowInfo info = null;
        if (workflowId != null) {
            info = this.getWorkflowInfo(workItem.getProjectArea(), workflowId, false, monitor);
        }
        return info;
    }

    public ICombinedWorkflowInfos getCachedCombinedWorkflowInfos(IProjectAreaHandle projectArea) {
        ProjectAreaRegistry projectAreaMapping;
        if (projectArea != null && (projectAreaMapping = this.getCachedProjectAreaRegistry(projectArea)) != null) {
            return projectAreaMapping.getfCombinedWorkflowInfos();
        }
        return this.fGlobalMapping.getfCombinedWorkflowInfos();
    }

    public ICombinedWorkflowInfos getCombinedWorkflowInfos(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        ProjectAreaRegistry projectAreaMapping;
        if (projectArea != null && (projectAreaMapping = this.getProjectAreaRegistry(projectArea, false, monitor)) != null) {
            return projectAreaMapping.getfCombinedWorkflowInfos();
        }
        return this.fGlobalMapping.getfCombinedWorkflowInfos();
    }

    @Override
    public IStateGroups getStateGroups(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        ProjectAreaRegistry projectAreaMapping = this.getProjectAreaRegistry(projectArea, false, monitor);
        if (projectAreaMapping != null) {
            return new StateGroups(projectAreaMapping.getStateGroups());
        }
        return new StateGroups();
    }

    public static boolean containsOnlyBuiltinWorkflows(ICombinedWorkflowInfos info) {
        if (info instanceof CombinedWorkflowInfos) {
            return ((CombinedWorkflowInfos)info).containsOnlyBuiltinWorkflows();
        }
        return false;
    }

    private ProjectAreaRegistry getCachedProjectAreaRegistry(IProjectAreaHandle projectArea) {
        if (projectArea == null) {
            return null;
        }
        UUID itemId = projectArea.getItemId();
        ProjectAreaRegistry projectAreaRegistry = this.fProjectAreaRegistry.get(itemId);
        if (projectAreaRegistry == null) {
            projectAreaRegistry = new ProjectAreaRegistry(projectArea, this.getAuditableCommon().getRepositoryURI());
            this.fProjectAreaRegistry.put(itemId, projectAreaRegistry);
        }
        return projectAreaRegistry;
    }

    private ProjectAreaRegistry getProjectAreaRegistry(IProjectAreaHandle projectArea, boolean shortOp, IProgressMonitor monitor) {
        if (projectArea == null) {
            return null;
        }
        UUID itemId = projectArea.getItemId();
        if (shortOp) {
            ProjectAreaRegistry projectAreaRegistry = this.fProjectAreaRegistry.get(itemId);
            if (projectAreaRegistry == null) {
                projectAreaRegistry = new ProjectAreaRegistry(projectArea, this.getAuditableCommon().getRepositoryURI());
                this.fProjectAreaRegistry.put(itemId, projectAreaRegistry);
            }
            return projectAreaRegistry;
        }
        try {
            this.checkCache(projectArea, monitor);
        }
        catch (TeamRepositoryException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.CANT_RESOLVE_WORKFLOW"), (Exception)((Object)x));
        }
        return this.fProjectAreaRegistry.get(itemId);
    }

    private static IExtensionRegistry getExtensionRegistry() {
        IExtensionRegistry registry = null;
        try {
            registry = Platform.getExtensionRegistry();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        if (registry == null) {
            registry = WorkflowManager.getWorkplaceRegistry();
        }
        if (registry == null) {
            throw new IllegalStateException();
        }
        return registry;
    }

    private static IExtensionRegistry getWorkplaceRegistry() {
        try {
            Class<?> clazz = Class.forName("com.ibm.workplace.extension.ExtensionRegistryFactory");
            Field field = clazz.getField("INSTANCE");
            Object factory = field.get(null);
            Method method = clazz.getMethod("getExtensionRegistry", null);
            return (IExtensionRegistry)method.invoke(factory, new Object[0]);
        }
        catch (ClassNotFoundException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.EXCEPTION_IN_GETWORKPLACEREGISTRY"), x);
        }
        catch (SecurityException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.EXCEPTION_IN_GETWORKPLACEREGISTRY"), x);
        }
        catch (NoSuchFieldException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.EXCEPTION_IN_GETWORKPLACEREGISTRY"), x);
        }
        catch (IllegalArgumentException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.EXCEPTION_IN_GETWORKPLACEREGISTRY"), x);
        }
        catch (IllegalAccessException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.EXCEPTION_IN_GETWORKPLACEREGISTRY"), x);
        }
        catch (NoSuchMethodException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.EXCEPTION_IN_GETWORKPLACEREGISTRY"), x);
        }
        catch (InvocationTargetException x) {
            WorkItemCommonPlugin.log(Messages.getString("WorkflowManager.EXCEPTION_IN_GETWORKPLACEREGISTRY"), x);
        }
        return null;
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        String categoryId;
        IProcessConfigurationElement configurationElement;
        IProcessConfigurationElement[] configurationElements;
        if (auditableCommon == null) {
            return;
        }
        IProjectArea projectArea = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)projectAreaHandle, ItemProfile.createFullProfile(IProjectArea.ITEM_TYPE), monitor);
        if (projectArea == null) {
            return;
        }
        ProjectAreaRegistry projectAreaMapping = new ProjectAreaRegistry(projectAreaHandle, auditableCommon.getRepositoryURI());
        IAuditableCommonProcess process = auditableCommon.getProcess((IProcessAreaHandle)projectArea, monitor);
        LocalizationContext lc = LocalizationContext.createProjectAreaContext(auditableCommon, (IProjectAreaHandle)projectArea, monitor);
        LinkedHashMap<String, StateGroup> openGroups = new LinkedHashMap<String, StateGroup>();
        LinkedHashMap<String, StateGroup> inProgressGroups = new LinkedHashMap<String, StateGroup>();
        LinkedHashMap<String, StateGroup> closedGroups = new LinkedHashMap<String, StateGroup>();
        ArrayList<StateGroup> rest = new ArrayList<StateGroup>();
        IProcessConfigurationData processConfiguration = process.findProcessConfiguration(WORK_FLOW_CONFIGURATION_DATA_POINT, monitor);
        if (processConfiguration != null) {
            configurationElements = processConfiguration.getElements();
            int i = 0;
            while (i < configurationElements.length) {
                configurationElement = configurationElements[i];
                if (DEFINITION_ELEMENT.equals(configurationElement.getName())) {
                    String workflowId = configurationElement.getAttribute("id");
                    if (workflowId != null && workflowId.length() > 0) {
                        DefaultWorkflow wdesc = new DefaultWorkflow(configurationElement);
                        wdesc.setId(workflowId);
                        projectAreaMapping.fRegistry.put(workflowId, wdesc);
                    }
                } else if (STATE_GROUP_ELEMENT.equals(configurationElement.getName())) {
                    categoryId = configurationElement.getAttribute(STATE_GROUP_CATEGORY_ATTRIBUTE);
                    String id = configurationElement.getAttribute("id");
                    String name = configurationElement.getAttribute("name");
                    String icon = configurationElement.getAttribute(STATE_GROUP_ICON_ATTRIBUTE);
                    String oslcGroup = configurationElement.getAttribute(STATE_GROUP_OSLC_GROUP);
                    URL iconUrl = Utils.createResourceURL(this.getAuditableCommon(), (IProcessContainerHandle)projectAreaHandle, icon, monitor);
                    if (categoryId != null && id != null && name != null) {
                        StateGroup stateGroup = new StateGroup(categoryId, id, name, iconUrl, WorkflowManager.getOSLCGroups(oslcGroup));
                        if ("open".equals(categoryId)) {
                            openGroups.put(id, stateGroup);
                        } else if ("inprogress".equals(categoryId)) {
                            inProgressGroups.put(id, stateGroup);
                        } else if ("closed".equals(categoryId)) {
                            closedGroups.put(id, stateGroup);
                        } else {
                            rest.add(stateGroup);
                        }
                    }
                }
                ++i;
            }
        }
        if (!openGroups.containsKey("open")) {
            URL openUrl = Utils.createResourceURL(this.getAuditableCommon(), (IProcessContainerHandle)projectAreaHandle, STATE_GROUP_OPEN_ICON, monitor);
            projectAreaMapping.addStateGroup(new StateGroup("open", "open", Messages.getString(lc, "WorkflowManager.GROUP_OPEN_NAME"), openUrl, Collections.<IStateGroup.OSLCGroup>emptyList()));
        }
        for (StateGroup stateGroup : openGroups.values()) {
            projectAreaMapping.addStateGroup(stateGroup);
        }
        if (!inProgressGroups.containsKey("inprogress")) {
            URL progressUrl = Utils.createResourceURL(this.getAuditableCommon(), (IProcessContainerHandle)projectAreaHandle, STATE_GROUP_IN_PROGRESS_ICON, monitor);
            projectAreaMapping.addStateGroup(new StateGroup("inprogress", "inprogress", Messages.getString(lc, "WorkflowManager.GROUP_IN_PROGRESS_NAME"), progressUrl, Collections.singletonList(IStateGroup.OSLCGroup.INPROGRESS)));
        }
        for (StateGroup stateGroup : inProgressGroups.values()) {
            projectAreaMapping.addStateGroup(stateGroup);
        }
        if (!closedGroups.containsKey("closed")) {
            URL resolvedUrl = Utils.createResourceURL(this.getAuditableCommon(), (IProcessContainerHandle)projectAreaHandle, STATE_GROUP_RESOLVED_ICON, monitor);
            projectAreaMapping.addStateGroup(new StateGroup("closed", "closed", Messages.getString(lc, "WorkflowManager.GROUP_RESOLVED_NAME"), resolvedUrl, Collections.singletonList(IStateGroup.OSLCGroup.CLOSED)));
        }
        for (StateGroup stateGroup : closedGroups.values()) {
            projectAreaMapping.addStateGroup(stateGroup);
        }
        for (StateGroup stateGroup : rest) {
            projectAreaMapping.addStateGroup(stateGroup);
        }
        processConfiguration = process.findProcessConfiguration(WORK_FLOW_BINDINGS_CONFIGURATION_DATA_POINT, monitor);
        if (processConfiguration != null) {
            configurationElements = processConfiguration.getElements();
            int i = 0;
            while (i < configurationElements.length) {
                String workflowId;
                configurationElement = configurationElements[i];
                if (BINDING_ELEMENT.equals(configurationElement.getName()) && (categoryId = configurationElement.getAttribute(WORK_ITEM_CATEGORY_ID_ATTRIBUTE)) != null && categoryId.length() > 0 && (workflowId = configurationElement.getAttribute(WORKFLOW_ID_ATTRIBUTE)) != null && workflowId.length() > 0) {
                    projectAreaMapping.fBinding.put(categoryId, workflowId);
                }
                ++i;
            }
        }
        projectAreaMapping.resolveImageURLs(auditableCommon, monitor);
        this.fProjectAreaRegistry.put(projectArea.getItemId(), projectAreaMapping);
    }

    private static List<IStateGroup.OSLCGroup> getOSLCGroups(String oslcGroupString) {
        ArrayList<IStateGroup.OSLCGroup> oslcGroups = new ArrayList<IStateGroup.OSLCGroup>(1);
        if (oslcGroupString != null) {
            String[] parts;
            String[] stringArray = parts = oslcGroupString.split(",");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String groupId = stringArray[n2];
                IStateGroup.OSLCGroup group = IStateGroup.OSLCGroup.getGroup(groupId.trim());
                if (group != null) {
                    oslcGroups.add(group);
                }
                ++n2;
            }
        }
        return oslcGroups;
    }

    private static class ProjectAreaRegistry {
        private final Map<String, String> fBinding = new HashMap<String, String>();
        private final Map<String, Object> fRegistry = new HashMap<String, Object>();
        private final Map<String, IWorkflowInfo> fWorkflowInfos = new HashMap<String, IWorkflowInfo>();
        private ICombinedWorkflowInfos fCombinedWorkflowInfos;
        private final IProjectAreaHandle fProjectArea;
        private final StateGroupRegistry fStateGroupRegistry = new StateGroupRegistry();
        private boolean fIsStateGroupRegistryInitialized = false;
        private final String fRepositoryURI;

        ProjectAreaRegistry(IProjectAreaHandle projectArea, String repositoryURI) {
            this.fProjectArea = AuditablesHelper.newItemHandle(projectArea, false);
            this.fRepositoryURI = repositoryURI;
        }

        String getWorkflowIdForCategory(String categoryId) {
            return this.fBinding.get(categoryId);
        }

        IWorkflowDescriptor getWorkflowDescriptor(String workflowId) throws WorkflowException {
            Object object = this.fRegistry.get(workflowId);
            if (object instanceof IConfigurationElement) {
                IConfigurationElement ce = (IConfigurationElement)object;
                try {
                    object = ce.createExecutableExtension("class");
                    if (object instanceof IWorkflowDescriptor) {
                        IWorkflowDescriptor wd = (IWorkflowDescriptor)object;
                        wd.setId(workflowId);
                        this.fRegistry.put(workflowId, wd);
                        return wd;
                    }
                }
                catch (CoreException e) {
                    throw new WorkflowException(NLS.bind((String)Messages.getString("WorkflowManager.CANT_CREATE_WORKFLOW"), (Object)workflowId, (Object[])new Object[0]), (Exception)((Object)e));
                }
            }
            if (object instanceof IWorkflowDescriptor) {
                return (IWorkflowDescriptor)object;
            }
            return null;
        }

        IMemento getWorkflowMemento(String workflowId) {
            IWorkflowDescriptor wfd = null;
            try {
                wfd = this.getWorkflowDescriptor(workflowId);
            }
            catch (WorkflowException workflowException) {}
            if (wfd == null) {
                return null;
            }
            XMLMemento memento = XMLMemento.createWriteRoot((String)"workflows");
            wfd.getWorkflowInfo((IMemento)memento);
            return memento;
        }

        IWorkflowInfo getWorkflowInfo(String workflowId) {
            IMemento memento;
            IWorkflowInfo info = this.fWorkflowInfos.get(workflowId);
            if (info == null && (memento = this.getWorkflowMemento(workflowId)) != null) {
                this.updateStateGroups();
                info = new WorkflowInfo(this.fProjectArea, workflowId, memento, this.fRepositoryURI, this.fStateGroupRegistry);
                this.fWorkflowInfos.put(workflowId, info);
            }
            return info;
        }

        void collectWorkflowInfos(ArrayList<IWorkflowInfo> result) {
            for (String workflowId : this.fRegistry.keySet()) {
                IWorkflowInfo info = this.getWorkflowInfo(workflowId);
                if (info == null) continue;
                int indexOf = result.indexOf(info);
                if (indexOf >= 0) {
                    result.set(indexOf, info);
                    continue;
                }
                result.add(info);
            }
        }

        ICombinedWorkflowInfos getfCombinedWorkflowInfos() {
            if (this.fCombinedWorkflowInfos == null) {
                ArrayList<IWorkflowInfo> result = new ArrayList<IWorkflowInfo>();
                this.collectWorkflowInfos(result);
                IWorkflowInfo[] infos = result.toArray(new IWorkflowInfo[result.size()]);
                this.fCombinedWorkflowInfos = new CombinedWorkflowInfos(infos);
            }
            return this.fCombinedWorkflowInfos;
        }

        void resolveImageURLs(IAuditableCommon auditableCommon, IProgressMonitor monitor) {
            ArrayList<IWorkflowInfo> result = new ArrayList<IWorkflowInfo>();
            this.collectWorkflowInfos(result);
            for (IWorkflowInfo workflowInfo : result) {
                ((WorkflowInfo)workflowInfo).resolveImageURLs(auditableCommon, monitor);
            }
        }

        void addStateGroup(StateGroup stateGroup) {
            this.fStateGroupRegistry.add(stateGroup);
            this.fIsStateGroupRegistryInitialized = false;
        }

        void updateStateGroups() {
            if (this.fIsStateGroupRegistryInitialized) {
                return;
            }
            this.fStateGroupRegistry.clearMappings();
            for (String workflowId : this.fRegistry.keySet()) {
                try {
                    IWorkflowDescriptor descriptor = this.getWorkflowDescriptor(workflowId);
                    if (!(descriptor instanceof DefaultWorkflow)) continue;
                    DefaultWorkflow workflow = (DefaultWorkflow)descriptor;
                    Map<String, Set<StateResolutionPair>> stateGroupMappings = workflow.getStateGroupMappings();
                    for (Map.Entry<String, Set<StateResolutionPair>> entry : stateGroupMappings.entrySet()) {
                        StateGroup stateGroup = this.fStateGroupRegistry.getStateGroupById(entry.getKey());
                        if (stateGroup != null) {
                            stateGroup.addStateResolutionPairs(entry.getValue());
                            continue;
                        }
                        WorkItemCommonPlugin.log(NLS.bind((String)"Unknown state group: {0}", (Object)entry.getKey(), (Object[])new Object[0]), null);
                    }
                }
                catch (WorkflowException workflowException) {}
            }
            this.removeIfEmpty("open");
            this.removeIfEmpty("inprogress");
            this.removeIfEmpty("closed");
            this.fIsStateGroupRegistryInitialized = true;
        }

        Map<String, IStateGroup> getStateGroups() {
            this.updateStateGroups();
            return this.fStateGroupRegistry.getStateGroups();
        }

        private void removeIfEmpty(String groupId) {
            StateGroup stateGroup = this.fStateGroupRegistry.getStateGroupById(groupId);
            if (stateGroup != null && stateGroup.isEmpty()) {
                this.fStateGroupRegistry.removeStateGroupById(groupId);
            }
        }
    }
}

