/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import com.ibm.team.links.common.internal.registry.LinkTypeRegistry;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectLink;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.internal.util.ItemStore;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;

public class ItemProfile<T extends IAuditable> {
    public static final ItemProfile<IContributor> CONTRIBUTOR_DEFAULT = ItemProfile.createProfile(IContributor.ITEM_TYPE, AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension(Arrays.asList(IContributor.NAME_PROPERTY, IContributor.EMAIL_ADDRESS_PROPERTY, IContributor.USERID_PROPERTY, IContributor.DETAILS_PROPERTY, IContributor.ARCHIVED_PROPERTY));
    public static final ItemProfile<IProjectArea> PROJECT_AREA_DEFAULT = ItemProfile.createProfile(IProjectArea.ITEM_TYPE, AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension(AuditablesHelper.getProcessPropertiesFromIds(IProjectArea.class, "name", "teamMembers", "developmentLines", "archived", "initialized"));
    public static final ItemProfile<IProjectArea> PROJECT_AREA_FULL = ItemProfile.createFullProfile(IProjectArea.ITEM_TYPE);
    public static final ItemProfile<IProjectArea> PROJECT_AREA_LINKS_ONLY = ItemProfile.createProfile(IProjectArea.ITEM_TYPE, AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension(AuditablesHelper.getProcessPropertiesFromIds(IProjectArea.class, "projectLinks"));
    public static final ItemProfile<ITeamArea> TEAM_AREA_DEFAULT = ItemProfile.createProfile(ITeamArea.ITEM_TYPE, AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension(AuditablesHelper.getProcessPropertiesFromIds(ITeamArea.class, "name", "teamMembers", "archived", "projectArea"));
    public static final ItemProfile<IProcessArea> PROCESS_AREA_SMALL = ItemProfile.createProfile(IProcessArea.ITEM_TYPE, AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension(AuditablesHelper.getProcessPropertiesFromIds(IProjectArea.class, "name", "archived", "projectArea"));
    public static final ItemProfile<IProcessArea> PROCESS_AREA_DEFAULT = ItemProfile.createProfile(IProcessArea.ITEM_TYPE, AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension(AuditablesHelper.getProcessPropertiesFromIds(IProjectArea.class, "name", "teamMembers", "archived", "projectArea"));
    public static final ItemProfile<IDevelopmentLine> DEVELOPMENT_LINE_DEFAULT = ItemProfile.createProfile(IDevelopmentLine.ITEM_TYPE, AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension(AuditablesHelper.getProcessPropertiesFromIds(IDevelopmentLine.class, "id", "name", "currentIteration", "projectArea", "iterations"));
    public static final ItemProfile<IIteration> ITERATION_DEFAULT = ItemProfile.createProfile(IIteration.ITEM_TYPE, AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension(AuditablesHelper.getProcessPropertiesFromIds(IIteration.class, "id", "name", "startDate", "endDate", "developmentLine", "parent", "children", "hasDeliverable", "archived"));
    public static final ItemProfile<IProcessAttachment> PROCESS_ATTACHMENT_DEFAULT = ItemProfile.createFullProfile(IProcessAttachment.ITEM_TYPE);
    public static final ItemProfile<IProjectLink> PROJECT_LINK_DEFAULT = ItemProfile.createFullProfile(IProjectLink.ITEM_TYPE);
    private IItemType fItemType;
    private Collection<String> fProperties;
    private Collection<String> fLinkTypeIds;

    public static <T extends IAuditable> ItemProfile<T> createProfile(IItemType itemType, Collection<String> properties) {
        return ItemProfile.createProfile(itemType, properties, false);
    }

    public static <T extends IAuditable> ItemProfile<T> createProfile(IItemType itemType, Collection<String> properties, boolean containsReferences) {
        return new ItemProfile<T>(itemType, properties, containsReferences);
    }

    public static <T extends IAuditable> ItemProfile<T> createProfile(IItemType itemType, Collection<String> properties, Collection<String> linkTypeIds) {
        return new ItemProfile<T>(itemType, properties, linkTypeIds);
    }

    public static <T extends IAuditable> ItemProfile<T> createProfile(IItemType itemType, String ... properties) {
        return new ItemProfile<T>(itemType, Arrays.asList(properties));
    }

    public static <T extends IAuditable> ItemProfile<T> createFullProfile(IItemType itemType) {
        return ItemProfile.createFullProfile(itemType, false);
    }

    public static <T extends IAuditable> ItemProfile<T> createFullProfile(IItemType itemType, boolean containsReferences) {
        return new ItemProfile<T>(itemType, AuditablesHelper.allProperties(itemType), containsReferences);
    }

    public static <T extends IAuditable> ItemProfile<T> computeProfile(T item) {
        ArrayList<String> setProperties = new ArrayList<String>();
        Collection<String> properties = AuditablesHelper.allProperties(item.getItemType());
        for (String property : properties) {
            if (!item.isPropertySet(property)) continue;
            setProperties.add(property);
        }
        return ItemProfile.createProfile(item.getItemType(), setProperties);
    }

    private static Collection<String> allLinkTypeIdsForItemType(IItemType itemType) {
        Collection allEntries = ILinkTypeRegistry.INSTANCE.allEntries();
        HashSet<String> result = new HashSet<String>(allEntries.size());
        for (ILinkType linkType : allEntries) {
            boolean add;
            IItemType referenceItemType = linkType.getSourceEndPointDescriptor().getReferencedItemType();
            boolean bl = add = referenceItemType == null || referenceItemType.equals(itemType);
            if (!add) {
                referenceItemType = linkType.getTargetEndPointDescriptor().getReferencedItemType();
                boolean bl2 = add = referenceItemType == null || referenceItemType.equals(itemType);
            }
            if (!add) continue;
            result.add(linkType.getLinkTypeId());
        }
        return result;
    }

    private ItemProfile(IItemType itemType, Collection<String> properties) {
        this(itemType, properties, false);
    }

    private ItemProfile(IItemType itemType, Collection<String> properties, boolean containsReferences) {
        this(itemType, properties, containsReferences ? ItemProfile.allLinkTypeIdsForItemType(itemType) : Collections.emptyList());
    }

    private ItemProfile(IItemType itemType, Collection<String> properties, Collection<String> linkTypeIds) {
        Collection<String> profile = AuditablesHelper.addDependencies(itemType, properties);
        Assert.isTrue((boolean)AuditablesHelper.allProperties(itemType).containsAll(profile));
        this.fItemType = itemType;
        this.fProperties = AuditablesHelper.USE_CUSTOM_ACCESS_PROFILES ? Collections.unmodifiableCollection(profile) : AuditablesHelper.allProperties(itemType);
        for (String linkTypeId : linkTypeIds) {
            Assert.isTrue((boolean)LinkTypeRegistry.INSTANCE.isRegistered(linkTypeId));
        }
        this.fLinkTypeIds = Collections.unmodifiableCollection(linkTypeIds);
    }

    public ItemProfile<T> createExtension(Collection<String> properties) {
        return this.createExtension(properties, false);
    }

    public ItemProfile<T> createExtension(Collection<String> properties, boolean containsReferences) {
        if (this.getProperties().containsAll(properties) && (this.containsReferences() || !containsReferences)) {
            return this;
        }
        return new ItemProfile<T>(this.getItemType(), AuditablesHelper.union(this.getProperties(), properties), containsReferences ? ItemProfile.allLinkTypeIdsForItemType(this.getItemType()) : this.getReferences());
    }

    public ItemProfile<T> createExtension(Collection<String> properties, Collection<String> linkTypeIds) {
        if (this.getProperties().containsAll(properties) && this.getReferences().containsAll(linkTypeIds)) {
            return this;
        }
        return new ItemProfile<T>(this.getItemType(), AuditablesHelper.union(this.getProperties(), properties), AuditablesHelper.union(this.getReferences(), linkTypeIds));
    }

    public ItemProfile<T> createExtension(String ... properties) {
        return this.createExtension(Arrays.asList(properties));
    }

    public IItemType getItemType() {
        return this.fItemType;
    }

    public Collection<String> getProperties() {
        return this.fProperties;
    }

    public String[] getPropertiesArray() {
        return this.fProperties.toArray(new String[this.fProperties.size()]);
    }

    public boolean isMatched(IAuditable auditable) {
        IItem tmp = ItemStore.getImmutableItem((IItem)auditable);
        if (tmp instanceof IAuditable) {
            auditable = (IAuditable)tmp;
        }
        Assert.isTrue((this.getItemType() == auditable.getItemType() ? 1 : 0) != 0);
        for (String property : this.getProperties()) {
            if (auditable.isPropertySet(property)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(ItemProfile<? extends IAuditable> profile) {
        Assert.isTrue((boolean)this.getItemType().equals(profile.getItemType()));
        ArrayList<String> missing = new ArrayList<String>(profile.getProperties());
        missing.removeAll(this.getProperties());
        return missing.isEmpty();
    }

    public boolean contains(String property) {
        return this.fProperties.contains(property);
    }

    public Collection<String> getReferences() {
        return this.fLinkTypeIds;
    }

    public String[] getReferencesArray() {
        return this.fLinkTypeIds.toArray(new String[this.fLinkTypeIds.size()]);
    }

    public boolean containsReferences() {
        return !this.fLinkTypeIds.isEmpty();
    }

    public boolean containsReference(String linkTypeId) {
        return this.fLinkTypeIds.contains(linkTypeId);
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ItemProfile other = (ItemProfile)obj;
        return this.containsReferences() == other.containsReferences() && this.getItemType().equals(other.getItemType()) && new HashSet<String>(this.getProperties()).equals(new HashSet<String>(other.getProperties()));
    }

    public int hashCode() {
        int hash = this.getItemType().hashCode();
        hash = 29 * hash + new HashSet<String>(this.getProperties()).hashCode();
        hash = 29 * hash + Boolean.valueOf(this.containsReferences()).hashCode();
        return hash;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getItemType().getName());
        buffer.append("[");
        Iterator<String> iter = this.getProperties().iterator();
        while (iter.hasNext()) {
            String property = iter.next();
            buffer.append(property);
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        if (this.containsReferences()) {
            buffer.append(", [");
            iter = this.getReferences().iterator();
            while (iter.hasNext()) {
                String linkTypeId = iter.next();
                buffer.append(linkTypeId);
                if (!iter.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append("]");
        }
        return buffer.toString();
    }
}

