/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.util.ClientLibraryFactory;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.util.ExtensionReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;

public class ClientLibraryFactoryRegistry
extends ExtensionReader {
    public static ClientLibraryFactoryRegistry INSTANCE = new ClientLibraryFactoryRegistry();
    private static final String EXTENSIONPOINT_ID = "clientLibraryFactory";
    private static Log log = LogFactory.getLog((String)"com.ibm.team.repository");
    private final Map descriptors = new HashMap();

    public ClientLibraryFactoryRegistry() {
        super("com.ibm.team.repository.client", EXTENSIONPOINT_ID);
        this.earlyStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleExtensionAdded(IConfigurationElement element) {
        if (element.getName().equals("factory")) {
            Descriptor descriptor = new Descriptor(element);
            String interfaceClassName = descriptor.getInterfaceClassName();
            if (interfaceClassName != null) {
                Map map = this.descriptors;
                synchronized (map) {
                    this.descriptors.put(interfaceClassName, descriptor);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleExtensionRemoved(IConfigurationElement element) {
        String key = Descriptor.getInterfaceClassName(element);
        Object value = null;
        Map map = this.descriptors;
        synchronized (map) {
            value = this.descriptors.remove(key);
        }
        return value != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getClientLibrary(TeamRepository repository, Class interfaceClass) {
        ClientLibraryFactory factory;
        String interfaceClassName = interfaceClass.getName();
        Descriptor descriptor = null;
        Map map = this.descriptors;
        synchronized (map) {
            descriptor = (Descriptor)this.descriptors.get(interfaceClassName);
        }
        if (descriptor != null && (factory = descriptor.getFactory()) != null) {
            return factory.createClientLibrary(repository);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Descriptor[] getDescriptors() {
        Map map = this.descriptors;
        synchronized (map) {
            return this.descriptors.values().toArray(new Descriptor[this.descriptors.size()]);
        }
    }

    public static class Descriptor {
        public static final String FACTORY = "factory";
        public static final String NAME = "name";
        public static final String INTERFACE_CLASS = "interfaceClass";
        public static final String FACTORY_CLASS = "factoryClass";
        private final IConfigurationElement element;
        private ClientLibraryFactory factory;

        public Descriptor(IConfigurationElement element) {
            this.element = element;
            this.factory = null;
        }

        public synchronized IConfigurationElement getElement() {
            return this.element;
        }

        public synchronized String getName() {
            return this.element.getAttribute(NAME);
        }

        public synchronized ClientLibraryFactory getFactory() {
            if (this.factory == null) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        log.error((Object)exception.getMessage(), exception);
                    }

                    public void run() throws Exception {
                        Descriptor.this.factory = (ClientLibraryFactory)Descriptor.this.element.createExecutableExtension(Descriptor.FACTORY_CLASS);
                    }
                });
            }
            return this.factory;
        }

        public synchronized String getInterfaceClassName() {
            return Descriptor.getInterfaceClassName(this.element);
        }

        private static String getInterfaceClassName(IConfigurationElement element) {
            return element.getAttribute(INTERFACE_CLASS);
        }
    }
}

