/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.ILoginHandler2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.LoginHandlerWrapper;
import com.ibm.team.repository.common.util.ExtensionReader;
import com.ibm.team.repository.transport.client.IOAuthHandler;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class LoginHandlerExtensionReader
extends ExtensionReader {
    public static LoginHandlerExtensionReader INSTANCE = new LoginHandlerExtensionReader();
    private static final String EXTENSIONPOINT_ID = "loginHandler";
    protected static Log log = LogFactory.getLog(LoginHandlerExtensionReader.class);
    private final List<Descriptor> loginHandlers = new ArrayList<Descriptor>();

    private LoginHandlerExtensionReader() {
        super("com.ibm.team.repository.client", EXTENSIONPOINT_ID);
        this.earlyStart();
    }

    protected boolean handleExtensionAdded(IConfigurationElement element) {
        if (element.getName().equals("handler")) {
            Descriptor descriptor = new Descriptor(element);
            this.loginHandlers.add(descriptor);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleExtensionRemoved(IConfigurationElement element) {
        String key = Descriptor.getLoginHandler2ClassName(element);
        if (key == null) {
            key = Descriptor.getLoginHandlerClassName(element);
        }
        Descriptor value = null;
        List<Descriptor> list = this.loginHandlers;
        synchronized (list) {
            int size = this.loginHandlers.size();
            int index = 0;
            boolean found = false;
            while (index < size) {
                Descriptor descriptor = this.loginHandlers.get(index);
                String loginHandlerClassName = descriptor.getLoginHandlerClassName();
                String loginHandler2ClassName = descriptor.getLoginHandler2ClassName();
                boolean bl = found = key != null && (key.equals(loginHandlerClassName) || key.equals(loginHandler2ClassName));
                if (found) break;
                ++index;
            }
            if (found) {
                value = this.loginHandlers.remove(index);
            }
        }
        boolean valid = value != null;
        return valid;
    }

    public Descriptor[] getLoginHandlers() {
        return this.loginHandlers.toArray(new Descriptor[this.loginHandlers.size()]);
    }

    public static class Descriptor {
        private IConfigurationElement element = null;
        private ILoginHandler2 handler2;
        private IOAuthHandler oauthHandler;
        private int priority = 0;
        public static final String HANDLER = "handler";
        public static final String CLASS = "class";
        public static final String OAUTH_HANDLER_CLASS = "oauthHandlerClass";
        public static final String PRIORITY = "priority";
        public static final String LOGIN_HANDLER_2_CLASS = "loginHandler2Class";

        private static String getLoginHandlerClassName(IConfigurationElement element) {
            String value = element.getAttribute(CLASS);
            return value;
        }

        private static String getLoginHandler2ClassName(IConfigurationElement element) {
            String value = element.getAttribute(LOGIN_HANDLER_2_CLASS);
            return value;
        }

        public Descriptor(IConfigurationElement element) {
            this.element = element;
        }

        public IConfigurationElement getElement() {
            return this.element;
        }

        public IOAuthHandler getOAuthHandler() {
            if (this.oauthHandler == null) {
                try {
                    this.oauthHandler = (IOAuthHandler)this.element.createExecutableExtension(OAUTH_HANDLER_CLASS);
                }
                catch (CoreException e) {
                    this.handler2 = null;
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return this.oauthHandler;
        }

        public ITeamRepository.ILoginHandler getLoginHandler() {
            ILoginHandler2 handler = this.getHandler();
            if (handler != null && handler instanceof LoginHandlerWrapper) {
                return ((LoginHandlerWrapper)handler).getHander();
            }
            return null;
        }

        private ILoginHandler2 getHandler() {
            if (this.handler2 == null) {
                try {
                    if (this.getLoginHandler2ClassName() != null) {
                        this.handler2 = (ILoginHandler2)this.element.createExecutableExtension(LOGIN_HANDLER_2_CLASS);
                    } else if (this.getLoginHandlerClassName() != null) {
                        ITeamRepository.ILoginHandler handler = (ITeamRepository.ILoginHandler)this.element.createExecutableExtension(CLASS);
                        this.handler2 = new LoginHandlerWrapper(handler);
                    } else {
                        log.warn((Object)"LoginHandler needs to specify either class or loginHandler2Class attribute.");
                    }
                }
                catch (CoreException e) {
                    this.handler2 = null;
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return this.handler2;
        }

        public ILoginHandler2 getLoginHandler2() {
            return this.getHandler();
        }

        private String getLoginHandlerClassName() {
            IConfigurationElement el = this.getElement();
            String value = el.getAttribute(CLASS);
            return value;
        }

        private String getLoginHandler2ClassName() {
            IConfigurationElement el = this.getElement();
            String value = el.getAttribute(LOGIN_HANDLER_2_CLASS);
            return value;
        }

        public int getPriority() {
            if (this.priority == 0) {
                String number = this.element.getAttribute(PRIORITY);
                try {
                    this.priority = Integer.parseInt(number);
                    if (this.priority < 0) {
                        this.priority = 0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.priority = 0;
                }
            }
            return this.priority;
        }
    }
}

