/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.sync;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

class SynchronizedDirectory {
    private static final Logger log = Logger.getLogger(SynchronizedDirectory.class);
    private static final int MAX_TRY_COUNT = Integer.getInteger("com.urbancode.commons.fileutils.sync.SynchronizedDirectory.maxTryCount", 10);
    private static final long RETRY_SLEEP = Long.getLong("com.urbancode.commons.fileutils.sync.SynchronizedDirectory.retrySleep", 100L);
    private final File synchronizedDir;
    private final File lockFile;
    private final File accessedFile;
    private final Set threads = Collections.synchronizedSet(new HashSet());
    private final List queue = Collections.synchronizedList(new LinkedList());
    private final Object mutex = new Object();
    private int readerCount = 0;
    private FileChannel lockFileChannel;
    private FileLock fileLock;

    public SynchronizedDirectory(File synchronizedDir, File lockFile, File accessedFile) {
        this.synchronizedDir = synchronizedDir;
        this.lockFile = lockFile;
        this.accessedFile = accessedFile;
    }

    protected synchronized void createDirectorySynchronizationFiles() throws IOException {
        int i = 0;
        while (true) {
            if (i > 0) {
                try {
                    Thread.sleep(RETRY_SLEEP);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            try {
                this.createDirectories(this.synchronizedDir);
                this.createDirectories(this.getLockFile().getParentFile());
                this.getLockFile().createNewFile();
                this.createDirectories(this.getAccessedFile().getParentFile());
                this.getAccessedFile().createNewFile();
            }
            catch (IOException e) {
                if (i >= MAX_TRY_COUNT) {
                    throw e;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public long getLastAccessTime() {
        if (!this.isLocked()) {
            throw new IllegalStateException("not locked");
        }
        return this.getAccessedFile().lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginWriteAction() throws InterruptedException, IOException {
        this.createDirectorySynchronizationFiles();
        Thread thread = Thread.currentThread();
        this.threads.add(thread);
        this.queue.add(thread);
        Object object = this.mutex;
        synchronized (object) {
            this.checkBeginWriteActionPreCond();
            while (!thread.equals(this.queue.get(0))) {
                this.mutex.wait();
            }
            while (this.readerCount > 0) {
                this.mutex.wait();
            }
            this.checkBeginWriteActionLockPreCond();
            this.lockFileChannel = this.openChannel(this.getLockFile());
            boolean successful = false;
            try {
                this.fileLock = this.lockFileChannel.lock();
                this.updateAccessedTime();
                successful = true;
            }
            catch (FileLockInterruptionException e) {
                throw new InterruptedException(e.getMessage());
            }
            finally {
                if (!successful) {
                    try {
                        this.closeChannel(this.lockFileChannel, this.getLockFile());
                    }
                    catch (Throwable swallow) {
                    }
                    finally {
                        this.lockFileChannel = null;
                    }
                }
            }
        }
        this.checkBeginWriteActionPostCond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endWriteAction() throws IOException {
        Thread thread = Thread.currentThread();
        Object object = this.mutex;
        synchronized (object) {
            this.checkEndWriteActionPreCond();
            try {
                try {
                    this.unlockChannel(this.fileLock, this.getLockFile());
                }
                finally {
                    this.lockFileChannel.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.fileLock = null;
                this.lockFileChannel = null;
                this.mutex.notifyAll();
                this.queue.remove(thread);
                this.threads.remove(thread);
            }
            this.checkEndWriteActionPostCond();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginReadAction() throws InterruptedException, IOException {
        this.createDirectorySynchronizationFiles();
        Thread thread = Thread.currentThread();
        this.threads.add(thread);
        this.queue.add(thread);
        Object object = this.mutex;
        synchronized (object) {
            this.checkBeginReadActionPreCond();
            while (!thread.equals(this.queue.get(0))) {
                this.mutex.wait();
            }
            this.checkBeginReadActionLockPreCond();
            if (this.readerCount == 0) {
                File file = this.getLockFile();
                this.lockFileChannel = this.openChannel(file);
                boolean successful = false;
                try {
                    this.fileLock = this.lockChannel(this.lockFileChannel, file);
                    this.updateAccessedTime();
                    successful = true;
                }
                catch (FileLockInterruptionException e) {
                    throw new InterruptedException(e.getMessage());
                }
                finally {
                    if (!successful) {
                        try {
                            this.closeChannel(this.lockFileChannel, file);
                        }
                        catch (Throwable swallow) {
                        }
                        finally {
                            this.lockFileChannel = null;
                        }
                    }
                }
            }
            ++this.readerCount;
            this.queue.remove(thread);
            this.mutex.notifyAll();
        }
        this.checkBeginReadActionPostCond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void endReadAction() {
        Object object = this.mutex;
        synchronized (object) {
            block20: {
                this.checkEndReadActionPreCond();
                --this.readerCount;
                if (this.readerCount == 0) {
                    try {
                        try {
                            this.unlockChannel(this.fileLock, this.getLockFile());
                            this.fileLock = null;
                        }
                        catch (IOException swallow) {
                            this.fileLock = null;
                            break block20;
                            catch (Throwable throwable) {
                                this.fileLock = null;
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        try {
                            this.closeChannel(this.lockFileChannel, this.getLockFile());
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            this.lockFileChannel = null;
                        }
                    }
                }
            }
            this.mutex.notifyAll();
            this.threads.remove(Thread.currentThread());
            this.checkEndReadActionPostCond();
        }
    }

    public void addCurrentThreadToUseSet() {
        this.threads.add(Thread.currentThread());
    }

    public boolean isInUse() {
        return !this.threads.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAccessedTime() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            File file = this.getAccessedFile();
            FileChannel channel = this.openChannel(file);
            try {
                FileLock fileLock = this.lockChannel(channel, this.getAccessedFile());
                try {
                    file.setLastModified(System.currentTimeMillis());
                }
                finally {
                    this.unlockChannel(fileLock, file);
                }
            }
            finally {
                this.closeChannel(channel, file);
            }
        }
    }

    protected File getAccessedFile() {
        return this.accessedFile;
    }

    protected File getLockFile() {
        return this.lockFile;
    }

    protected void createDirectories(File directory) throws IOException {
        while (directory.getPath().endsWith(File.separator + ".")) {
            directory = directory.getParentFile();
        }
        directory.mkdirs();
        if (!directory.isDirectory()) {
            if (directory.isFile()) {
                throw new IOException(String.format("Unable to create directory %s: path is a file", directory.getAbsolutePath()));
            }
            throw new IOException(String.format("Unable to create directory %s", directory.getAbsolutePath()));
        }
    }

    protected FileChannel openChannel(File file) throws IOException {
        FileChannel result = null;
        File parent = file.getParentFile();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Opening channel to \"" + file.getAbsolutePath() + "\""));
        }
        int i = 0;
        while (true) {
            if (i > 0) {
                try {
                    Thread.sleep(RETRY_SLEEP);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            try {
                this.createDirectories(parent);
                result = new RandomAccessFile(file, "rw").getChannel();
            }
            catch (IOException e) {
                if (i >= MAX_TRY_COUNT) {
                    throw e;
                }
                ++i;
                continue;
            }
            break;
        }
        if (result == null) {
            throw new AssertionError((Object)"Channel is null");
        }
        return result;
    }

    protected void closeChannel(FileChannel channel, File file) throws IOException {
        channel.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closed channel to \"" + file.getAbsolutePath() + "\""));
        }
    }

    protected FileLock lockChannel(FileChannel channel, File file) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Locking channel to \"" + file.getAbsolutePath() + "\""));
        }
        FileLock result = channel.lock(0L, Long.MAX_VALUE, false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Locked channel to \"" + file.getAbsolutePath() + "\""));
        }
        return result;
    }

    protected void unlockChannel(FileLock lock, File file) throws IOException {
        lock.release();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unlocked channel to \"" + file.getAbsolutePath() + "\""));
        }
    }

    private void checkLockConsistent(String op) {
        boolean consistent;
        boolean bl = consistent = this.fileLock == null && this.lockFileChannel == null || this.fileLock != null && this.lockFileChannel != null && this.fileLock.isValid();
        if (!consistent) {
            this.invalidLockState(op);
        }
    }

    private boolean isLocked() {
        return this.fileLock != null && this.lockFileChannel != null && this.fileLock.isValid();
    }

    private void invalidLockState(String op) {
        throw new IllegalStateException("Invalid lock state for op " + op + ": lockFile=" + this.lockFile + " readerCount=" + this.readerCount + " fileLock=" + this.fileLock + " lockFileChannel=" + this.lockFileChannel);
    }

    private void checkBeginWriteActionPreCond() {
        this.checkLockConsistent("beginWriteAction");
        if (this.readerCount < 0) {
            this.invalidLockState("beginWriteAction");
        }
    }

    private void checkBeginWriteActionLockPreCond() {
        this.checkLockConsistent("beginWriteAction");
        if (this.readerCount != 0 || this.isLocked()) {
            this.invalidLockState("beginWriteAction");
        }
    }

    private void checkBeginWriteActionPostCond() {
        this.checkLockConsistent("beginWriteAction");
        if (this.readerCount != 0 || !this.isLocked()) {
            this.invalidLockState("beginWriteAction");
        }
    }

    private void checkEndWriteActionPreCond() {
        this.checkLockConsistent("endWriteAction");
        if (this.readerCount != 0 || !this.isLocked()) {
            this.invalidLockState("endWriteAction");
        }
    }

    private void checkEndWriteActionPostCond() {
        this.checkLockConsistent("endWriteAction");
        if (this.readerCount != 0 || this.isLocked()) {
            this.invalidLockState("endWriteAction");
        }
    }

    private void checkBeginReadActionPreCond() {
        this.checkLockConsistent("beginReadAction");
        if (this.readerCount < 0) {
            this.invalidLockState("beginReadAction");
        }
    }

    private void checkBeginReadActionLockPreCond() {
        this.checkLockConsistent("beginReadAction");
        if (this.readerCount < 0) {
            this.invalidLockState("beginReadAction");
        }
        if (this.readerCount == 0 && this.isLocked()) {
            this.invalidLockState("beginReadAction");
        }
        if (this.readerCount > 0 && !this.isLocked()) {
            this.invalidLockState("beginReadAction");
        }
    }

    private void checkBeginReadActionPostCond() {
        this.checkLockConsistent("beginReadAction");
        if (this.readerCount <= 0 || !this.isLocked()) {
            this.invalidLockState("beginReadAction");
        }
    }

    private void checkEndReadActionPreCond() {
        this.checkLockConsistent("endReadAction");
        if (this.readerCount <= 0 || !this.isLocked()) {
            this.invalidLockState("endReadAction");
        }
    }

    private void checkEndReadActionPostCond() {
        this.checkLockConsistent("endReadAction");
        if (this.readerCount < 0) {
            this.invalidLockState("endReadAction");
        }
        if (this.readerCount == 0 && this.isLocked()) {
            this.invalidLockState("endReadAction");
        }
        if (this.readerCount > 0 && !this.isLocked()) {
            this.invalidLockState("endReadAction");
        }
    }
}

