/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.client.rest.internal;

import com.ibm.team.interop.client.rest.IInteropAdminRestClient;
import com.ibm.team.interop.client.rest.IInteropContent;
import com.ibm.team.interop.client.rest.IInteropRestClient;
import com.ibm.team.interop.client.rest.IRestExternalProxy;
import com.ibm.team.interop.client.rest.IRestExternalRepositoryConnection;
import com.ibm.team.interop.client.rest.IRestExternalState;
import com.ibm.team.interop.client.rest.IRestSyncRule;
import com.ibm.team.interop.client.rest.InteropClientException;
import com.ibm.team.interop.client.rest.InteropNotLicensedException;
import com.ibm.team.interop.client.rest.internal.InteropContent;
import com.ibm.team.interop.client.rest.internal.InteropItem;
import com.ibm.team.interop.client.rest.internal.LenientSecureProtocolSocketFactory;
import com.ibm.team.interop.client.rest.internal.Messages;
import com.ibm.team.interop.client.rest.internal.RestExternalProxy;
import com.ibm.team.interop.client.rest.internal.RestExternalRepositoryConnection;
import com.ibm.team.interop.client.rest.internal.RestExternalState;
import com.ibm.team.interop.client.rest.internal.RestSyncRule;
import com.ibm.team.interop.client.rest.json.JSONArray;
import com.ibm.team.interop.client.rest.json.JSONObject;
import com.ibm.team.interop.common.dto.IInteropProjectAreaDTO;
import com.ibm.team.interop.common.dto.IManagerInfoDTO;
import com.ibm.team.interop.common.dto.IPropertyInfoDTO;
import com.ibm.team.interop.common.dto.ITypeInfoDTO;
import com.ibm.team.interop.common.internal.dto.DtoFactory;
import com.ibm.team.interop.common.internal.dto.DtoPackage;
import com.ibm.team.interop.common.internal.dto.InteropProjectAreaDTO;
import com.ibm.team.interop.common.internal.dto.InteropSyncConfigRequestDTO;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.IVirtual;
import com.ibm.team.repository.common.IVirtualType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.impl.VirtualImpl;
import com.ibm.team.repository.common.serialize.IDeserializer2;
import com.ibm.team.repository.common.serialize.ISerializer2;
import com.ibm.team.repository.common.serialize.IURISerializer;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.transport.auth.TransportAuthException;
import com.ibm.team.repository.transport.auth.TransportAuthUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class InteropRestClient
implements IInteropAdminRestClient {
    static final String INTEROP_NS = "com.ibm.team.interop";
    static final String PROCESS_NS = "com.ibm.team.process";
    static final String REPOSITORY_NS = "com.ibm.team.repository";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    protected static final String GET_METHOD = "GET";
    private static final String POST_METHOD = "POST";
    private static final String PUT_METHOD = "PUT";
    private static final String DELETE_METHOD = "DELETE";
    private static final String ADMIN_REST_SERVICE_PREFIX = "/service/com.ibm.team.repository.service.internal.IAdminRestService/";
    private static final String CONTENT_REST_SERVICE_PREFIX = "/service/com.ibm.team.repository.common.internal.IContentRestService/content";
    private static final String ITEM_REST_SERVICE_PREFIX = "/service/com.ibm.team.repository.common.internal.IItemRestService";
    private static final String LICENSE_ADMIN_REST_SERVICE_PREFIX = "/service/com.ibm.team.repository.service.internal.ILicenseAdminRestService/";
    private static final String VIRTUAL_REST_SERVICE_PREFIX = "/resource";
    private static final String SERVER_CONFIGURATION_REST_SERVICE_PREFIX = "/service/com.ibm.team.repository.service.internal.IServerConfigurationRestService/";
    private static final String ITEM_COLLECTION_PREFIX = "/com.ibm.team.repository/itemCol";
    private static final String VIRTUAL_COLLECTION_PREFIX = "/virtualCol";
    private static final String VIRTUAL_PATH_PREFIX = "/virtualPath";
    private static final String ITEM_NAME_PREFIX = "/com.ibm.team.repository/itemName";
    static final String ITEM_OID_PREFIX = "/com.ibm.team.repository/itemOid";
    private static final String ASSIGNED_LICENSES_METHOD = "assignedLicenses";
    private static final String CHECK_LICENSE_METHOD = "checkLicense";
    private static final String CREATE_CONTRIBUTOR_METHOD = "contributor";
    private static final String SEARCH_CONTRIBUTOR_METHOD = "contributors";
    private static final String GET_CONTRIBUTOR_BY_UUID_METHOD = "contributorByUUID";
    private static final String SERVICE_CONFIGURATION_METHOD = "serviceConfiguration";
    private static final String GET_USER_REGISTRY_INFO_METHOD = "userRegistryInfo";
    private static final String LICENSE_STATUS_CODE_NAME = "code";
    private static final String LICENSE_STATUS_MESSAGE_NAME = "message";
    private static final String LICENSE_STATUS_CODE_OK = "OK";
    private static final String NEW_ITEM = "new";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String ACCEPT_CHARSET_HEADER = "Accept-Charset";
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String ETAG_HEADER = "ETag";
    private static final String IF_MATCH_HEADER = "If-Match";
    private static final String LOCATION_HEADER = "Location";
    private static final String X_USERID_HEADER = "X-com-ibm-team-userid";
    private static final String CONNECTION_HEADER = "Connection";
    private static final String CLOSE_CONNECTION = "close";
    private static final String SERVER_HEADER = "Server";
    private static final String JSON_MEDIA_TYPE = "text/json";
    private static final String FORM_URLENCODED_MEDIA_TYPE = "application/x-www-form-urlencoded";
    private static final String UTF8_CHARSET_NAME = "UTF-8";
    private static final String LINKURI_PARAM = "linkuri";
    private static final String EXTERNALTYPE_PARAM = "externaltype";
    private static final String PROJECTAREA_PARAM = "projectArea";
    private static final String SYNC_PARAM = "sync";
    private static final String HASH_CODE_PARAM = "hashcode";
    private static final String OPERATION_ID_PARAM = "operationId";
    private static final String SERVICE_NAME_PARAM = "implementationClassName";
    private static final String EQUALS = "=";
    private static final String SLASH = "/";
    private static final String AUTO_ACCEPT_SSL_CONNECTIONS_PROPERTY = "com.ibm.team.interop.autoAcceptSSLConnections";
    public static final Map<String, String> ITEM_REST_SERVICE_HEADERS = new HashMap<String, String>();
    private static final JSONArray NEW_USER_ROLES;
    private static final JSONArray REQUIRED_USER_ROLES;
    private static final IURISerializer sVirtualUriSerializer;
    public static final String ERROR_CODE_KEY = "errorCode";
    public static final String ERROR_MSG_KEY = "errorMessage";
    public static final String ERROR_TRACE_KEY = "errorTrace";
    public static final String ERROR_TRACE_MARSHALL_KEY = "errorTraceMarshall";
    public static final String ERROR_TRACE_CLASSNAME = "errorTraceClassName";
    public static final String ERROR_TRACE_METHODNAME = "errorTraceMethodName";
    public static final String ERROR_TRACE_FILENAME = "errorTraceFileName";
    public static final String ERROR_TRACE_LINENUM = "errorTraceLineNumber";
    public static final String NESTED_ERROR_KEY = "nestedError";
    protected final String fServerRootUrl;
    private final String fRepoPath;
    private final IInteropRestClient.IAuthenticator fAuthenticator;
    private String fAuthMethod;
    private Header fServerInfo;
    private HttpClient fHttpClient;

    static {
        ITEM_REST_SERVICE_HEADERS.put(ACCEPT_HEADER, JSON_MEDIA_TYPE);
        ITEM_REST_SERVICE_HEADERS.put(ACCEPT_CHARSET_HEADER, UTF8_CHARSET_NAME);
        ITEM_REST_SERVICE_HEADERS.put(CONTENT_TYPE_HEADER, String.format("%s;charset=%s", JSON_MEDIA_TYPE, UTF8_CHARSET_NAME));
        NEW_USER_ROLES = new JSONArray();
        NEW_USER_ROLES.add("JazzUsers");
        REQUIRED_USER_ROLES = new JSONArray();
        REQUIRED_USER_ROLES.add("JazzAdmins");
        REQUIRED_USER_ROLES.add("JazzUsers");
        sVirtualUriSerializer = new IURISerializer(){

            public IItemHandle getItemHandle(URI loc) throws SerializeException {
                return null;
            }

            public IType getType(URI loc) throws SerializeException {
                return null;
            }

            public URI getUri(Object object) throws SerializeException {
                IVirtual virtual = (IVirtual)object;
                IVirtualType type = virtual.getVirtualType();
                String name = null;
                if (type == IInteropProjectAreaDTO.VIRTUAL_TYPE) {
                    name = ((IInteropProjectAreaDTO)virtual).getName();
                } else if (type == IPropertyInfoDTO.VIRTUAL_TYPE) {
                    name = ((IPropertyInfoDTO)virtual).getName();
                } else if (type == ITypeInfoDTO.VIRTUAL_TYPE) {
                    name = ((ITypeInfoDTO)virtual).getName();
                } else if (type == InteropSyncConfigRequestDTO.VIRTUAL_TYPE) {
                    name = ((InteropSyncConfigRequestDTO)virtual).getProjectAreaName();
                } else {
                    return null;
                }
                Location loc = Location.pathLocation((IVirtualType)type, null, (String[])new String[]{name});
                return loc.toRelativeUri();
            }
        };
    }

    public InteropRestClient(String serverRootUrl, IInteropRestClient.IAuthenticator authenticator) {
        if (serverRootUrl == null || serverRootUrl.length() == 0) {
            throw new IllegalArgumentException("The serverRootUrl argument must not be null or empty");
        }
        this.fAuthenticator = authenticator;
        this.fServerRootUrl = serverRootUrl.charAt(serverRootUrl.length() - 1) == '/' ? serverRootUrl.substring(0, serverRootUrl.length() - 1) : serverRootUrl;
        try {
            this.fRepoPath = this.getPath(new URL(this.fServerRootUrl));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(MessageFormat.format("Error parsing repository server url: {0}", e.getMessage()), e);
        }
    }

    @Override
    public void shutdown() {
        if (this.fHttpClient != null) {
            MultiThreadedHttpConnectionManager connectionManager = (MultiThreadedHttpConnectionManager)this.fHttpClient.getHttpConnectionManager();
            connectionManager.shutdown();
        }
    }

    @Override
    public IRestExternalProxy createExternalProxy() {
        return new RestExternalProxy();
    }

    @Override
    public IRestExternalProxy getExternalProxy(IRestExternalProxy externalProxy) throws InteropClientException {
        return new RestExternalProxy(this.getItem((RestExternalProxy)externalProxy));
    }

    @Override
    public IRestExternalProxy findExternalProxy(URI externalURI) throws InteropClientException {
        if (externalURI == null) {
            throw new IllegalArgumentException("The externalURI argument must not be null");
        }
        String queryParams = "linkuri=" + this.urlEncode(externalURI.toASCIIString());
        JSONArray array = this.findItemsByQuery("com.ibm.team.interop.ExternalProxy", queryParams);
        if (array.size() == 0) {
            return null;
        }
        return new RestExternalProxy((JSONObject)array.get(0));
    }

    @Override
    public void saveExternalProxy(IRestExternalProxy externalProxy) throws InteropClientException {
        RestExternalProxy externalProxyItem = (RestExternalProxy)externalProxy;
        if (externalProxyItem.isNewItem()) {
            throw new IllegalArgumentException("An ExternalProxy can only be created with a URI");
        }
        this.saveItem((RestExternalProxy)externalProxy, null);
    }

    @Override
    public void saveExternalProxy(IRestExternalProxy externalProxy, URI externalURI, IRestExternalState externalState) throws InteropClientException {
        this.saveExternalProxy(externalProxy, externalURI, externalState, false);
    }

    @Override
    public void saveExternalProxy(IRestExternalProxy externalProxy, URI externalURI, boolean doSync) throws InteropClientException {
        this.saveExternalProxy(externalProxy, externalURI, null, doSync);
    }

    private void saveExternalProxy(IRestExternalProxy externalProxy, URI externalURI, IRestExternalState externalState, boolean doSync) throws InteropClientException {
        RestExternalProxy externalProxyItem = (RestExternalProxy)externalProxy;
        RestExternalState externalStateItem = (RestExternalState)externalState;
        if (externalURI != null && !externalProxyItem.isNewItem()) {
            throw new IllegalArgumentException(MessageFormat.format("The URI {0} cannot be linked to an existing ExternalProxy object", externalURI));
        }
        if (externalStateItem != null) {
            if (externalStateItem.isNewItem()) {
                URL url = this.createItem(externalStateItem, null);
                InteropItem object = this.getItem(url.getPath());
                externalStateItem = new RestExternalState(object);
            } else {
                this.saveItem(externalStateItem, null);
            }
            externalProxyItem.setExternalState(externalStateItem);
        }
        StringBuilder queryParams = new StringBuilder();
        if (externalStateItem != null || doSync) {
            queryParams.append(SYNC_PARAM);
            queryParams.append('=');
            queryParams.append(Boolean.TRUE.toString());
        }
        if (externalURI != null) {
            if (queryParams.length() != 0) {
                queryParams.append('&');
            }
            queryParams.append(LINKURI_PARAM);
            queryParams.append('=');
            queryParams.append(this.urlEncode(externalURI.toASCIIString()));
            this.createItem(externalProxyItem, queryParams.toString());
        } else {
            this.saveItem(externalProxyItem, queryParams.toString());
        }
    }

    @Override
    public void deleteExternalProxy(IRestExternalProxy externalProxy) throws InteropClientException {
        this.deleteItem((RestExternalProxy)externalProxy);
    }

    @Override
    public IRestExternalState createExternalState() {
        return new RestExternalState();
    }

    @Override
    public IRestExternalState getExternalState(IRestExternalState externalState) throws InteropClientException {
        return new RestExternalState(this.getItem((RestExternalState)externalState));
    }

    @Override
    public IRestExternalState getExternalState(IRestExternalProxy externalProxy) throws InteropClientException {
        JSONObject handle = ((RestExternalProxy)externalProxy).getExternalStateHandle();
        if (handle == null) {
            return null;
        }
        return new RestExternalState(this.getItem(new InteropItem(handle)));
    }

    @Override
    public IRestExternalState findExternalState(URI externalURI) throws InteropClientException {
        if (externalURI == null) {
            throw new IllegalArgumentException("The externalURI argument must not be null");
        }
        String queryParams = "linkuri=" + this.urlEncode(externalURI.toASCIIString());
        JSONArray array = this.findItemsByQuery("com.ibm.team.interop.ExternalState", queryParams);
        if (array.size() == 0) {
            return null;
        }
        return new RestExternalState((JSONObject)array.get(0));
    }

    @Override
    public void saveExternalState(IRestExternalState externalState) throws InteropClientException {
        RestExternalState externalStateItem = (RestExternalState)externalState;
        if (externalStateItem.isNewItem()) {
            throw new IllegalStateException("An ExternalState object can only be created with an ExternalProxy object");
        }
        this.saveItem((RestExternalState)externalState, "sync=" + Boolean.TRUE.toString());
    }

    @Override
    public IRestSyncRule createSyncRule() {
        return new RestSyncRule();
    }

    @Override
    public IRestSyncRule getSyncRule(IRestSyncRule syncRule) throws InteropClientException {
        return new RestSyncRule(this.getItem((RestSyncRule)syncRule));
    }

    @Override
    public IRestSyncRule getSyncRule(IRestExternalProxy externalProxy) throws InteropClientException {
        JSONObject handle = ((RestExternalProxy)externalProxy).getSyncRuleHandle();
        if (handle == null) {
            return null;
        }
        return new RestSyncRule(this.getItem(new InteropItem(handle)));
    }

    @Override
    public List<IRestSyncRule> getAllSyncRules() throws InteropClientException {
        JSONArray array = this.findItemsByQuery("com.ibm.team.interop.SyncRule", null);
        ArrayList<IRestSyncRule> syncRules = new ArrayList<IRestSyncRule>(array.size());
        for (JSONObject object : array) {
            syncRules.add(new RestSyncRule(object));
        }
        return syncRules;
    }

    @Override
    public void saveSyncRule(IRestSyncRule syncRule) throws InteropClientException {
        RestSyncRule syncRuleItem = (RestSyncRule)syncRule;
        if (syncRuleItem.isNewItem()) {
            this.createItem(syncRuleItem, null);
        } else {
            this.saveItem(syncRuleItem, null);
        }
    }

    @Override
    public IRestSyncRule findSyncRule(String name) throws InteropClientException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name argument must not be null or empty");
        }
        JSONObject object = this.findItemByName("com.ibm.team.interop.SyncRule", name);
        if (object == null) {
            return null;
        }
        return new RestSyncRule(object);
    }

    @Override
    public List<IRestSyncRule> findSyncRulesForExternalType(String externalTypeName, String projectAreaId) throws InteropClientException {
        if (!(externalTypeName != null && externalTypeName.length() != 0 || projectAreaId != null && projectAreaId.length() != 0)) {
            throw new IllegalArgumentException("At least one of externalTypeName and projectAreaId arguments must not be null or empty");
        }
        StringBuilder queryParams = new StringBuilder();
        if (externalTypeName != null && externalTypeName.length() != 0) {
            queryParams.append(EXTERNALTYPE_PARAM);
            queryParams.append(EQUALS);
            queryParams.append(this.urlEncode(externalTypeName));
        }
        if (projectAreaId != null && projectAreaId.length() != 0) {
            if (queryParams.length() != 0) {
                queryParams.append('&');
            }
            queryParams.append(PROJECTAREA_PARAM);
            queryParams.append(EQUALS);
            queryParams.append(this.urlEncode(projectAreaId));
        }
        JSONArray array = this.findItemsByQuery("com.ibm.team.interop.SyncRule", queryParams.toString());
        ArrayList<IRestSyncRule> syncRules = new ArrayList<IRestSyncRule>(array.size());
        for (JSONObject object : array) {
            syncRules.add(new RestSyncRule(object));
        }
        return syncRules;
    }

    private List<IRestSyncRule> findSyncRulesForProjectArea(String projectAreaId) throws InteropClientException {
        StringBuilder queryParams = new StringBuilder("projectArea=" + this.urlEncode(projectAreaId));
        JSONArray array = this.findItemsByQuery("com.ibm.team.interop.SyncRule", queryParams.toString());
        ArrayList<IRestSyncRule> syncRules = new ArrayList<IRestSyncRule>(array.size());
        for (JSONObject object : array) {
            syncRules.add(new RestSyncRule(object));
        }
        return syncRules;
    }

    @Override
    public IInteropProjectAreaDTO getProjectArea(IRestSyncRule syncRule) throws InteropClientException {
        JSONObject handle = ((RestSyncRule)syncRule).getProjectAreaHandle();
        if (handle == null) {
            return null;
        }
        InteropItem item = new InteropItem(this.getItem(new InteropItem(handle)));
        InteropProjectAreaDTO projectArea = this.projectAreaDTOFromItem(item);
        projectArea.setConfigured(true);
        return projectArea;
    }

    @Override
    public IInteropContent storeContent(String contentType, String characterEncoding, InputStream inputStream, long length, long checksum) throws InteropClientException {
        String newLocation;
        if (contentType == null || contentType.length() == 0) {
            throw new IllegalArgumentException("The contentType argument must not be null or empty");
        }
        if (characterEncoding == null || characterEncoding.length() == 0) {
            throw new IllegalArgumentException("The characterEncoding argument must not be null or empty");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("The inputStream argument must not be null");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("The length argument must not be negative");
        }
        String checksumParam = "hashcode=" + Long.toString(checksum);
        String path = this.getContentCollectionLocation(checksumParam);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put(CONTENT_TYPE_HEADER, String.format("%s;charset=%s", contentType, characterEncoding));
        requestHeaders.put(CONTENT_LENGTH_HEADER, Long.toString(length));
        HttpMethod method = null;
        try {
            method = this.doOutputMethod(POST_METHOD, path, requestHeaders, inputStream, 201);
            newLocation = method.getResponseHeader(LOCATION_HEADER).getValue();
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        if (newLocation == null || newLocation.length() == 0) {
            throw new RuntimeException("No Location header returned for content after creation");
        }
        int index = newLocation.lastIndexOf(47);
        if (index == -1) {
            throw new RuntimeException("Invalid Location header value returned");
        }
        String contentId = newLocation.substring(index + 1);
        return new InteropContent(contentId, contentType, characterEncoding, length, checksum);
    }

    @Override
    public void checkLicense(String operationId) throws InteropClientException {
        JSONObject response;
        if (operationId == null || operationId.length() == 0) {
            throw new IllegalArgumentException("The operationId argument must not be null or empty");
        }
        String query = "operationId=" + this.urlEncode(operationId);
        String path = this.getLicenseAdminLocation(CHECK_LICENSE_METHOD, query);
        HttpMethod method = this.getHttpMethod(GET_METHOD, path, ITEM_REST_SERVICE_HEADERS);
        try {
            this.executeHttpMethod(method, 200);
            response = this.getJSONResponse(method);
        }
        finally {
            method.releaseConnection();
        }
        String status = null;
        response = (JSONObject)this.getModelledResponseValue(response, false);
        if (response != null) {
            status = (String)response.get(LICENSE_STATUS_CODE_NAME);
        }
        if (status == null || !status.equals(LICENSE_STATUS_CODE_OK)) {
            String message = MessageFormat.format(Messages.getString("InteropRestClient.ERROR_NOT_LICENSED"), this.fAuthenticator.getPasswordAuthentication().getUserName(), operationId, response.get(LICENSE_STATUS_MESSAGE_NAME));
            throw new InteropNotLicensedException(message);
        }
    }

    @Override
    public List<IInteropProjectAreaDTO> getProjectAreas() throws InteropClientException {
        JSONArray array = this.findVirtualItemsByQuery(IInteropProjectAreaDTO.VIRTUAL_TYPE, null);
        ArrayList<IInteropProjectAreaDTO> projectAreas = new ArrayList<IInteropProjectAreaDTO>(array.size());
        Iterator iterator = array.iterator();
        while (iterator.hasNext()) {
            InteropItem item = new InteropItem((JSONObject)iterator.next());
            projectAreas.add((IInteropProjectAreaDTO)this.projectAreaDTOFromItem(item));
        }
        return projectAreas;
    }

    @Override
    public IInteropProjectAreaDTO findProjectArea(String name) throws InteropClientException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name argument must not be null or empty");
        }
        IVirtual virtual = this.findVirtualItemByName(IInteropProjectAreaDTO.VIRTUAL_TYPE, name);
        if (virtual == null) {
            return null;
        }
        return (IInteropProjectAreaDTO)virtual;
    }

    @Override
    public boolean isUserRegistryWritable() throws InteropClientException {
        String path = this.getAdminLocation(GET_USER_REGISTRY_INFO_METHOD, null);
        HttpMethod method = null;
        JSONObject response = null;
        try {
            method = this.getHttpMethod(GET_METHOD, path, ITEM_REST_SERVICE_HEADERS);
            this.executeHttpMethod(method, 200);
            response = this.getJSONResponse(method);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        JSONObject value = (JSONObject)this.getModelledResponseValue(response, false);
        if (value == null) {
            return false;
        }
        Boolean writable = (Boolean)value.get("writable");
        if (writable == null) {
            return false;
        }
        return writable;
    }

    @Override
    public void createConnectorUser(String userId, String password, String userName, String emailAddress, String licenseId) throws InteropClientException {
        if (userId == null || userId.length() == 0) {
            throw new IllegalArgumentException("The userId argument must not be null or empty");
        }
        if (userName == null || userName.length() == 0) {
            throw new IllegalArgumentException("The userName argument must not be null or empty");
        }
        if (emailAddress == null || emailAddress.length() == 0) {
            throw new IllegalArgumentException("The operationId argument must not be null or empty");
        }
        StringBuilder query = new StringBuilder(String.format("itemId=%s&userId=%s&name=%s&emailAddress=%s&jsonRoles=%s", NEW_ITEM, this.urlEncode(userId), this.urlEncode(userName), this.urlEncode(emailAddress), NEW_USER_ROLES.toString(false)));
        if (password != null) {
            query.append("&password=");
            query.append(this.urlEncode(password));
        }
        if (licenseId != null && licenseId.length() != 0 && !this.isDevTestEnvironmentServer()) {
            JSONArray addLicenses = new JSONArray();
            addLicenses.add(licenseId);
            JSONArray removeLicenses = new JSONArray();
            JSONObject licenses = new JSONObject();
            licenses.put("add", addLicenses);
            licenses.put("remove", removeLicenses);
            query.append("&jsonLicenses=");
            query.append(this.urlEncode(licenses.toString(false)));
        }
        String path = this.getAdminLocation(CREATE_CONTRIBUTOR_METHOD, null);
        HttpMethod method = null;
        try {
            method = this.doFormSubmitMethod(path, query.toString(), 200);
            this.getJSONResponse(method);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public boolean connectorUserExists(String userId, List<String> listOfValidLicenseIDs) throws InteropClientException {
        if (userId == null || userId.length() == 0) {
            throw new IllegalArgumentException("The userId argument must not be null or empty");
        }
        String query = String.format("searchTerm=%s&searchField=userId&hideArchivedUsers=true&pageSize=10", this.urlEncode(userId));
        String path = this.getAdminLocation(SEARCH_CONTRIBUTOR_METHOD, query.toString());
        HttpMethod method = null;
        JSONObject response = null;
        try {
            method = this.getHttpMethod(GET_METHOD, path, ITEM_REST_SERVICE_HEADERS);
            this.executeHttpMethod(method, 200);
            response = this.getJSONResponse(method);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        JSONObject value = (JSONObject)this.getModelledResponseValue(response, false);
        if (value == null) {
            throw new InteropClientException(MessageFormat.format("Invalid response returned from {0}:\n{1}", path, response));
        }
        Number resultCount = (Number)value.get("count");
        if (resultCount == null) {
            throw new InteropClientException(MessageFormat.format("Missing result count from {0}:\n{1}", path, response));
        }
        if (resultCount.intValue() == 0) {
            return false;
        }
        if (resultCount.intValue() > 1) {
            throw new InteropClientException(MessageFormat.format("There is more than one user account with the id \"{0}\"", userId));
        }
        JSONArray results = (JSONArray)value.get("elements");
        JSONObject userInfo = (JSONObject)results.get(0);
        String itemId = (String)userInfo.get("itemId");
        path = this.getAdminLocation(GET_CONTRIBUTOR_BY_UUID_METHOD, String.format("uuid=%s", itemId));
        method = null;
        response = null;
        try {
            method = this.getHttpMethod(GET_METHOD, path, ITEM_REST_SERVICE_HEADERS);
            this.executeHttpMethod(method, 200);
            response = this.getJSONResponse(method);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        JSONArray roles = null;
        value = (JSONObject)this.getModelledResponseValue(response, false);
        if (value != null) {
            roles = (JSONArray)value.get("roles");
        }
        boolean foundRole = false;
        if (roles != null) {
            for (String role : REQUIRED_USER_ROLES) {
                if (!roles.contains(role)) continue;
                foundRole = true;
                break;
            }
        }
        if (!foundRole) {
            throw new InteropClientException(MessageFormat.format(Messages.getString("InteropRestClient.ERROR_MISSING_USER_ROLES"), userId, REQUIRED_USER_ROLES));
        }
        if (listOfValidLicenseIDs != null && !listOfValidLicenseIDs.isEmpty() && !this.isDevTestEnvironmentServer()) {
            path = this.getLicenseAdminLocation(ASSIGNED_LICENSES_METHOD, String.format("userId=%s", this.urlEncode(userId)));
            method = null;
            response = null;
            try {
                method = this.getHttpMethod(GET_METHOD, path, ITEM_REST_SERVICE_HEADERS);
                this.executeHttpMethod(method, 200);
                response = this.getJSONResponse(method);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
            boolean hasLicense = false;
            JSONArray licenses = (JSONArray)this.getModelledResponseValue(response, true);
            if (licenses != null) {
                for (JSONObject license : licenses) {
                    if (!listOfValidLicenseIDs.contains((CharSequence)license.get("id"))) continue;
                    hasLicense = true;
                    break;
                }
            }
            if (!hasLicense) {
                throw new InteropClientException(MessageFormat.format(Messages.getString("InteropRestClient.ERROR_MISSING_LICENSE"), userId, listOfValidLicenseIDs));
            }
        }
        return true;
    }

    @Override
    public IRestExternalRepositoryConnection createExternalRepositoryConnection() {
        return new RestExternalRepositoryConnection();
    }

    @Override
    public void saveExternalRepositoryConnection(IRestExternalRepositoryConnection connection) throws InteropClientException {
        RestExternalRepositoryConnection connectionItem = (RestExternalRepositoryConnection)connection;
        if (connectionItem.isNewItem()) {
            this.createItem(connectionItem, null);
        } else {
            this.saveItem(connectionItem, null);
        }
    }

    @Override
    public IRestExternalRepositoryConnection findExternalRepositoryConnection(String name) throws InteropClientException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name argument must not be null or empty");
        }
        JSONObject object = this.findItemByName("com.ibm.team.interop.ExternalRepositoryConnection", name);
        if (object == null) {
            return null;
        }
        return new RestExternalRepositoryConnection(object);
    }

    @Override
    public List<IRestExternalRepositoryConnection> getAllExternalRepositoryConnections() throws InteropClientException {
        JSONArray array = this.findItemsByQuery("com.ibm.team.interop.ExternalRepositoryConnection", null);
        ArrayList<IRestExternalRepositoryConnection> connections = new ArrayList<IRestExternalRepositoryConnection>(array.size());
        for (JSONObject object : array) {
            connections.add(new RestExternalRepositoryConnection(object));
        }
        return connections;
    }

    @Override
    public IInteropProjectAreaDTO getProjectArea(IRestExternalRepositoryConnection connection) throws InteropClientException {
        if (connection == null) {
            throw new IllegalArgumentException("The connection argument must not be null");
        }
        JSONObject handle = ((RestExternalRepositoryConnection)connection).getProjectAreaHandle();
        if (handle == null) {
            return null;
        }
        InteropItem item = new InteropItem(this.getItem(new InteropItem(handle)));
        InteropProjectAreaDTO projectArea = this.projectAreaDTOFromItem(item);
        List<IRestSyncRule> syncRules = this.findSyncRulesForProjectArea(item.getItemId());
        projectArea.setConfigured(!syncRules.isEmpty());
        return projectArea;
    }

    @Override
    public void generateSyncConfiguration(String projectAreaName, String externalConnectionName, IManagerInfoDTO externalManagerInfo, String itemManagerId, String connectorUserId) throws InteropClientException {
        if (projectAreaName == null || projectAreaName.length() == 0) {
            throw new IllegalArgumentException("The projectAreaName argument must not be null or empty");
        }
        if (externalConnectionName == null || externalConnectionName.length() == 0) {
            throw new IllegalArgumentException("The externalConnectionName argument must not be null or empty");
        }
        if (externalManagerInfo == null) {
            throw new IllegalArgumentException("The externalManagerInfo argument must not be null");
        }
        InteropSyncConfigRequestDTO request = DtoFactory.eINSTANCE.createInteropSyncConfigRequestDTO();
        this.setVirtualLocation((IVirtual)request, projectAreaName);
        request.setProjectAreaName(projectAreaName);
        request.setExternalConnectionName(externalConnectionName);
        request.setItemManagerId(itemManagerId);
        request.setConnectorUserId(connectorUserId);
        request.setExternalManagerInfo(this.copyManagerInfo(externalManagerInfo));
        String path = this.getVirtualCollectionLocation(InteropSyncConfigRequestDTO.class.getSimpleName(), null);
        HttpMethod method = null;
        try {
            method = this.getHttpMethod(POST_METHOD, path, ITEM_REST_SERVICE_HEADERS);
            EntityEnclosingMethod writeMethod = (EntityEnclosingMethod)method;
            StringRequestEntity stringEntity = null;
            try {
                stringEntity = new StringRequestEntity(this.serializeVirtual((IVirtual)request), JSON_MEDIA_TYPE, UTF8_CHARSET_NAME);
            }
            catch (UnsupportedEncodingException e) {
                String msg = MessageFormat.format(Messages.getString("InteropRestClient.ERROR_UNSUPPORTED_ENCODING"), e.getMessage());
                throw new InteropClientException(msg);
            }
            catch (Exception e) {
                throw new InteropClientException(e);
            }
            writeMethod.setRequestEntity((RequestEntity)stringEntity);
            this.executeHttpMethod(method, 201);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private InteropProjectAreaDTO projectAreaDTOFromItem(InteropItem item) {
        InteropProjectAreaDTO projectArea = DtoFactory.eINSTANCE.createInteropProjectAreaDTO();
        projectArea.setItemId(item.getItemId());
        projectArea.setName(item.getName());
        Boolean configured = (Boolean)item.get(DtoPackage.eINSTANCE.getInteropProjectAreaDTO_Configured().getName());
        projectArea.setConfigured(configured == null ? false : configured);
        return projectArea;
    }

    private URL createItem(InteropItem item, String query) throws InteropClientException {
        String newLocation;
        String path = this.getCollectionLocation(this.urlEncode(item.getItemTypeName()), query);
        HttpMethod method = null;
        try {
            method = this.doItemMethod(POST_METHOD, path, item, 201);
            newLocation = method.getResponseHeader(LOCATION_HEADER).getValue();
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        if (newLocation == null || newLocation.length() == 0) {
            throw new RuntimeException("No Location header returned for item after creation");
        }
        try {
            return new URL(newLocation);
        }
        catch (MalformedURLException e) {
            throw new InteropClientException(e.getMessage(), e);
        }
    }

    private void saveItem(InteropItem item, String query) throws InteropClientException {
        String path = this.getItemLocation(item, query);
        item.setWorkingCopy(true);
        HttpMethod method = null;
        try {
            method = this.doItemMethod(PUT_METHOD, path, item, 204);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private JSONObject getItem(InteropItem item) throws InteropClientException {
        return this.getItem(this.getItemLocation(item, null));
    }

    private InteropItem getItem(String path) throws InteropClientException {
        InteropItem item;
        HttpMethod method = null;
        try {
            method = this.doItemMethod(GET_METHOD, path, null, 200);
            item = this.getItemResponse(method);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return item;
    }

    private JSONObject findItemByName(String itemType, String name) throws InteropClientException {
        String path = this.getNamedLocation(itemType, name, null);
        HttpMethod method = null;
        try {
            method = this.doItemMethod(GET_METHOD, path, null, 0);
            if (method.getStatusCode() == 404) {
                return null;
            }
            this.generateExceptionIfError(method, 200);
            InteropItem interopItem = this.getItemResponse(method);
            return interopItem;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private IVirtual findVirtualItemByName(IVirtualType type, String name) throws InteropClientException {
        String path = this.getVirtualNamedLocation(type.getName(), name, null);
        HttpMethod method = null;
        try {
            method = this.doItemMethod(GET_METHOD, path, null, 0);
            if (method.getStatusCode() == 404) {
                return null;
            }
            this.generateExceptionIfError(method, 200);
            IVirtual iVirtual = this.deserializeVirtual(type, method);
            return iVirtual;
        }
        catch (Exception e) {
            throw new InteropClientException(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    protected JSONArray doItemMethodInternal(String methodName, String path, InteropItem item, int expectedStatus) throws InteropClientException {
        HttpMethod method = null;
        try {
            method = this.doItemMethod(GET_METHOD, path, null, 200);
            JSONArray jSONArray = JSONArray.parse(this.getResponseReader(method));
            return jSONArray;
        }
        catch (IOException e) {
            throw new InteropClientException(e.getMessage(), e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private JSONArray findItemsByQuery(String itemType, String query) throws InteropClientException {
        String path = this.getCollectionLocation(this.urlEncode(itemType), query);
        return this.doItemMethodInternal(GET_METHOD, path, null, 200);
    }

    private JSONArray findVirtualItemsByQuery(IVirtualType type, String query) throws InteropClientException {
        String path = this.getVirtualCollectionLocation(type.getName(), query);
        HttpMethod method = null;
        try {
            method = this.doItemMethod(GET_METHOD, path, null, 200);
            JSONArray jSONArray = JSONArray.parse(this.getResponseReader(method));
            return jSONArray;
        }
        catch (IOException e) {
            throw new InteropClientException(e.getMessage(), e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private void deleteItem(InteropItem item) throws InteropClientException {
        String path = this.getItemLocation(item, null);
        HttpMethod method = null;
        try {
            method = this.doItemMethod(DELETE_METHOD, path, null, 204);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private String getServiceConfigurationPropertyValue(String serviceName, String propertyName) throws InteropClientException {
        JSONObject response;
        String query = "implementationClassName=" + this.urlEncode(serviceName);
        String path = this.getServerConfigurationLocation(SERVICE_CONFIGURATION_METHOD, query);
        HttpMethod method = this.getHttpMethod(GET_METHOD, path, ITEM_REST_SERVICE_HEADERS);
        try {
            this.executeHttpMethod(method, 200);
            response = this.getJSONResponse(method);
        }
        finally {
            method.releaseConnection();
        }
        ArrayList properties = null;
        String value = null;
        response = (JSONObject)this.getModelledResponseValue(response, false);
        if (response != null) {
            properties = (JSONArray)response.get("properties");
        }
        if (properties != null) {
            for (JSONObject property : properties) {
                String name = (String)property.get("name");
                if (!propertyName.equals(name)) continue;
                value = (String)property.get("overrideValue");
                if (value != null) break;
                value = (String)property.get("defaultValue");
                break;
            }
        }
        return value;
    }

    private InteropItem getItemResponse(HttpMethod method) throws InteropClientException {
        String eTag;
        JSONObject object = this.getJSONResponse(method);
        InteropItem item = new InteropItem(object);
        Header eTagHeader = method.getResponseHeader(ETAG_HEADER);
        if (eTagHeader != null && (eTag = eTagHeader.getValue()) != null) {
            item.setETag(eTag);
        }
        return item;
    }

    private JSONObject getJSONResponse(HttpMethod method) throws InteropClientException {
        try {
            return JSONObject.parse(this.getResponseReader(method));
        }
        catch (Exception e) {
            throw new InteropClientException(e.getMessage(), e);
        }
    }

    private Object getModelledResponseValue(JSONObject response, boolean multiple) {
        Object value = null;
        if ((response = (JSONObject)response.get("soapenv:Body")) != null) {
            response = (JSONObject)response.get("response");
        }
        if (response != null) {
            response = (JSONObject)response.get("returnValue");
        }
        if (response != null) {
            value = response.get(multiple ? "values" : "value");
        }
        return value;
    }

    protected HttpMethod doItemMethod(String methodName, String path, InteropItem item, int expectedStatus) throws InteropClientException {
        HttpMethod method = this.getHttpMethod(methodName, path, ITEM_REST_SERVICE_HEADERS);
        if ((method instanceof PutMethod || method instanceof PostMethod) && item == null) {
            throw new IllegalStateException("item must not be null");
        }
        if (method instanceof PutMethod || method instanceof PostMethod) {
            if (item.getETag() != null) {
                method.addRequestHeader(IF_MATCH_HEADER, item.getETag());
            }
            EntityEnclosingMethod writeMethod = (EntityEnclosingMethod)method;
            StringRequestEntity stringEntity = null;
            try {
                stringEntity = new StringRequestEntity(item.toString(), JSON_MEDIA_TYPE, UTF8_CHARSET_NAME);
            }
            catch (UnsupportedEncodingException e) {
                String msg = MessageFormat.format(Messages.getString("InteropRestClient.ERROR_UNSUPPORTED_ENCODING"), e.getMessage());
                throw new InteropClientException(msg);
            }
            writeMethod.setRequestEntity((RequestEntity)stringEntity);
        }
        this.executeHttpMethod(method, expectedStatus);
        return method;
    }

    private void generateExceptionIfError(HttpMethod method, int expectedStatus) throws InteropClientException {
        int statusCode = method.getStatusCode();
        if (expectedStatus == 0 || statusCode == expectedStatus) {
            return;
        }
        InteropClientException ex = null;
        JSONObject obj = null;
        try {
            obj = JSONObject.parse(this.getResponseReader(method));
        }
        catch (IOException iOException) {}
        if (obj != null) {
            ex = this.createException(obj);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(MessageFormat.format(Messages.getString("InteropRestClient.ERROR_UNEXPECTED_HTTP_STATUS"), method.getName(), Integer.toString(statusCode), Integer.toString(expectedStatus)));
            ex = new InteropClientException(sb.toString());
        }
        throw ex;
    }

    private InteropClientException createException(JSONObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException("obj must not be null");
        }
        String msg = (String)obj.get(ERROR_MSG_KEY);
        JSONArray trace = (JSONArray)obj.get(ERROR_TRACE_MARSHALL_KEY);
        ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>();
        if (trace != null) {
            for (Object traceElem : trace) {
                if (!(traceElem instanceof JSONObject)) {
                    throw new IllegalStateException("Unexpected object in response: " + traceElem.getClass().getName());
                }
                JSONObject traceObj = (JSONObject)traceElem;
                StackTraceElement elem = new StackTraceElement((String)traceObj.get(ERROR_TRACE_CLASSNAME), (String)traceObj.get(ERROR_TRACE_METHODNAME), (String)traceObj.get(ERROR_TRACE_FILENAME), ((Long)traceObj.get(ERROR_TRACE_LINENUM)).intValue());
                stackTrace.add(elem);
            }
        }
        JSONObject nestedObj = (JSONObject)obj.get(NESTED_ERROR_KEY);
        InteropClientException nestedException = null;
        if (nestedObj != null) {
            nestedException = this.createException(nestedObj);
        }
        InteropClientException ex = null;
        ex = nestedException == null ? new InteropClientException(msg) : new InteropClientException(msg, nestedException);
        if (!stackTrace.isEmpty()) {
            ex.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
        }
        return ex;
    }

    private int executeHttpMethod(HttpMethod method, int expectedStatus) throws InteropClientException {
        if (method == null) {
            throw new IllegalArgumentException("httpMethod must not be null");
        }
        int statusCode = 0;
        HttpClient httpClient = this.getHttpClient();
        try {
            method.setFollowRedirects(false);
            statusCode = httpClient.executeMethod(method);
        }
        catch (IOException e) {
            throw new InteropClientException(e.getMessage(), e);
        }
        if (this.fAuthMethod == null) {
            try {
                this.fAuthMethod = TransportAuthUtil.determineAuthMethod((HttpClient)httpClient, (String)this.fRepoPath);
            }
            catch (TransportAuthException e) {
                throw new InteropClientException(e.getMessage(), e.getCause());
            }
        }
        if (this.fAuthMethod.equals("FORM") && TransportAuthUtil.formAuthRequested((HttpMethod)method)) {
            Header noRetryHeader = method.getRequestHeader("X-com-ibm-team-repository.common.remoteaccess.noRetry");
            if (noRetryHeader != null && noRetryHeader.getValue().equals(String.valueOf(true))) {
                String message = MessageFormat.format(Messages.getString("InteropRestClient.ERROR_UNEXPECTED_AUTH_ERROR"), String.valueOf(httpClient.getHostConfiguration().getHostURL()) + method.getPath());
                throw new InteropClientException(message);
            }
            UsernamePasswordCredentials storedCredentials = (UsernamePasswordCredentials)httpClient.getState().getCredentials(this.getAuthScope());
            if (TransportAuthUtil.credDefined((UsernamePasswordCredentials)storedCredentials)) {
                try {
                    TransportAuthUtil.formBasedAuthenticate((String)this.fRepoPath, (HttpClient)httpClient, (UsernamePasswordCredentials)storedCredentials, (HttpState)httpClient.getState());
                }
                catch (TransportAuthException e) {
                    throw new InteropClientException(e.getMessage(), e.getCause());
                }
                method.releaseConnection();
                method.setRequestHeader(CONNECTION_HEADER, CLOSE_CONNECTION);
                method.setRequestHeader("X-com-ibm-team-repository.common.remoteaccess.noRetry", String.valueOf(true));
                return this.executeHttpMethod(method, expectedStatus);
            }
            InteropRestClient.throwEmptyCredsException(storedCredentials);
        }
        if (statusCode == 302) {
            URL url = this.getRedirectURL(method);
            method.releaseConnection();
            method.setRequestHeader(CONNECTION_HEADER, CLOSE_CONNECTION);
            method.setPath(this.getPath(url));
            return this.executeHttpMethod(method, expectedStatus);
        }
        this.fServerInfo = method.getResponseHeader(SERVER_HEADER);
        this.generateExceptionIfError(method, expectedStatus);
        return statusCode;
    }

    private URL getRedirectURL(HttpMethod method) throws InteropClientException {
        String location = method.getResponseHeader(LOCATION_HEADER).getValue();
        if (location == null) {
            String msg = Messages.getString("InteropRestClient.ERROR_EMPTY_REDIRECT_LOCATION");
            throw new InteropClientException(msg);
        }
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            throw new InteropClientException(e.getMessage(), e);
        }
        HostConfiguration hostConfiguration = this.getHttpClient().getHostConfiguration();
        if (hostConfiguration.getProtocol().getScheme().equals(HTTP) && url.getProtocol().equals(HTTPS)) {
            throw new InteropClientException(MessageFormat.format(Messages.getString("InteropRestClient.ERROR_INSECURE_HTTP_CONNECTION"), HTTP, HTTPS));
        }
        if (!hostConfiguration.getProtocol().getScheme().equals(url.getProtocol()) || !hostConfiguration.getHost().equals(url.getHost()) || hostConfiguration.getPort() != url.getPort()) {
            throw new InteropClientException(MessageFormat.format(Messages.getString("InteropRestClient.ERROR_UNSUPPORTED_REDIRECT"), location));
        }
        return url;
    }

    private Reader getResponseReader(HttpMethod method) throws IOException {
        String charset = ((HttpMethodBase)method).getResponseCharSet();
        return new InputStreamReader(method.getResponseBodyAsStream(), charset);
    }

    private static void throwEmptyCredsException(UsernamePasswordCredentials storedCredentials) throws InteropClientException {
        String username = null;
        String password = null;
        if (storedCredentials != null) {
            username = storedCredentials.getUserName();
            password = storedCredentials.getPassword();
            if (username.length() == 0) {
                username = null;
            }
            if (password.length() == 0) {
                password = null;
            }
        }
        String msg = null;
        msg = username == null && password == null ? Messages.getString("InteropRestClient.ERROR_MISSING_USERNAME_PASSWORD") : (username == null ? Messages.getString("InteropRestClient.ERROR_MISSING_USERNAME") : Messages.getString("InteropRestClient.ERROR_MISSING_PASSWORD"));
        throw new InteropClientException(msg);
    }

    private HttpMethod doOutputMethod(String methodName, String path, Map<String, String> requestHeaders, InputStream inputStream, int expectedStatus) throws InteropClientException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        EntityEnclosingMethod method = (EntityEnclosingMethod)this.getHttpMethod(POST_METHOD, path, requestHeaders);
        InputStreamRequestEntity request = new InputStreamRequestEntity(inputStream);
        method.setRequestEntity((RequestEntity)request);
        this.executeHttpMethod((HttpMethod)method, expectedStatus);
        return method;
    }

    private HttpMethod doFormSubmitMethod(String path, String params, int expectedStatus) throws InteropClientException {
        byte[] queryBytes;
        try {
            queryBytes = params.toString().getBytes(UTF8_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new InteropClientException("Unexpected encoding error", e);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(queryBytes);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put(CONTENT_TYPE_HEADER, String.format("%s;charset=%s", FORM_URLENCODED_MEDIA_TYPE, UTF8_CHARSET_NAME));
        requestHeaders.put(CONTENT_LENGTH_HEADER, Long.toString(queryBytes.length));
        requestHeaders.put(ACCEPT_HEADER, JSON_MEDIA_TYPE);
        requestHeaders.put(ACCEPT_CHARSET_HEADER, UTF8_CHARSET_NAME);
        return this.doOutputMethod(POST_METHOD, path, requestHeaders, inputStream, expectedStatus);
    }

    private IManagerInfoDTO copyManagerInfo(IManagerInfoDTO managerInfo) {
        IManagerInfoDTO managerInfoCopy = (IManagerInfoDTO)EcoreUtil.copy((EObject)((EObject)managerInfo));
        this.setVirtualLocation((IVirtual)managerInfoCopy, managerInfo.getId());
        for (ITypeInfoDTO typeInfo : managerInfoCopy.getTypeInfo()) {
            this.setVirtualLocation((IVirtual)typeInfo, typeInfo.getName());
            List propertyInfoList = typeInfo.getProperties();
            for (IPropertyInfoDTO propertyInfo : propertyInfoList) {
                this.setVirtualLocation((IVirtual)propertyInfo, propertyInfo.getName());
            }
        }
        return managerInfoCopy;
    }

    private void setVirtualLocation(IVirtual virtual, String name) {
        Location loc = Location.pathLocation((IVirtualType)virtual.getVirtualType(), null, (String[])new String[]{name});
        ((VirtualImpl)virtual).setLocation(loc.toRelativeUri().toString());
    }

    private String serializeVirtual(IVirtual virtual) throws TeamRepositoryException, IOException {
        ISerializer2 serializer = ISerializer2.FACTORY.newInstance(HttpUtil.MediaType.JSON, this.fServerRootUrl, false, sVirtualUriSerializer);
        StringWriter writer = new StringWriter();
        serializer.serialize(virtual, (Writer)writer);
        return writer.toString();
    }

    private IVirtual deserializeVirtual(IVirtualType type, HttpMethod method) throws SerializeException, IOException {
        IDeserializer2 deserializer = IDeserializer2.FACTORY.newInstance(HttpUtil.MediaType.JSON, null);
        return deserializer.deserializeVirtual(type, this.getResponseReader(method));
    }

    private String getItemLocation(InteropItem item, String query) {
        String path = item.getUri();
        if (path != null) {
            return this.getLocation(ITEM_REST_SERVICE_PREFIX, SLASH + path, query);
        }
        return this.getLocation(ITEM_REST_SERVICE_PREFIX, "/com.ibm.team.repository/itemOid/" + this.urlEncode(item.getItemTypeName()) + SLASH + item.getItemId(), query);
    }

    private String getNamedLocation(String itemTypeName, String name, String query) {
        return this.getLocation(ITEM_REST_SERVICE_PREFIX, "/com.ibm.team.repository/itemName/" + this.urlEncode(itemTypeName) + SLASH + this.urlEncode(name), query);
    }

    private String getVirtualNamedLocation(String typeName, String name, String query) {
        return this.getLocation(VIRTUAL_REST_SERVICE_PREFIX, "/virtualPath/" + this.urlEncode(typeName) + SLASH + this.urlEncode(name), query);
    }

    public String getCollectionLocation(String itemTypeName, String query) {
        return this.getLocation(ITEM_REST_SERVICE_PREFIX, "/com.ibm.team.repository/itemCol/" + itemTypeName, query);
    }

    private String getVirtualCollectionLocation(String typeName, String query) {
        return this.getLocation(VIRTUAL_REST_SERVICE_PREFIX, "/virtualCol/" + this.urlEncode(typeName), query);
    }

    private String getContentCollectionLocation(String query) {
        return this.getLocation(CONTENT_REST_SERVICE_PREFIX, null, query);
    }

    private String getLicenseAdminLocation(String method, String query) {
        return this.getLocation(LICENSE_ADMIN_REST_SERVICE_PREFIX, method, query);
    }

    private String getServerConfigurationLocation(String method, String query) {
        return this.getLocation(SERVER_CONFIGURATION_REST_SERVICE_PREFIX, method, query);
    }

    private String getAdminLocation(String method, String query) {
        return this.getLocation(ADMIN_REST_SERVICE_PREFIX, method, query);
    }

    private String getLocation(String service, String serviceRelPath, String query) {
        StringBuilder s = new StringBuilder(this.fRepoPath);
        s.append(service);
        if (serviceRelPath != null) {
            s.append(serviceRelPath);
        }
        if (query != null && query.length() != 0) {
            s.append('?');
            s.append(query);
        }
        return s.toString();
    }

    private String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, UTF8_CHARSET_NAME).replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized HttpClient getHttpClient() throws InteropClientException {
        if (this.fHttpClient != null) {
            return this.fHttpClient;
        }
        URL url = null;
        try {
            url = new URL(this.fServerRootUrl);
        }
        catch (MalformedURLException e) {
            throw new InteropClientException(e.getMessage(), e);
        }
        String repoProtocol = url.getProtocol();
        String repoHost = url.getHost();
        int defaultPort = url.getDefaultPort();
        int repoPort = url.getPort();
        if (repoPort == -1) {
            repoPort = defaultPort;
        }
        HttpConnectionManagerParams connectionManagerParams = new HttpConnectionManagerParams();
        connectionManagerParams.setDefaultMaxConnectionsPerHost(1000);
        connectionManagerParams.setMaxTotalConnections(1000);
        connectionManagerParams.setTcpNoDelay(true);
        connectionManagerParams.setLinger(-1);
        connectionManagerParams.setStaleCheckingEnabled(true);
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.setParams(connectionManagerParams);
        HostConfiguration hostConfiguration = new HostConfiguration();
        if (HTTPS.equalsIgnoreCase(repoProtocol)) {
            String autoAccept = System.getProperty(AUTO_ACCEPT_SSL_CONNECTIONS_PROPERTY, Boolean.TRUE.toString());
            Object socketFactory = null;
            socketFactory = Boolean.parseBoolean(autoAccept) ? LenientSecureProtocolSocketFactory.getFactory() : new SSLProtocolSocketFactory();
            Protocol httpsProtocol = new Protocol(HTTPS, socketFactory, defaultPort);
            hostConfiguration.setHost(repoHost, repoPort, httpsProtocol);
        } else {
            Protocol protocol = new Protocol(HTTP, (ProtocolSocketFactory)new DefaultProtocolSocketFactory(), defaultPort);
            hostConfiguration.setHost(repoHost, repoPort, protocol);
        }
        this.fHttpClient = new HttpClient((HttpConnectionManager)connectionManager);
        this.fHttpClient.setHostConfiguration(hostConfiguration);
        String userid = null;
        String password = null;
        if (this.fAuthenticator != null) {
            userid = this.fAuthenticator.getPasswordAuthentication().getUserName();
            password = String.valueOf(this.fAuthenticator.getPasswordAuthentication().getPassword());
        }
        TransportAuthUtil.setCredentials((HttpClient)this.fHttpClient, (AuthScope)this.getAuthScope(), (String)userid, password);
        return this.fHttpClient;
    }

    private AuthScope getAuthScope() {
        URL url = null;
        try {
            url = new URL(this.fServerRootUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(MessageFormat.format("URL \"{0}\" is malformed: {1}", this.fServerRootUrl, e.getMessage()));
        }
        String repoProtocol = url.getProtocol();
        String repoHost = url.getHost();
        int repoPort = url.getPort();
        if (-1 == repoPort) {
            repoPort = url.getDefaultPort();
        }
        if (repoProtocol == null) {
            throw new IllegalArgumentException(MessageFormat.format("URL \"{0}\" must have a protocol defined", url));
        }
        if (repoHost == null) {
            throw new IllegalArgumentException(MessageFormat.format("URL \"{0}\" must have a host defined", url));
        }
        if (-1 == repoPort) {
            throw new IllegalArgumentException(MessageFormat.format("URL \"{0}\" must have a port defined", url));
        }
        return new AuthScope(repoHost, repoPort, AuthScope.ANY_REALM);
    }

    private HttpMethod getHttpMethod(String methodName, String path, Map<String, String> requestHeaders) {
        GetMethod method = null;
        if (methodName.equals(GET_METHOD)) {
            method = new GetMethod();
        } else if (methodName.equals(DELETE_METHOD)) {
            method = new DeleteMethod();
        } else if (methodName.equals(PUT_METHOD)) {
            method = new PutMethod();
        } else if (methodName.equals(POST_METHOD)) {
            method = new PostMethod();
        } else {
            throw new IllegalStateException("Unrecognized method name");
        }
        method.setPath(path);
        for (Map.Entry<String, String> header : requestHeaders.entrySet()) {
            method.addRequestHeader(header.getKey(), header.getValue());
        }
        if (this.fAuthenticator != null) {
            method.addRequestHeader(X_USERID_HEADER, this.fAuthenticator.getPasswordAuthentication().getUserName());
        }
        return method;
    }

    private String getPath(URL loc) throws InteropClientException {
        assert (loc != null);
        try {
            URI uri = loc.toURI();
            return new URI(null, null, uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
        }
        catch (URISyntaxException e1) {
            throw new InteropClientException(e1.getMessage(), e1);
        }
    }

    private boolean isDevTestEnvironmentServer() {
        return this.fServerInfo != null && this.fServerInfo.getValue().contains("Jetty");
    }
}

