/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.client.rest.internal;

import com.ibm.team.interop.client.rest.IRestPropertyMapping;
import com.ibm.team.interop.client.rest.IRestSyncRule;
import com.ibm.team.interop.client.rest.internal.InteropItem;
import com.ibm.team.interop.client.rest.internal.InteropProjectAreaHandle;
import com.ibm.team.interop.client.rest.internal.RestPropertyMapping;
import com.ibm.team.interop.client.rest.json.JSONArray;
import com.ibm.team.interop.client.rest.json.JSONObject;
import com.ibm.team.interop.common.dto.IInteropProjectAreaDTO;
import java.util.ArrayList;
import java.util.List;

public class RestSyncRule
extends InteropItem
implements IRestSyncRule {
    static final String SYNCRULE_ITEM_TYPE = "com.ibm.team.interop.SyncRule";
    static final String QUALIFIED_CLASS_NAME = "com.ibm.team.interop:SyncRule";
    private static final String NAME_PROPERTY = "name";
    private static final String EXTERNAL_TYPE_NAME_PROPERTY = "externalTypeName";
    private static final String PROJECT_AREA_PROPERTY = "projectArea";
    private static final String PROPERTY_MAPPINGS_PROPERTY = "propertyMappings";
    private static final String SYNC_ITEM_TYPE_NAME_PROPERTY = "syncItemTypeName";
    private static final String SYNC_ITEM_TYPE_NS_URI_PROPERTY = "syncItemTypeNsURI";
    private static final long serialVersionUID = 7306739929553237536L;

    public RestSyncRule() {
        this.setItemTypeName(SYNCRULE_ITEM_TYPE);
        this.setQualifiedClassName(QUALIFIED_CLASS_NAME);
    }

    public RestSyncRule(JSONObject other) {
        super(other);
    }

    @Override
    public String getName() {
        return (String)this.get(NAME_PROPERTY);
    }

    @Override
    public void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name argument must not be null or empty");
        }
        this.put(NAME_PROPERTY, name);
    }

    @Override
    public String getExternalTypeName() {
        return (String)this.get(EXTERNAL_TYPE_NAME_PROPERTY);
    }

    @Override
    public void setExternalTypeName(String externalTypeName) {
        if (externalTypeName == null || externalTypeName.length() == 0) {
            throw new IllegalArgumentException("The externalTypeName argument must not be null or empty");
        }
        this.put(EXTERNAL_TYPE_NAME_PROPERTY, externalTypeName);
    }

    @Override
    public String getSyncItemTypeName() {
        String name = (String)this.get(SYNC_ITEM_TYPE_NAME_PROPERTY);
        String nsURI = (String)this.get(SYNC_ITEM_TYPE_NS_URI_PROPERTY);
        if (name == null) {
            return null;
        }
        return String.valueOf(nsURI == null ? "?" : nsURI) + "." + name;
    }

    @Override
    public List<IRestPropertyMapping> getPropertyMappings() {
        ArrayList<IRestPropertyMapping> mappingsList = new ArrayList<IRestPropertyMapping>();
        JSONArray mappingsArray = (JSONArray)this.get(PROPERTY_MAPPINGS_PROPERTY);
        if (mappingsArray == null || mappingsArray.size() == 0) {
            return mappingsList;
        }
        for (JSONObject object : mappingsArray) {
            mappingsList.add(new RestPropertyMapping(object));
        }
        return mappingsList;
    }

    @Override
    public void setProjectArea(IInteropProjectAreaDTO projectArea) {
        if (projectArea == null) {
            throw new IllegalArgumentException("The projectArea argument must not be null");
        }
        InteropProjectAreaHandle handle = new InteropProjectAreaHandle(projectArea.getItemId());
        this.put(PROJECT_AREA_PROPERTY, handle);
    }

    JSONObject getProjectAreaHandle() {
        return (JSONObject)this.get(PROJECT_AREA_PROPERTY);
    }
}

