/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IProviderConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.ProviderType;
import java.util.HashMap;
import java.util.Map;

public class ProviderConfiguration
implements IProviderConfiguration {
    private final Map<ProviderType, IConfiguration> fConfigurations = new HashMap<ProviderType, IConfiguration>();

    public ProviderConfiguration(IConfiguration ... configurations) {
        IConfiguration[] iConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration configuration = iConfigurationArray[n2];
            this.addConfiguration(configuration);
            ++n2;
        }
    }

    public void addConfiguration(IConfiguration configuration) {
        ProviderType providerType = ProviderType.fromId(configuration.getElementName());
        if (providerType != null) {
            this.fConfigurations.put(providerType, configuration);
        }
    }

    @Override
    public IConfiguration getValueProvider() {
        return this.fConfigurations.get((Object)ProviderType.VALUE_PROVIDER);
    }

    @Override
    public IConfiguration getValueSetProvider() {
        return this.fConfigurations.get((Object)ProviderType.VALUE_SET_PROVIDER);
    }

    @Override
    public IConfiguration getDefaultValueProvider() {
        return this.fConfigurations.get((Object)ProviderType.DEFAULT_VALUE_PROVIDER);
    }

    @Override
    public IConfiguration getValidator() {
        return this.fConfigurations.get((Object)ProviderType.VALIDATOR);
    }
}

