/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.HashMap;
import java.util.Map;

public class BOMAwareInputStream
extends InputStream {
    private static Map<String, BOM> bomMap = new HashMap<String, BOM>();
    private final PushbackInputStream fPushbackStream;
    private final BOM fBom;

    static {
        bomMap.put("utf-8", BOM.UTF_8);
        bomMap.put("utf-16be", BOM.UTF_16_BE);
        bomMap.put("utf-16le", BOM.UTF_16_LE);
        bomMap.put("utf-32be", BOM.UTF_32_BE);
        bomMap.put("utf-32le", BOM.UTF_32_LE);
    }

    private static boolean isPrefix(byte[] array, byte[] prefix) {
        if (array.length < prefix.length) {
            return false;
        }
        int i = 0;
        while (i < prefix.length) {
            if (array[i] != prefix[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public BOMAwareInputStream(InputStream inputStream, String charset) throws NullPointerException, IOException {
        if (inputStream == null) {
            throw new NullPointerException("input stream must not be null");
        }
        if (charset == null) {
            throw new NullPointerException("charset must not be null");
        }
        BOM bom = bomMap.get(charset.toLowerCase());
        if (bom == null) {
            throw new IllegalArgumentException("cannot handle charset " + charset);
        }
        this.fPushbackStream = new PushbackInputStream(inputStream, 4);
        byte[] buf = new byte[4];
        int read = this.fPushbackStream.read(buf);
        this.fBom = read >= bom.fBytes.length && BOMAwareInputStream.isPrefix(buf, bom.fBytes) ? bom : BOM.NONE;
        if (read > 0) {
            this.fPushbackStream.unread(buf, 0, read);
        }
        this.fPushbackStream.skip(this.fBom.fBytes.length);
    }

    public boolean hasBOM() {
        return this.fBom != BOM.NONE;
    }

    public BOM getBOM() {
        return this.fBom;
    }

    @Override
    public int available() throws IOException {
        return this.fPushbackStream.available();
    }

    @Override
    public void close() throws IOException {
        this.fPushbackStream.close();
    }

    public boolean equals(Object obj) {
        return this.fPushbackStream.equals(obj);
    }

    public int hashCode() {
        return this.fPushbackStream.hashCode();
    }

    @Override
    public void mark(int readlimit) {
        this.fPushbackStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.fPushbackStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.fPushbackStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.fPushbackStream.read(b, off, len);
    }

    @Override
    public int read(byte[] arg0) throws IOException {
        return this.fPushbackStream.read(arg0);
    }

    @Override
    public void reset() throws IOException {
        this.fPushbackStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.fPushbackStream.skip(n);
    }

    public String toString() {
        return this.fPushbackStream.toString();
    }

    public void unread(byte[] b, int off, int len) throws IOException {
        this.fPushbackStream.unread(b, off, len);
    }

    public void unread(byte[] b) throws IOException {
        this.fPushbackStream.unread(b);
    }

    public void unread(int b) throws IOException {
        this.fPushbackStream.unread(b);
    }

    public static final class BOM
    extends Enum<BOM> {
        public static final /* enum */ BOM NONE = new BOM(new byte[0]);
        public static final /* enum */ BOM UTF_8 = new BOM(new byte[]{-17, -69, -65});
        public static final /* enum */ BOM UTF_16_LE = new BOM(new byte[]{-1, -2});
        public static final /* enum */ BOM UTF_16_BE = new BOM(new byte[]{-2, -1});
        public static final /* enum */ BOM UTF_32_LE;
        public static final /* enum */ BOM UTF_32_BE;
        private final byte[] fBytes;
        private static final /* synthetic */ BOM[] ENUM$VALUES;

        static {
            byte[] byArray = new byte[4];
            byArray[0] = -1;
            byArray[1] = -2;
            UTF_32_LE = new BOM(byArray);
            byte[] byArray2 = new byte[4];
            byArray2[2] = -2;
            byArray2[3] = -1;
            UTF_32_BE = new BOM(byArray2);
            ENUM$VALUES = new BOM[]{NONE, UTF_8, UTF_16_LE, UTF_16_BE, UTF_32_LE, UTF_32_BE};
        }

        private BOM(byte[] bytes) {
            this.fBytes = bytes;
        }

        public static BOM[] values() {
            BOM[] bOMArray = ENUM$VALUES;
            int n = bOMArray.length;
            BOM[] bOMArray2 = new BOM[n];
            System.arraycopy(ENUM$VALUES, 0, bOMArray2, 0, n);
            return bOMArray2;
        }

        public static BOM valueOf(String string) {
            return Enum.valueOf(BOM.class, string);
        }
    }
}

